/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.links;

import com.ibm.team.process.internal.common.links.Messages;

public class LinkTypes {
    public static final String IMPLEMENTS = "implements";
    public static final String IMPLEMENTED_BY = "implemented-by";
    public static final String VALIDATES = "validates";
    public static final String VALIDATED_BY = "validated-by";
    public static final String TESTS = "tests";
    public static final String TESTED_BY = "tested-by";
    public static final String RELATED_TO = "related-to";
    public static final String TRACKS = "tracks";
    public static final String TRACKED_BY = "tracked-by";
    public static final String TRACKS_CHANGES = "tracks-changes";
    public static final String CHANGES_TRACKED_BY = "changes-tracked-by";
    public static final String TRACKS_RM = "tracks-rm";
    public static final String TRACKED_BY_CM = "tracked-by-cm";
    public static final String ELABORATES = "elaborates";
    public static final String ELABORATED_BY = "elaborated-by";
    public static final String ARCHITECTS = "architects";
    public static final String ARCHITECTED_BY = "architected-by";
    public static final String VALIDATED_BY_AM = "validated-by-am";
    public static final String VALIDATES_AM = "validates-am";
    public static final String RELATED_TO_RM = "related-to-rm";
    public static final String AUTOMATES = "automates";
    public static final String AUTOMATED_BY = "automated-by";
    private static final String QM_SERVICE_PROVIDERS = "qmServiceProviders";
    private static final String CM_SERVICE_PROVIDERS = "cmServiceProviders";
    private static final String RM_SERVICE_PROVIDERS = "rmServiceProviders";
    private static final String SCM_SERVICE_PROVIDERS = "scmServiceProviders";
    private static final String AM_SERVICE_PROVIDERS = "amServiceProviders";
    private static final String AUTO_SERVICE_PROVIDERS = "autoServiceProviders";
    public static final String[] PROVIDERS = new String[]{"cmServiceProviders", "qmServiceProviders", "rmServiceProviders", "scmServiceProviders", "amServiceProviders", "autoServiceProviders"};
    public static final String[] PROVIDER_NAMESPACES = new String[]{"http://open-services.net/xmlns/cm/1.0/", "http://open-services.net/xmlns/qm/1.0/", "http://open-services.net/xmlns/rm/1.0/", "http://open-services.net/xmlns/scm/1.0/", "http://open-services.net/ns/am#", "http://open-services.net/ns/auto#"};
    public static final String[] PROVIDER_DOMAINS = new String[]{"http://open-services.net/ns/cm#", "http://open-services.net/ns/qm#", "http://open-services.net/ns/rm#", "http://open-services.net/ns/scm#", "http://open-services.net/ns/am#", "http://open-services.net/ns/auto#"};
    public static String[] ALL = new String[]{"implements", "implemented-by", "validates", "validated-by", "tests", "tested-by", "related-to", "tracks", "tracked-by", "tracks-changes", "changes-tracked-by", "tracks-rm", "tracked-by-cm", "architected-by", "architects", "elaborated-by", "elaborates", "validated-by-am", "validates-am", "related-to-rm", "automates", "automated-by"};
    public static String[] USES_LINK_TYPES = new String[]{"implemented-by", "validates", "tests", "tracked-by", "changes-tracked-by", "tracked-by-cm", "architects", "elaborates", "validated-by-am", "automated-by"};

    public static String getPeerLinkType(String linkType) {
        if (linkType.equals(IMPLEMENTS)) {
            return IMPLEMENTED_BY;
        }
        if (linkType.equals(IMPLEMENTED_BY)) {
            return IMPLEMENTS;
        }
        if (linkType.equals(VALIDATES)) {
            return VALIDATED_BY;
        }
        if (linkType.equals(VALIDATED_BY)) {
            return VALIDATES;
        }
        if (linkType.equals(TESTS)) {
            return TESTED_BY;
        }
        if (linkType.equals(TESTED_BY)) {
            return TESTS;
        }
        if (linkType.equals(RELATED_TO)) {
            return RELATED_TO;
        }
        if (linkType.equals(TRACKS)) {
            return TRACKED_BY;
        }
        if (linkType.equals(TRACKED_BY)) {
            return TRACKS;
        }
        if (linkType.equals(TRACKS_CHANGES)) {
            return CHANGES_TRACKED_BY;
        }
        if (linkType.equals(CHANGES_TRACKED_BY)) {
            return TRACKS_CHANGES;
        }
        if (linkType.equals(TRACKS_RM)) {
            return TRACKED_BY_CM;
        }
        if (linkType.equals(TRACKED_BY_CM)) {
            return TRACKS_RM;
        }
        if (linkType.equals(ELABORATES)) {
            return ELABORATED_BY;
        }
        if (linkType.equals(ELABORATED_BY)) {
            return ELABORATES;
        }
        if (linkType.equals(ARCHITECTS)) {
            return ARCHITECTED_BY;
        }
        if (linkType.equals(ARCHITECTED_BY)) {
            return ARCHITECTS;
        }
        if (linkType.equals(VALIDATES_AM)) {
            return VALIDATED_BY_AM;
        }
        if (linkType.equals(VALIDATED_BY_AM)) {
            return VALIDATES_AM;
        }
        if (linkType.equals(AUTOMATES)) {
            return AUTOMATED_BY;
        }
        if (linkType.equals(AUTOMATED_BY)) {
            return AUTOMATES;
        }
        return null;
    }

    public static String getTagNameForLinkType(String linkType) {
        if (linkType.equals(IMPLEMENTS)) {
            return RM_SERVICE_PROVIDERS;
        }
        if (linkType.equals(IMPLEMENTED_BY)) {
            return CM_SERVICE_PROVIDERS;
        }
        if (linkType.equals(VALIDATES)) {
            return RM_SERVICE_PROVIDERS;
        }
        if (linkType.equals(VALIDATED_BY)) {
            return QM_SERVICE_PROVIDERS;
        }
        if (linkType.equals(TESTS)) {
            return CM_SERVICE_PROVIDERS;
        }
        if (linkType.equals(TESTED_BY)) {
            return QM_SERVICE_PROVIDERS;
        }
        if (linkType.equals(RELATED_TO)) {
            return CM_SERVICE_PROVIDERS;
        }
        if (linkType.equals(TRACKS)) {
            return QM_SERVICE_PROVIDERS;
        }
        if (linkType.equals(TRACKED_BY)) {
            return CM_SERVICE_PROVIDERS;
        }
        if (linkType.equals(TRACKS_CHANGES)) {
            return SCM_SERVICE_PROVIDERS;
        }
        if (linkType.equals(CHANGES_TRACKED_BY)) {
            return CM_SERVICE_PROVIDERS;
        }
        if (linkType.equals(TRACKS_RM)) {
            return RM_SERVICE_PROVIDERS;
        }
        if (linkType.equals(TRACKED_BY_CM)) {
            return CM_SERVICE_PROVIDERS;
        }
        if (linkType.equals(ELABORATES)) {
            return RM_SERVICE_PROVIDERS;
        }
        if (linkType.equals(ELABORATED_BY)) {
            return AM_SERVICE_PROVIDERS;
        }
        if (linkType.equals(ARCHITECTS)) {
            return CM_SERVICE_PROVIDERS;
        }
        if (linkType.equals(ARCHITECTED_BY)) {
            return AM_SERVICE_PROVIDERS;
        }
        if (linkType.equals(VALIDATES_AM)) {
            return AM_SERVICE_PROVIDERS;
        }
        if (linkType.equals(VALIDATED_BY_AM)) {
            return QM_SERVICE_PROVIDERS;
        }
        if (linkType.equals(AUTOMATES)) {
            return QM_SERVICE_PROVIDERS;
        }
        if (linkType.equals(AUTOMATED_BY)) {
            return AUTO_SERVICE_PROVIDERS;
        }
        return null;
    }

    public static String[] getLinkTypesForTagName(String serviceProviderTag) {
        if (serviceProviderTag.equals(CM_SERVICE_PROVIDERS)) {
            return new String[]{TESTED_BY, IMPLEMENTS, RELATED_TO, TRACKS, TRACKS_CHANGES, TRACKS_RM, ARCHITECTED_BY};
        }
        if (serviceProviderTag.equals(QM_SERVICE_PROVIDERS)) {
            return new String[]{TESTS, VALIDATES, TRACKED_BY, VALIDATES_AM, AUTOMATED_BY};
        }
        if (serviceProviderTag.equals(RM_SERVICE_PROVIDERS)) {
            return new String[]{IMPLEMENTED_BY, VALIDATED_BY, TRACKED_BY_CM, ELABORATED_BY};
        }
        if (serviceProviderTag.equals(SCM_SERVICE_PROVIDERS)) {
            return new String[]{CHANGES_TRACKED_BY};
        }
        if (serviceProviderTag.equals(AM_SERVICE_PROVIDERS)) {
            return new String[]{ELABORATES, ARCHITECTS, VALIDATED_BY_AM};
        }
        if (serviceProviderTag.equals(AUTO_SERVICE_PROVIDERS)) {
            return new String[]{AUTOMATES};
        }
        return new String[0];
    }

    public static String getNamespaceForLinkType(String linkType) {
        if (linkType.equals(IMPLEMENTS)) {
            return "http://open-services.net/xmlns/rm/1.0/";
        }
        if (linkType.equals(IMPLEMENTED_BY)) {
            return "http://open-services.net/xmlns/cm/1.0/";
        }
        if (linkType.equals(VALIDATES)) {
            return "http://open-services.net/xmlns/rm/1.0/";
        }
        if (linkType.equals(VALIDATED_BY)) {
            return "http://open-services.net/xmlns/qm/1.0/";
        }
        if (linkType.equals(TESTS)) {
            return "http://open-services.net/xmlns/cm/1.0/";
        }
        if (linkType.equals(TESTED_BY)) {
            return "http://open-services.net/xmlns/qm/1.0/";
        }
        if (linkType.equals(RELATED_TO)) {
            return "http://open-services.net/xmlns/cm/1.0/";
        }
        if (linkType.equals(TRACKS)) {
            return "http://open-services.net/xmlns/qm/1.0/";
        }
        if (linkType.equals(TRACKED_BY)) {
            return "http://open-services.net/xmlns/cm/1.0/";
        }
        if (linkType.equals(TRACKS_CHANGES)) {
            return "http://open-services.net/xmlns/scm/1.0/";
        }
        if (linkType.equals(CHANGES_TRACKED_BY)) {
            return "http://open-services.net/xmlns/cm/1.0/";
        }
        if (linkType.equals(TRACKS_RM)) {
            return "http://open-services.net/xmlns/rm/1.0/";
        }
        if (linkType.equals(TRACKED_BY_CM)) {
            return "http://open-services.net/xmlns/cm/1.0/";
        }
        if (linkType.equals(ELABORATES)) {
            return "http://open-services.net/xmlns/rm/1.0/";
        }
        if (linkType.equals(ELABORATED_BY)) {
            return "http://open-services.net/ns/am#";
        }
        if (linkType.equals(ARCHITECTS)) {
            return "http://open-services.net/xmlns/cm/1.0/";
        }
        if (linkType.equals(ARCHITECTED_BY)) {
            return "http://open-services.net/ns/am#";
        }
        if (linkType.equals(VALIDATES_AM)) {
            return "http://open-services.net/ns/am#";
        }
        if (linkType.equals(VALIDATED_BY_AM)) {
            return "http://open-services.net/xmlns/qm/1.0/";
        }
        if (linkType.equals(AUTOMATES)) {
            return "http://open-services.net/xmlns/qm/1.0/";
        }
        if (linkType.equals(AUTOMATED_BY)) {
            return "http://open-services.net/ns/auto#";
        }
        return null;
    }

    public static boolean isUsesLinkType(String linkType) {
        int i = 0;
        while (i < USES_LINK_TYPES.length) {
            if (linkType.equals(USES_LINK_TYPES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String getMappedPreCoreTagName(String domain) {
        int i = 0;
        while (i < PROVIDER_DOMAINS.length) {
            if (PROVIDER_DOMAINS[i].equals(domain)) {
                return PROVIDERS[i];
            }
            ++i;
        }
        return null;
    }

    public static String getMappedPreCoreNamespace(String domain) {
        int i = 0;
        while (i < PROVIDER_DOMAINS.length) {
            if (PROVIDER_DOMAINS[i].equals(domain)) {
                return PROVIDER_NAMESPACES[i];
            }
            ++i;
        }
        return null;
    }

    public static String getLinkTypeLabel(String linkType) {
        if (linkType.equals(IMPLEMENTS)) {
            linkType = Messages.getCommonString("LinkTypes_0");
        } else if (linkType.equals(IMPLEMENTED_BY)) {
            linkType = Messages.getCommonString("LinkTypes_1");
        } else if (linkType.equals(VALIDATES)) {
            linkType = Messages.getCommonString("LinkTypes_2");
        } else if (linkType.equals(VALIDATED_BY)) {
            linkType = Messages.getCommonString("LinkTypes_3");
        } else if (linkType.equals(TESTS)) {
            linkType = Messages.getCommonString("LinkTypes_4");
        } else if (linkType.equals(TESTED_BY)) {
            linkType = Messages.getCommonString("LinkTypes_5");
        } else if (linkType.equals(RELATED_TO)) {
            linkType = Messages.getCommonString("LinkTypes_6");
        } else if (linkType.equals(TRACKS)) {
            linkType = Messages.getCommonString("LinkTypes_7");
        } else if (linkType.equals(TRACKED_BY)) {
            linkType = Messages.getCommonString("LinkTypes_8");
        } else if (linkType.equals(TRACKS_CHANGES)) {
            linkType = Messages.getCommonString("LinkTypes_9");
        } else if (linkType.equals(CHANGES_TRACKED_BY)) {
            linkType = Messages.getCommonString("LinkTypes_10");
        } else if (linkType.equals(TRACKS_RM)) {
            linkType = Messages.getCommonString("LinkTypes_11");
        } else if (linkType.equals(TRACKED_BY_CM)) {
            linkType = Messages.getCommonString("LinkTypes_12");
        } else if (linkType.equals(ELABORATES)) {
            linkType = Messages.getCommonString("LinkTypes_13");
        } else if (linkType.equals(ELABORATED_BY)) {
            linkType = Messages.getCommonString("LinkTypes_14");
        } else if (linkType.equals(ARCHITECTS)) {
            linkType = Messages.getCommonString("LinkTypes_15");
        } else if (linkType.equals(ARCHITECTED_BY)) {
            linkType = Messages.getCommonString("LinkTypes_16");
        } else if (linkType.equals(VALIDATED_BY_AM)) {
            linkType = Messages.getCommonString("LinkTypes_17");
        } else if (linkType.equals(VALIDATES_AM)) {
            linkType = Messages.getCommonString("LinkTypes_18");
        } else if (linkType.equals(RELATED_TO_RM)) {
            linkType = Messages.getCommonString("LinkTypes_19");
        } else if (linkType.equals(AUTOMATES)) {
            linkType = Messages.getCommonString("LinkTypes_20");
        } else if (linkType.equals(AUTOMATED_BY)) {
            linkType = Messages.getCommonString("LinkTypes_21");
        }
        return linkType;
    }
}

