/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.rest.representations;

import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.process.internal.common.rest.representations.Attribute;
import com.ibm.team.process.internal.common.rest.representations.Element;
import com.ibm.team.process.internal.common.rest.representations.ElementList;
import com.ibm.team.process.internal.common.rest.representations.IRepresentationContentTypeHandler;
import com.ibm.team.process.internal.common.rest.representations.Messages;
import com.ibm.team.process.internal.common.rest.representations.MixedElementList;
import com.ibm.team.process.internal.common.rest.representations.Namespace;
import com.ibm.team.process.internal.common.rest.representations.RDFProperty;
import com.ibm.team.process.internal.common.rest.representations.RDFResource;
import com.ibm.team.process.internal.common.rest.representations.RDFUrl;
import com.ibm.team.process.internal.common.rest.representations.Representation;
import com.ibm.team.process.internal.common.rest.representations.RepresentationCondition;
import com.ibm.team.process.internal.common.rest.representations.RepresentationConditionType;
import com.ibm.team.process.internal.common.rest.representations.RepresentationContentTypeHandlerRegistry;
import com.ibm.team.process.internal.common.rest.representations.Text;
import com.ibm.team.process.internal.common.util.XMLUtil;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AbstractRepresentation {
    private String contentType = "application/xml;charset=UTF-8";

    public AbstractRepresentation() {
        this.validateRepresentationClass();
    }

    public Document toXmlDocument() throws TeamRepositoryException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            try {
                documentBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
            documentBuilderFactory.setNamespaceAware(true);
            Document document = documentBuilderFactory.newDocumentBuilder().newDocument();
            this.toXmlElement(null, document, null, this.getClass(), this, null);
            return document;
        }
        catch (ParserConfigurationException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    public String toXmlString() throws TeamRepositoryException {
        try {
            IRepresentationContentTypeHandler handler = RepresentationContentTypeHandlerRegistry.getHandler(this.getContentType());
            if (handler != null) {
                return handler.getContent(this);
            }
            return AbstractRepresentation.serializeDocument(this.toXmlDocument());
        }
        catch (DOMException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        catch (TransformerException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    private org.w3c.dom.Element toXmlElement(org.w3c.dom.Element parent, Document document, String elementName, Class theClass, Object sourceObject, Namespace namespaceAnnotation) throws IllegalArgumentException, IllegalAccessException {
        Field[] fields;
        Representation representation = theClass.getAnnotation(Representation.class);
        String classElementName = null;
        if (elementName != null) {
            classElementName = elementName;
        } else {
            classElementName = representation.value();
            if (classElementName == null || classElementName.equals("")) {
                throw new RuntimeException(MessageFormat.format(Messages.getCommonString("RepresentationBase.16"), theClass.getName()));
            }
        }
        if (namespaceAnnotation == null) {
            namespaceAnnotation = theClass.getAnnotation(Namespace.class);
        }
        org.w3c.dom.Element classElement = this.createElement(document, classElementName, namespaceAnnotation);
        Field[] fieldArray = fields = theClass.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] values;
            Field field = fieldArray[n2];
            Class<?> fieldType = field.getType();
            Attribute attributeAnnotation = field.getAnnotation(Attribute.class);
            Text textAnnotation = field.getAnnotation(Text.class);
            Element elementAnnotation = field.getAnnotation(Element.class);
            ElementList elementListAnnotation = field.getAnnotation(ElementList.class);
            MixedElementList mixedElementListAnnotation = field.getAnnotation(MixedElementList.class);
            if (attributeAnnotation != null) {
                String attributeName = null;
                attributeName = attributeAnnotation.value() == null || attributeAnnotation.value().equals("") ? field.getName() : attributeAnnotation.value();
                if (fieldType.getName().equals("java.lang.String")) {
                    if (field.get(sourceObject) != null) {
                        this.setAttribute(classElement, attributeName, XMLUtil.filterInvalidXMLCharacters((String)field.get(sourceObject)), field.getAnnotation(Namespace.class));
                    }
                } else if (fieldType.getName().equals("int")) {
                    this.setAttribute(classElement, attributeName, String.valueOf(field.getInt(sourceObject)), field.getAnnotation(Namespace.class));
                } else if (fieldType.getName().equals("boolean")) {
                    this.setAttribute(classElement, attributeName, String.valueOf(field.getBoolean(sourceObject)), field.getAnnotation(Namespace.class));
                }
            } else if (textAnnotation != null) {
                if (fieldType.getName().equals("java.lang.String")) {
                    if (field.get(sourceObject) != null) {
                        classElement.setTextContent(XMLUtil.filterInvalidXMLCharacters((String)field.get(sourceObject)));
                    }
                } else if (fieldType.getName().equals("int")) {
                    classElement.setTextContent(String.valueOf(field.getInt(sourceObject)));
                } else if (fieldType.getName().equals("boolean")) {
                    classElement.setTextContent(String.valueOf(field.getBoolean(sourceObject)));
                }
            } else if (elementListAnnotation != null) {
                Object arrayObject;
                if (this.isArrayOfRepresentations(field) && (arrayObject = field.get(sourceObject)) != null) {
                    Class<?> componentType = fieldType.getComponentType();
                    int length = Array.getLength(arrayObject);
                    int i = 0;
                    while (i < length) {
                        this.toXmlElement(classElement, document, null, componentType, componentType.cast(Array.get(arrayObject, i)), null);
                        ++i;
                    }
                }
            } else if (elementAnnotation != null) {
                org.w3c.dom.Element element;
                String childElementName = null;
                childElementName = elementAnnotation.value() != null && elementAnnotation.value().length() > 0 ? elementAnnotation.value() : field.getName();
                if (fieldType.getName().equals(String.class.getName())) {
                    if (field.get(sourceObject) != null) {
                        element = this.createElement(document, childElementName, field.getAnnotation(Namespace.class));
                        element.setTextContent(XMLUtil.filterInvalidXMLCharacters((String)field.get(sourceObject)));
                        classElement.appendChild(element);
                    }
                } else if (fieldType.getName().equals(Integer.TYPE.getName())) {
                    element = this.createElement(document, childElementName, field.getAnnotation(Namespace.class));
                    element.setTextContent(String.valueOf(field.getInt(sourceObject)));
                    classElement.appendChild(element);
                } else if (fieldType.getName().equals(Boolean.TYPE.getName())) {
                    element = this.createElement(document, childElementName, field.getAnnotation(Namespace.class));
                    element.setTextContent(String.valueOf(field.getBoolean(sourceObject)));
                    classElement.appendChild(element);
                } else if (this.isSupportedPrimitiveWrapperType(fieldType)) {
                    Object value = field.get(sourceObject);
                    if (value != null) {
                        org.w3c.dom.Element element2 = this.createElement(document, childElementName, field.getAnnotation(Namespace.class));
                        element2.setTextContent(value.toString());
                        classElement.appendChild(element2);
                    }
                } else if (this.isArrayOfRepresentations(field)) {
                    Object arrayObject = field.get(sourceObject);
                    if (arrayObject != null) {
                        Class<?> componentType = fieldType.getComponentType();
                        org.w3c.dom.Element element3 = this.createElement(document, childElementName, field.getAnnotation(Namespace.class));
                        classElement.appendChild(element3);
                        int length = Array.getLength(arrayObject);
                        int i = 0;
                        while (i < length) {
                            this.toXmlElement(element3, document, null, componentType, componentType.cast(Array.get(arrayObject, i)), null);
                            ++i;
                        }
                    }
                } else if (this.isRepresentationType(field) && field.get(sourceObject) != null) {
                    childElementName = elementAnnotation.value() != null && elementAnnotation.value().length() > 0 ? elementAnnotation.value() : null;
                    this.toXmlElement(classElement, document, childElementName, field.getType(), field.get(sourceObject), field.getAnnotation(Namespace.class));
                }
            } else if (mixedElementListAnnotation != null && this.isArrayOfObjects(field) && (values = (Object[])field.get(sourceObject)) != null) {
                Object[] objectArray = values;
                int n3 = values.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object item = objectArray[n4];
                    if (item != null) {
                        Representation representationAnnotation = item.getClass().getAnnotation(Representation.class);
                        Namespace nsAnnotation = item.getClass().getAnnotation(Namespace.class);
                        this.toXmlElement(classElement, document, representationAnnotation.value(), item.getClass(), item, nsAnnotation);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (parent != null) {
            parent.appendChild(classElement);
        } else {
            document.appendChild(classElement);
        }
        return classElement;
    }

    private org.w3c.dom.Element createElement(Document document, String elementName, Namespace namespaceAnnotation) {
        if (namespaceAnnotation != null) {
            return document.createElementNS(namespaceAnnotation.uri(), this.getQualifiedName(elementName, namespaceAnnotation));
        }
        return document.createElement(elementName);
    }

    private String getQualifiedName(String name, Namespace namespaceAnnotation) {
        String qualifiedName = namespaceAnnotation.prefix() != null && namespaceAnnotation.prefix().trim().length() != 0 ? String.valueOf(namespaceAnnotation.prefix()) + ":" + name : name;
        return qualifiedName;
    }

    private void setAttribute(org.w3c.dom.Element element, String attributeName, String value, Namespace namespaceAnnotation) {
        if (namespaceAnnotation != null) {
            element.setAttributeNS(namespaceAnnotation.uri(), this.getQualifiedName(attributeName, namespaceAnnotation), value);
        } else {
            element.setAttribute(attributeName, value);
        }
    }

    public void fromXml(org.w3c.dom.Element element) throws TeamRepositoryException {
        Representation representation = this.getClass().getAnnotation(Representation.class);
        if (representation == null) {
            throw new RuntimeException(MessageFormat.format(Messages.getCommonString("RepresentationBase.0"), this.getClass().getName()));
        }
        if (!this.isMatchingElement(element, this.getClass())) {
            return;
        }
        try {
            this.fromXml(element, this);
        }
        catch (IllegalArgumentException exception) {
            throw new TeamRepositoryException((Throwable)exception);
        }
        catch (IllegalAccessException exception) {
            throw new TeamRepositoryException((Throwable)exception);
        }
        catch (InstantiationException exception) {
            throw new TeamRepositoryException((Throwable)exception);
        }
    }

    private boolean isMatchingElement(org.w3c.dom.Element element, Class theClass) {
        Representation representation = theClass.getAnnotation(Representation.class);
        String expectedElementName = representation.value();
        Namespace namespaceAnnotation = theClass.getAnnotation(Namespace.class);
        if (namespaceAnnotation != null) {
            return element.getLocalName().equals(expectedElementName) && element.getNamespaceURI().equals(namespaceAnnotation.uri());
        }
        if (element.getNamespaceURI() == null) {
            return element.getNodeName().equals(expectedElementName);
        }
        return false;
    }

    public void fromXml(String xmlString) throws TeamRepositoryException {
        try {
            this.fromXml(this.getXmlDocument(xmlString).getDocumentElement());
        }
        catch (IllegalArgumentException exception) {
            throw new TeamRepositoryException((Throwable)exception);
        }
        catch (DOMException exception) {
            throw new TeamRepositoryException((Throwable)exception);
        }
        catch (ParserConfigurationException exception) {
            throw new TeamRepositoryException((Throwable)exception);
        }
        catch (SAXException exception) {
            throw new TeamRepositoryException((Throwable)exception);
        }
        catch (IOException exception) {
            throw new TeamRepositoryException((Throwable)exception);
        }
    }

    private Document getXmlDocument(String xmlString) throws ParserConfigurationException, SAXException, IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlString.getBytes("UTF-8"));
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            docBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            docBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        docBuilderFactory.setNamespaceAware(true);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        return docBuilder.parse(inputStream);
    }

    private void fromXml(org.w3c.dom.Element element, Object targetObject) throws IllegalArgumentException, DOMException, IllegalAccessException, InstantiationException {
        Class<?> theClass = targetObject.getClass();
        Representation representation = theClass.getAnnotation(Representation.class);
        if (representation == null) {
            throw new RuntimeException(MessageFormat.format(Messages.getCommonString("RepresentationBase.0"), theClass.getName()));
        }
        NamedNodeMap attributes = element.getAttributes();
        org.w3c.dom.Element[] childElements = this.getChildElements(element);
        int i = 0;
        while (i < attributes.getLength()) {
            Node attributeNode = attributes.item(i);
            Field field = this.getField(theClass, attributeNode);
            if (field != null) {
                this.setFieldValue(field, targetObject, attributeNode.getNodeValue());
            }
            ++i;
        }
        if (childElements.length == 0) {
            Field textField = this.getTextField(theClass);
            if (textField != null) {
                this.setFieldValue(textField, targetObject, element.getTextContent());
            }
            return;
        }
        Field field = this.getMixedElementListField(theClass);
        if (field != null) {
            if (this.isArrayOfObjects(field)) {
                Object arrayObject = Array.newInstance(Object.class, childElements.length);
                MixedElementList mixedListAnnotation = field.getAnnotation(MixedElementList.class);
                int i2 = 0;
                while (i2 < childElements.length) {
                    org.w3c.dom.Element childElement = childElements[i2];
                    Class representationClass = this.getRepresentationClass(childElement, mixedListAnnotation);
                    Object componentTargetObject = representationClass.newInstance();
                    this.fromXml(childElement, componentTargetObject);
                    Array.set(arrayObject, i2, componentTargetObject);
                    ++i2;
                }
                field.set(targetObject, arrayObject);
            }
        } else {
            HashMap fieldToListMap = new HashMap();
            org.w3c.dom.Element[] representationClass = childElements;
            int childElement = childElements.length;
            int n = 0;
            while (n < childElement) {
                org.w3c.dom.Element childElement2 = representationClass[n];
                field = this.getField(theClass, childElement2);
                if (field != null) {
                    ElementList listAnnotation = field.getAnnotation(ElementList.class);
                    if (listAnnotation != null) {
                        if (this.isArrayOfRepresentations(field)) {
                            Class<?> componentType = field.getType().getComponentType();
                            Object componentTargetObject = componentType.newInstance();
                            this.fromXml(childElement2, componentTargetObject);
                            ArrayList list = (ArrayList)fieldToListMap.get(field);
                            if (list == null) {
                                list = new ArrayList();
                                fieldToListMap.put(field, list);
                            }
                            list.add(componentTargetObject);
                        }
                    } else {
                        Class<?> fieldType = field.getType();
                        if (this.isSupportedPrimitive(fieldType) || this.isSupportedPrimitiveWrapperType(fieldType)) {
                            this.setFieldValue(field, targetObject, childElement2.getTextContent());
                            attributes = childElement2.getAttributes();
                            int i3 = 0;
                            while (i3 < attributes.getLength()) {
                                Node attributeNode = attributes.item(i3);
                                Field attributeField = this.getField(theClass, attributeNode);
                                if (attributeField != null) {
                                    this.setFieldValue(attributeField, targetObject, attributeNode.getNodeValue());
                                }
                                ++i3;
                            }
                        } else if (this.isArrayOfRepresentations(field)) {
                            Class<?> componentType = field.getType().getComponentType();
                            Representation componentRepresentation = componentType.getAnnotation(Representation.class);
                            Namespace componentNamespace = componentType.getAnnotation(Namespace.class);
                            String componentElementName = componentRepresentation.value();
                            org.w3c.dom.Element[] componentElements = this.getChildElements(childElement2, componentElementName, componentNamespace);
                            Object arrayObject = Array.newInstance(componentType, componentElements.length);
                            int i4 = 0;
                            while (i4 < componentElements.length) {
                                Object componentTargetObject = componentType.newInstance();
                                this.fromXml(componentElements[i4], componentTargetObject);
                                Array.set(arrayObject, i4, componentTargetObject);
                                ++i4;
                            }
                            field.set(targetObject, arrayObject);
                        } else if (this.isRepresentationType(field)) {
                            Object childObject = field.getType().newInstance();
                            field.set(targetObject, childObject);
                            this.fromXml(childElement2, childObject);
                        }
                    }
                }
                ++n;
            }
            for (Map.Entry entry : fieldToListMap.entrySet()) {
                Field elementListField = (Field)entry.getKey();
                List list = (List)entry.getValue();
                int size = list.size();
                Object arrayObject = Array.newInstance(elementListField.getType().getComponentType(), size);
                int i5 = 0;
                while (i5 < size) {
                    Array.set(arrayObject, i5, list.get(i5));
                    ++i5;
                }
                elementListField.set(targetObject, arrayObject);
            }
        }
    }

    private Class getRepresentationClass(org.w3c.dom.Element element, MixedElementList mixedListAnnotation) {
        Class[] classArray = mixedListAnnotation.value();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class clazz = classArray[n2];
            if (AbstractRepresentation.isRepresentationClass(clazz, element)) {
                return clazz;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isRepresentationClass(Class clazz, org.w3c.dom.Element element) {
        String tag;
        Representation representation = clazz.getAnnotation(Representation.class);
        if (representation == null) {
            return false;
        }
        Namespace ns = clazz.getAnnotation(Namespace.class);
        String nsUri = ns != null ? ns.uri() : null;
        String string = tag = element.getNamespaceURI() != null ? (tag = element.getLocalName()) : element.getNodeName();
        if (tag.equals(representation.value()) && (element.getNamespaceURI() == null && nsUri == null || nsUri != null && nsUri.equals(element.getNamespaceURI()))) {
            RepresentationCondition condition = clazz.getAnnotation(RepresentationCondition.class);
            if (condition != null) {
                ns = condition.namespace();
                RepresentationConditionType conditionType = condition.type();
                if (conditionType == RepresentationConditionType.ATTRIBUTE) {
                    String value;
                    String string2 = ns != null && ns.prefix() != null & ns.prefix().length() != 0 ? element.getAttributeNS(ns.uri(), condition.name()) : (value = element.getAttribute(condition.name()));
                    if (condition.value().equals(value)) {
                        return true;
                    }
                } else if (conditionType == RepresentationConditionType.ELEMENT) {
                    org.w3c.dom.Element conditionElement;
                    org.w3c.dom.Element element2 = conditionElement = ns != null ? XMLUtil.getElement(element.getChildNodes(), condition.name(), ns.uri()) : XMLUtil.getElement(element.getChildNodes(), condition.name());
                    if (conditionElement != null && conditionElement.getTextContent().equals(condition.value())) {
                        return true;
                    }
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private boolean isRepresentationType(Field field) {
        return field.getType().isAnnotationPresent(Representation.class);
    }

    private boolean isArrayOfRepresentations(Field field) {
        Class<?> componentType;
        Class<?> fieldType = field.getType();
        return fieldType.isArray() && (componentType = fieldType.getComponentType()).isAnnotationPresent(Representation.class);
    }

    private boolean isArrayOfObjects(Field field) {
        Class<Object> componentType;
        Class<?> fieldType = field.getType();
        return fieldType.isArray() && (componentType = fieldType.getComponentType()).isAssignableFrom(Object.class);
    }

    private org.w3c.dom.Element[] getChildElements(org.w3c.dom.Element element) {
        return this.getChildElements(element, null, null);
    }

    private org.w3c.dom.Element[] getChildElements(org.w3c.dom.Element element, String elementName, Namespace namespaceAnnotation) {
        ArrayList<org.w3c.dom.Element> elements = new ArrayList<org.w3c.dom.Element>();
        NodeList childNodes = element.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            if (childNodes.item(i) instanceof org.w3c.dom.Element) {
                if (elementName == null && namespaceAnnotation == null) {
                    elements.add((org.w3c.dom.Element)childNodes.item(i));
                } else if (elementName != null && namespaceAnnotation == null) {
                    if (childNodes.item(i).getNodeName().equals(elementName)) {
                        elements.add((org.w3c.dom.Element)childNodes.item(i));
                    }
                } else if (elementName == null && namespaceAnnotation != null) {
                    if (childNodes.item(i).getNamespaceURI().equals(namespaceAnnotation.uri())) {
                        elements.add((org.w3c.dom.Element)childNodes.item(i));
                    }
                } else if (elementName != null && namespaceAnnotation != null && childNodes.item(i).getLocalName().equals(elementName) && childNodes.item(i).getNamespaceURI().equals(namespaceAnnotation.uri())) {
                    elements.add((org.w3c.dom.Element)childNodes.item(i));
                }
            }
            ++i;
        }
        return elements.toArray(new org.w3c.dom.Element[elements.size()]);
    }

    private void setFieldValue(Field field, Object object, String value) throws IllegalArgumentException, IllegalAccessException {
        Class<?> fieldType = field.getType();
        if (fieldType.getName().equals(String.class.getName())) {
            field.set(object, value);
        } else if (fieldType.getName().equals(Integer.TYPE.getName())) {
            field.setInt(object, Integer.valueOf(value.trim()));
        } else if (fieldType.getName().equals(Boolean.TYPE.getName())) {
            field.setBoolean(object, Boolean.valueOf(value.trim()));
        } else if (fieldType.getName().equals(Boolean.class.getName())) {
            field.set(object, Boolean.valueOf(value.trim()));
        } else if (fieldType.getName().equals(Integer.class.getName())) {
            field.set(object, Integer.valueOf(value.trim()));
        }
    }

    public boolean isSupportedPrimitive(Class type) throws IllegalArgumentException {
        if (type.getName().equals(String.class.getName())) {
            return true;
        }
        if (type.getName().equals(Integer.TYPE.getName())) {
            return true;
        }
        return type.getName().equals(Boolean.TYPE.getName());
    }

    public boolean isSupportedPrimitiveWrapperType(Class type) throws IllegalArgumentException {
        String typeName = type.getName();
        return Integer.class.getName().equals(typeName) || Boolean.class.getName().equals(typeName);
    }

    private Field getField(Class theClass, Node node) {
        Field matchingField = null;
        String attributeName = null;
        String namespaceURI = node.getNamespaceURI();
        attributeName = namespaceURI != null ? node.getLocalName() : node.getNodeName();
        try {
            Field field = theClass.getField(attributeName);
            Namespace namespaceAnnotation = field.getAnnotation(Namespace.class);
            if (namespaceURI != null) {
                if (namespaceAnnotation != null && namespaceAnnotation.uri().equals(namespaceURI)) {
                    matchingField = field;
                }
            } else if (namespaceAnnotation == null) {
                matchingField = field;
            }
        }
        catch (SecurityException securityException) {
            return null;
        }
        catch (NoSuchFieldException noSuchFieldException) {}
        if (matchingField == null) {
            Field[] fields;
            Field[] fieldArray = fields = theClass.getFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                Field potentialMatch = null;
                Attribute attributeAnnotation = field.getAnnotation(Attribute.class);
                if (attributeAnnotation != null && attributeAnnotation.value() != null && attributeAnnotation.value().equals(attributeName)) {
                    potentialMatch = field;
                } else {
                    Element elementAnnotation = field.getAnnotation(Element.class);
                    if (elementAnnotation != null && elementAnnotation.value() != null && elementAnnotation.value().equals(attributeName)) {
                        potentialMatch = field;
                    }
                }
                if (potentialMatch != null) {
                    Namespace namespaceAnnotation = potentialMatch.getAnnotation(Namespace.class);
                    if (namespaceURI != null) {
                        if (namespaceAnnotation != null && namespaceAnnotation.uri().equals(namespaceURI)) {
                            matchingField = potentialMatch;
                        }
                    } else if (namespaceAnnotation == null) {
                        matchingField = potentialMatch;
                    }
                } else if (node instanceof org.w3c.dom.Element) {
                    Class<?> componentType;
                    org.w3c.dom.Element element = (org.w3c.dom.Element)node;
                    ElementList annotation = field.getAnnotation(ElementList.class);
                    if (annotation != null && this.isArrayOfRepresentations(field) && AbstractRepresentation.isRepresentationClass(componentType = field.getType().getComponentType(), element)) {
                        matchingField = field;
                    }
                }
                ++n2;
            }
        }
        return matchingField;
    }

    private Field getElementListField(Class theClass) {
        Field[] fields;
        Field[] fieldArray = fields = theClass.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            ElementList annotation = field.getAnnotation(ElementList.class);
            if (annotation != null) {
                return field;
            }
            ++n2;
        }
        return null;
    }

    private Field getMixedElementListField(Class theClass) {
        Field[] fields;
        Field[] fieldArray = fields = theClass.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.isAnnotationPresent(MixedElementList.class)) {
                return field;
            }
            ++n2;
        }
        return null;
    }

    private Field getTextField(Class theClass) {
        Field[] fields;
        Field[] fieldArray = fields = theClass.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            Text textAnnotation = field.getAnnotation(Text.class);
            if (textAnnotation != null) {
                return field;
            }
            ++n2;
        }
        return null;
    }

    protected void validateRepresentationClass() throws IllegalArgumentException {
        HashSet<String> classesSeen = new HashSet<String>();
        this.validateRepresentationClass(this.getClass(), classesSeen);
    }

    protected void validateRepresentationClass(Class theClass, Set<String> classesSeen) throws IllegalArgumentException {
        Class<?>[] classes;
        Field[] fields;
        int fieldsWithElementAnnotation = 0;
        int fieldsWithElementListAnnotation = 0;
        int fieldsWithTextAnnotation = 0;
        int fieldsWithMixedElementListAnnotation = 0;
        if (classesSeen.contains(theClass.getName())) {
            return;
        }
        classesSeen.add(theClass.getName());
        Representation representation = theClass.getAnnotation(Representation.class);
        if (representation == null) {
            throw new IllegalArgumentException(NLS.bind(Messages.getCommonString("RepresentationBase.2"), theClass.getName()));
        }
        if (this.getClass() == theClass) {
            if (representation.value() == null || representation.value().equals("")) {
                throw new IllegalArgumentException(NLS.bind(Messages.getCommonString("RepresentationBase.3"), theClass.getName()));
            }
        } else if (this.getElementListField(theClass) != null) {
            throw new IllegalArgumentException(NLS.bind(Messages.getCommonString("RepresentationBase.4"), theClass.getName()));
        }
        Field[] fieldArray = fields = theClass.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            MixedElementList mixedListAnnotation;
            Field field = fieldArray[n2];
            Class<?> fieldType = field.getType();
            if (!this.isSupportedAnnotationPresent(field)) {
                throw new IllegalArgumentException(NLS.bind(Messages.getCommonString("RepresentationBase.5"), field.getName()));
            }
            if (field.isAnnotationPresent(Element.class)) {
                ++fieldsWithElementAnnotation;
            }
            if (field.isAnnotationPresent(Text.class)) {
                ++fieldsWithTextAnnotation;
            }
            if (field.isAnnotationPresent(ElementList.class)) {
                ++fieldsWithElementListAnnotation;
            }
            if ((mixedListAnnotation = field.getAnnotation(MixedElementList.class)) != null) {
                ++fieldsWithMixedElementListAnnotation;
                Class[] classArray = mixedListAnnotation.value();
                int n3 = classArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Class type = classArray[n4];
                    Representation representationAnnotation = type.getAnnotation(Representation.class);
                    if (representationAnnotation == null) {
                        throw new IllegalArgumentException(NLS.bind(Messages.getCommonString("RepresentationBase.7"), type.getClass().getName()));
                    }
                    if (representationAnnotation.value() == null) {
                        throw new IllegalArgumentException(NLS.bind(Messages.getCommonString("RepresentationBase.17"), type.getClass().getName()));
                    }
                    ++n4;
                }
            }
            if (fieldType.isArray()) {
                if (fieldType.getComponentType().getName().equals(String.class.getName()) || fieldType.getComponentType().isPrimitive()) {
                    throw new IllegalArgumentException(NLS.bind(Messages.getCommonString("RepresentationBase.6"), field.getName()));
                }
                Class<?> componentType = fieldType.getComponentType();
                representation = componentType.getAnnotation(Representation.class);
                if (representation != null && (representation.value() == null || representation.value().equals(""))) {
                    throw new IllegalArgumentException(NLS.bind(Messages.getCommonString("RepresentationBase.8"), componentType.getName(), field.getName()));
                }
            } else if (field.isAnnotationPresent(ElementList.class)) {
                throw new IllegalArgumentException(NLS.bind(Messages.getCommonString("RepresentationBase.9"), field.getName()));
            }
            if ((field.isAnnotationPresent(Attribute.class) || field.isAnnotationPresent(Text.class)) && !this.isSupportedPrimitive(field.getType()) && !this.isSupportedPrimitiveWrapperType(field.getType())) {
                throw new IllegalArgumentException(NLS.bind(Messages.getCommonString("RepresentationBase.10"), field.getName(), field.getType().getName()));
            }
            ++n2;
        }
        Class<?>[] classArray = classes = theClass.getClasses();
        int n5 = classes.length;
        n = 0;
        while (n < n5) {
            Class<?> memberClass = classArray[n];
            this.validateRepresentationClass(memberClass, classesSeen);
            ++n;
        }
        if (fieldsWithTextAnnotation > 0) {
            if (fieldsWithTextAnnotation != 1) {
                throw new IllegalArgumentException(NLS.bind(Messages.getCommonString("RepresentationBase.11"), theClass.getName()));
            }
            if (fieldsWithElementAnnotation > 0) {
                throw new IllegalArgumentException(NLS.bind(Messages.getCommonString("RepresentationBase.12"), theClass.getName()));
            }
        }
        if (fieldsWithElementListAnnotation > 0 && fieldsWithTextAnnotation > 0) {
            throw new IllegalArgumentException(NLS.bind(Messages.getCommonString("RepresentationBase.15"), theClass.getName()));
        }
        if (fieldsWithMixedElementListAnnotation > 0) {
            if (fieldsWithMixedElementListAnnotation != 1) {
                throw new IllegalArgumentException(NLS.bind(Messages.getCommonString("RepresentationBase.18"), theClass.getName()));
            }
            if (fieldsWithElementAnnotation > 0) {
                throw new IllegalArgumentException(NLS.bind(Messages.getCommonString(Messages.getCommonString("RepresentationBase.19")), theClass.getName()));
            }
            if (fieldsWithTextAnnotation > 0) {
                throw new IllegalArgumentException(NLS.bind(Messages.getCommonString(Messages.getCommonString("RepresentationBase.20")), theClass.getName()));
            }
        }
    }

    public boolean isSupportedAnnotationPresent(Field field) {
        if (field.isAnnotationPresent(Attribute.class)) {
            return true;
        }
        if (field.isAnnotationPresent(Element.class)) {
            return true;
        }
        if (field.isAnnotationPresent(Text.class)) {
            return true;
        }
        if (field.isAnnotationPresent(ElementList.class)) {
            return true;
        }
        if (field.isAnnotationPresent(MixedElementList.class)) {
            return true;
        }
        if (field.isAnnotationPresent(RDFProperty.class)) {
            return true;
        }
        if (field.isAnnotationPresent(RDFResource.class)) {
            return true;
        }
        return field.isAnnotationPresent(RDFUrl.class);
    }

    private static String serializeDocument(Document document) throws TransformerException, IOException {
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            factory.setAttribute("indent-number", new Integer(4));
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        try {
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "4");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        StreamResult outputTarget = new StreamResult(new OutputStreamWriter((OutputStream)outputStream, "UTF-8"));
        DOMSource source = new DOMSource(document);
        transformer.transform(source, outputTarget);
        return outputStream.toString("UTF-8");
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }
}

