/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.workitem.common.model.IResolution;
import com.ibm.team.workitem.common.model.IState;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.workflow.IWorkflowAction;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.util.Arrays;

public class WorkflowUtil {
    public static boolean validState(IWorkflowInfo workflow, IWorkItem workItem, String action) {
        if (workflow == null) {
            return false;
        }
        Identifier<IState> state = workItem.getState2();
        if (state != null && !Arrays.asList(workflow.getAllStateIds()).contains(state)) {
            return false;
        }
        if (state == null && action != null && !action.equals(workflow.getStartActionId().getStringIdentifier())) {
            return false;
        }
        if (state == null && action == null) {
            return false;
        }
        if (action != null) {
            Identifier<IWorkflowAction> actionIdent = Identifier.create(IWorkflowAction.class, action);
            if (!Arrays.asList(workflow.getActionIds(state)).contains(actionIdent)) {
                return false;
            }
            Identifier<IState> targetState = workflow.getActionResultState(Identifier.create(IWorkflowAction.class, action));
            if (targetState == null) {
                return false;
            }
        }
        return true;
    }

    public static boolean isResolvedInvalid(IWorkflowInfo workflow, IWorkItem workItem) {
        Identifier<IState> state;
        String workflowID;
        String INVALID = "5";
        if (workflow != null && workItem != null && "bugzillaWorkflow".equals(workflowID = workflow.getIdentifier()) && workflow.stateGroupContains(2, state = workItem.getState2())) {
            Identifier<IResolution> resolution = workItem.getResolution2();
            return INVALID.equals(resolution.getStringIdentifier());
        }
        return false;
    }

    public static boolean isResolvedDuplicate(IWorkflowInfo workflow, IWorkItem workItem) {
        Identifier<IState> state;
        String workflowID;
        String DUPLICATE = "2";
        if (workflow != null && workItem != null && "bugzillaWorkflow".equals(workflowID = workflow.getIdentifier()) && workflow.stateGroupContains(2, state = workItem.getState2())) {
            Identifier<IResolution> resolution = workItem.getResolution2();
            return DUPLICATE.equals(resolution.getStringIdentifier());
        }
        return false;
    }
}

