/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.attributeValueProviders;

import com.ibm.team.repository.common.FileLocator;
import com.ibm.team.workitem.common.internal.attributeValueProviders.FallbackProvider;
import com.ibm.team.workitem.common.internal.attributeValueProviders.Messages;
import com.ibm.team.workitem.common.internal.model.WorkItemCommonPlugin;
import com.ibm.team.workitem.common.model.AttributeType;
import com.ibm.team.workitem.common.model.AttributeTypes;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class AttributeValueProviderDescriptor {
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String CLASS = "class";
    private static final String ICON = "icon";
    private static final String REQUIRES_CONFIGURATION = "requiresConfiguration";
    private static final String IS_DEFAULT = "isDefault";
    private static final String ATTRIBUTE_TYPE = "attributeType";
    private static final String ATTRIBUTE = "attribute";
    private static final String SCRIPT = "script";
    private static final String ENUMERATION_TYPE = "enumeration";
    private static final String ENUMERATION_LIST_TYPE = "enumerationList";
    private static final String ALL_TYPES = "*";
    private final IConfigurationElement fElement;
    private final String fId;
    private final String fName;
    private final URL fIconURL;
    private final boolean fRequiresConfiguration;
    private final boolean fIsDefault;
    private final HashSet<String> fAttributeTypes;
    private final HashSet<String> fAttributes;
    private final String fScriptClass;

    public AttributeValueProviderDescriptor(IConfigurationElement element) {
        String id;
        IConfigurationElement child;
        this.fElement = element;
        this.fId = this.fElement.getAttribute(ID);
        this.fName = this.fElement.getAttribute(NAME);
        this.fIconURL = AttributeValueProviderDescriptor.getIconURL(element, ICON);
        String requiresCfg = this.fElement.getAttribute(REQUIRES_CONFIGURATION);
        this.fRequiresConfiguration = requiresCfg == null ? true : Boolean.valueOf(requiresCfg);
        this.fIsDefault = Boolean.valueOf(this.fElement.getAttribute(IS_DEFAULT));
        this.fAttributeTypes = new HashSet();
        IConfigurationElement[] iConfigurationElementArray = element.getChildren(ATTRIBUTE_TYPE);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            child = iConfigurationElementArray[n2];
            id = child.getAttribute(ID);
            if (id != null && id.length() > 0) {
                this.fAttributeTypes.add(id);
            }
            ++n2;
        }
        this.fAttributes = new HashSet();
        iConfigurationElementArray = element.getChildren(ATTRIBUTE);
        n = iConfigurationElementArray.length;
        n2 = 0;
        while (n2 < n) {
            child = iConfigurationElementArray[n2];
            id = child.getAttribute(ID);
            if (id != null && id.length() > 0) {
                this.fAttributes.add(id);
            }
            ++n2;
        }
        IConfigurationElement[] scripts = element.getChildren(SCRIPT);
        this.fScriptClass = scripts.length > 0 ? scripts[0].getAttribute(CLASS) : null;
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }

    public URL getIconURL() {
        return this.fIconURL;
    }

    public String getElementName() {
        return this.fElement.getName();
    }

    public boolean isDefault() {
        return this.fIsDefault;
    }

    public boolean requiresConfiguration() {
        return this.fRequiresConfiguration;
    }

    public Object getProvider() {
        try {
            return this.fElement.createExecutableExtension(CLASS);
        }
        catch (CoreException e) {
            WorkItemCommonPlugin.log(Messages.getString("AttributeValueProviderDescriptor.INSTANTIATION_FAILED"), (Exception)((Object)e));
            return new FallbackProvider();
        }
    }

    public boolean handlesAttributeType(String attributeType) {
        if (this.fAttributeTypes.contains(ALL_TYPES)) {
            return true;
        }
        if (AttributeTypes.isEnumerationAttributeType(attributeType)) {
            return this.fAttributeTypes.contains(ENUMERATION_TYPE);
        }
        if (AttributeTypes.isEnumerationListAttributeType(attributeType)) {
            return this.fAttributeTypes.contains(ENUMERATION_LIST_TYPE);
        }
        return this.fAttributeTypes.contains(attributeType);
    }

    public boolean handlesCompatibleType(String attributeType) {
        if (this.handlesAttributeType(attributeType)) {
            return true;
        }
        AttributeType type = AttributeTypes.getAttributeType(attributeType);
        for (String handledAttributeType : this.fAttributeTypes) {
            AttributeType handledType = AttributeTypes.getAttributeType(handledAttributeType);
            if (!type.getInstanceType().equals(handledType.getInstanceType())) continue;
            return true;
        }
        return false;
    }

    public Collection<String> getAttributeTypes() {
        return this.fAttributeTypes;
    }

    public Collection<String> getAttributes() {
        return this.fAttributes;
    }

    public boolean handlesAttributeId(String attributeId) {
        return this.fAttributes.contains(attributeId);
    }

    public String getScriptClass() {
        return this.fScriptClass;
    }

    public String getOriginatingPluginId() {
        return this.fElement.getContributor().getName();
    }

    private static URL getIconURL(IConfigurationElement element, String iconAttribute) {
        String icon = element.getAttribute(iconAttribute);
        if (icon == null) {
            return null;
        }
        if ((icon = icon.trim()).length() == 0) {
            return null;
        }
        String bundleId = element.getDeclaringExtension().getNamespaceIdentifier();
        return FileLocator.find((String)bundleId, (IPath)new Path(icon));
    }
}

