/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.emailtemplates;

import com.ibm.team.workitem.common.internal.emailtemplates.TemplateErrorInfo;
import com.ibm.team.workitem.common.internal.rcp.dto.MailTemplateErrorInfoDTO;
import com.ibm.team.workitem.common.internal.rcp.dto.MailTemplateEvaluationResultDTO;
import com.ibm.team.workitem.common.internal.rcp.dto.RcpFactory;
import java.util.LinkedList;
import java.util.List;

public class TemplateEvaluationResult {
    private String fString;
    private List<TemplateErrorInfo> fErrors;

    public TemplateEvaluationResult(String string, List<TemplateErrorInfo> errors) {
        this.fString = string;
        this.fErrors = errors;
    }

    private TemplateEvaluationResult() {
    }

    public String getString() {
        return this.fString;
    }

    public List<TemplateErrorInfo> getErrors() {
        return this.fErrors;
    }

    public boolean isOK() {
        return this.fErrors == null || this.fErrors.size() == 0;
    }

    public boolean isError() {
        return !this.isOK();
    }

    public MailTemplateEvaluationResultDTO toDTO() {
        MailTemplateEvaluationResultDTO dto = RcpFactory.eINSTANCE.createMailTemplateEvaluationResultDTO();
        dto.setTemplate(this.fString);
        for (TemplateErrorInfo info : this.fErrors) {
            dto.getExceptions().add(info.toDTO());
        }
        return dto;
    }

    public static TemplateEvaluationResult fromDTO(MailTemplateEvaluationResultDTO dto) {
        TemplateEvaluationResult instance = new TemplateEvaluationResult();
        instance.fString = dto.getTemplate();
        instance.fErrors = new LinkedList<TemplateErrorInfo>();
        for (MailTemplateErrorInfoDTO errorDTO : dto.getExceptions()) {
            instance.fErrors.add(TemplateErrorInfo.fromDTO(errorDTO));
        }
        return instance;
    }
}

