/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.expression;

import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.ExpressionChangeEvent;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.Term;
import com.ibm.team.workitem.common.expression.VariableAttributeExpression;
import com.ibm.team.workitem.common.expression.variables.IAttributeVariable;
import com.ibm.team.workitem.common.internal.expression.EditableExpression;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareLinkedHashSet;
import com.ibm.team.workitem.common.model.AttributeOperation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class EditableAttributeExpression
extends EditableExpression {
    private AttributeOperation fOperator;
    private final IQueryableAttribute fAttribute;
    private final Set<Object> fValues;

    public EditableAttributeExpression(IQueryableAttribute attribute, AttributeOperation operator) {
        this.fAttribute = attribute;
        this.fOperator = operator;
        this.fValues = new ItemHandleAwareLinkedHashSet<Object>();
    }

    public EditableAttributeExpression(IQueryableAttribute attribute, AttributeOperation operator, Collection<?> values) {
        this(attribute, operator);
        this.fValues.addAll(values);
    }

    public EditableAttributeExpression(EditableAttributeExpression expression) {
        this(expression.getAttribute(), expression.getOperator(), expression.getValues());
    }

    public void setOperator(AttributeOperation operator) {
        this.fOperator = operator;
        this.notify(ExpressionChangeEvent.Type.CONDITION_OPERATOR_CHANGED);
    }

    public AttributeOperation getOperator() {
        return this.fOperator;
    }

    protected Term.Operator getBooleanOperator() {
        return this.fOperator.isNegation() ? Term.Operator.AND : Term.Operator.OR;
    }

    public IQueryableAttribute getAttribute() {
        return this.fAttribute;
    }

    public Collection<Object> getValues() {
        return Collections.unmodifiableCollection(this.fValues);
    }

    public void setValues(Collection<Object> values) {
        this.fValues.clear();
        this.fValues.addAll(values);
        this.notify(ExpressionChangeEvent.Type.CONDITION_VALUE_CHANGED);
    }

    public void addValue(Object value) {
        this.fValues.add(value);
        this.notify(ExpressionChangeEvent.Type.CONDITION_VALUE_CHANGED);
    }

    public void removeValue(Object value) {
        this.fValues.remove(value);
        this.notify(ExpressionChangeEvent.Type.CONDITION_VALUE_CHANGED);
    }

    @Override
    public Expression createExpression() {
        return this.createExpression(this.getAttribute());
    }

    protected Expression createExpression(IQueryableAttribute attribute) {
        Term term = new Term(this.getBooleanOperator(), null);
        for (Object value : this.fValues) {
            term.add(this.createValueExpression(attribute, value));
        }
        List<Expression> expressions = term.getExpressions();
        if (expressions.size() == 0) {
            if (this.getOperator().isUnary()) {
                return this.createValueExpression(attribute, null);
            }
            return null;
        }
        return term;
    }

    private AttributeExpression createValueExpression(IQueryableAttribute attribute, Object value) {
        if (value instanceof IAttributeVariable) {
            return new VariableAttributeExpression(attribute, this.getOperator(), (IAttributeVariable)value);
        }
        return new AttributeExpression(attribute, this.getOperator(), value);
    }
}

