/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.template;

import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.links.common.registry.ILinkTypeRegistry;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.query.BaseContributorQueryModel;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.ast.ILiteral;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.utils.DateUtils;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.QueryIterator;
import com.ibm.team.workitem.common.internal.identifiers.AttributeFacade;
import com.ibm.team.workitem.common.internal.identifiers.IAttributeType;
import com.ibm.team.workitem.common.internal.identifiers.IInternalAttributeIdentifiers;
import com.ibm.team.workitem.common.internal.identifiers.IInternalTypeIdentifiers;
import com.ibm.team.workitem.common.internal.identifiers.IPublicItem;
import com.ibm.team.workitem.common.internal.identifiers.IdentifierMapping;
import com.ibm.team.workitem.common.internal.identifiers.IdentifierRegistry;
import com.ibm.team.workitem.common.internal.model.EnumerationListAttributeType;
import com.ibm.team.workitem.common.internal.template.Messages;
import com.ibm.team.workitem.common.internal.util.IterationsHelper;
import com.ibm.team.workitem.common.internal.util.SeparatedStringList;
import com.ibm.team.workitem.common.internal.workflow.InternalWorkflowKeys;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IPriority;
import com.ibm.team.workitem.common.model.IResolution;
import com.ibm.team.workitem.common.model.ISeverity;
import com.ibm.team.workitem.common.model.IState;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.workflow.IWorkflowAction;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.math.BigDecimal;
import java.net.URI;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class WorkItemTemplateFacade
extends AttributeFacade {
    private static final IProgressMonitor MONITOR = new NullProgressMonitor();
    private static final String EMPTY_STRING = "";
    private static final List<String> IGNORED_ATTRIBUTES = Arrays.asList(IInternalAttributeIdentifiers.WORKITEM_IDENTIFIER.getStringIdentifier(), IInternalAttributeIdentifiers.WORKITEM_CREATION_DATE.getStringIdentifier(), IInternalAttributeIdentifiers.WORKITEM_MODIFIED.getStringIdentifier(), IInternalAttributeIdentifiers.WORKITEM_MODIFIED_BY.getStringIdentifier(), IInternalAttributeIdentifiers.WORKITEM_PROJECT_AREA.getStringIdentifier(), IInternalAttributeIdentifiers.WORKITEM_TYPE.getStringIdentifier(), IInternalAttributeIdentifiers.WORKITEM_APPROVALS.getStringIdentifier(), IInternalAttributeIdentifiers.WORKITEM_COMMENTS.getStringIdentifier());

    public WorkItemTemplateFacade(Class<IdentifierRegistry> registry, IProjectAreaHandle projectArea, IWorkItemCommon itemCommon) throws TeamRepositoryException {
        super(registry, projectArea, itemCommon, MONITOR);
    }

    @Override
    public String getNamespace(Identifier<? extends IPublicItem> id) {
        String result = super.getNamespace(id);
        if (result == null) {
            result = "http://jazz.net/xmlns/prod/jazz/rtc/ext/1.0/";
        }
        return result;
    }

    @Override
    public Object getInternalValue(Identifier<? extends IItem> identifier, String pubValue) {
        if (pubValue == null) {
            return null;
        }
        Identifier<IAttributeType> intTypeId = this.getAttributeType(identifier);
        if (intTypeId != null) {
            try {
                if (identifier.getType().isAssignableFrom(ILink.class)) {
                    String linkId = identifier.getStringIdentifier();
                    String endPointId = linkId.substring(linkId.lastIndexOf(46) + 1);
                    ILinkType linkType = ILinkTypeRegistry.INSTANCE.getLinkType(linkId.substring(0, linkId.lastIndexOf(46)));
                    if (IdentifierMapping.getLinkId(linkType.getSourceEndPointDescriptor()).equals(endPointId)) {
                        return linkType.getSourceEndPointDescriptor();
                    }
                    return linkType.getTargetEndPointDescriptor();
                }
                if ((intTypeId = this.adjustMultiValueIdenfiers(intTypeId)).equals(IInternalTypeIdentifiers.CATEGORY)) {
                    return this.toCategory(pubValue, MONITOR);
                }
                if (intTypeId.equals(IInternalTypeIdentifiers.ITERATION)) {
                    return this.toIteration(pubValue, MONITOR);
                }
                if (intTypeId.equals(IInternalTypeIdentifiers.CONTRIBUTOR)) {
                    return this.toContributor(pubValue, MONITOR);
                }
                if (intTypeId.equals(IInternalTypeIdentifiers.DELIVERABLE) || intTypeId.equals(IInternalTypeIdentifiers.WORK_ITEM) || intTypeId.equals(IInternalTypeIdentifiers.PROCESS_AREA) || intTypeId.equals(IInternalTypeIdentifiers.PROJECT_AREA) || intTypeId.equals(IInternalTypeIdentifiers.TEAM_AREA)) {
                    return this.toItem(pubValue, MONITOR);
                }
                if (intTypeId.equals(IInternalTypeIdentifiers.PRIORITY)) {
                    return this.toIdentifier(IPriority.class, pubValue);
                }
                if (intTypeId.equals(IInternalTypeIdentifiers.SEVERITY)) {
                    return this.toIdentifier(ISeverity.class, pubValue);
                }
                if (intTypeId.equals(IInternalTypeIdentifiers.UUID)) {
                    return this.toUUID(pubValue);
                }
                if (intTypeId.equals(IInternalTypeIdentifiers.TAGS)) {
                    return new SeparatedStringList(pubValue);
                }
                if (intTypeId.equals(IInternalTypeIdentifiers.TAG) || intTypeId.equals(IInternalTypeIdentifiers.MEDIUM_HTML) || intTypeId.equals(IInternalTypeIdentifiers.LARGE_HTML) || intTypeId.equals(IInternalTypeIdentifiers.SMALL_STRING) || intTypeId.equals(IInternalTypeIdentifiers.MEDIUM_STRING) || intTypeId.equals(IInternalTypeIdentifiers.LARGE_STRING) || intTypeId.equals(IInternalTypeIdentifiers.WIKI)) {
                    return pubValue;
                }
                if (intTypeId.equals(IInternalTypeIdentifiers.TIMESTAMP)) {
                    return DateUtils.parseTimeRFC3339((String)pubValue);
                }
                if (intTypeId.equals(IInternalTypeIdentifiers.BOOLEAN)) {
                    return Boolean.parseBoolean(pubValue);
                }
                if (intTypeId.equals(IInternalTypeIdentifiers.DECIMAL)) {
                    return new BigDecimal(pubValue);
                }
                if (intTypeId.equals(IInternalTypeIdentifiers.FLOAT)) {
                    return Float.valueOf(Float.parseFloat(pubValue));
                }
                if (intTypeId.equals(IInternalTypeIdentifiers.LONG) || intTypeId.equals(IInternalTypeIdentifiers.DURATION)) {
                    return Long.parseLong(pubValue);
                }
                if (intTypeId.equals(IInternalTypeIdentifiers.INTEGER)) {
                    return Integer.parseInt(pubValue);
                }
                return Identifier.create(ILiteral.class, pubValue);
            }
            catch (TeamRepositoryException teamRepositoryException) {
            }
            catch (ParseException parseException) {}
        }
        return null;
    }

    @Override
    public String getPublicValue(Identifier<? extends IItem> identifier, Object internalValue) {
        if (internalValue == null) {
            return null;
        }
        Identifier<IAttributeType> typeId = this.getAttributeType(identifier);
        if (typeId != null) {
            try {
                typeId = this.adjustMultiValueIdenfiers(typeId);
                if (typeId.equals(IInternalTypeIdentifiers.CATEGORY)) {
                    return this.fromCategory((ICategoryHandle)internalValue, MONITOR);
                }
                if (typeId.equals(IInternalTypeIdentifiers.ITERATION)) {
                    return this.fromIteration((IIterationHandle)internalValue, MONITOR);
                }
                if (typeId.equals(IInternalTypeIdentifiers.CONTRIBUTOR)) {
                    return this.fromContributor((IContributorHandle)internalValue, MONITOR);
                }
                if (typeId.equals(IInternalTypeIdentifiers.DELIVERABLE) || typeId.equals(IInternalTypeIdentifiers.WORK_ITEM) || typeId.equals(IInternalTypeIdentifiers.PROCESS_AREA) || typeId.equals(IInternalTypeIdentifiers.PROJECT_AREA) || typeId.equals(IInternalTypeIdentifiers.TEAM_AREA)) {
                    return this.fromItem((IItemHandle)internalValue);
                }
                if (typeId.equals(IInternalTypeIdentifiers.PRIORITY) || typeId.equals(IInternalTypeIdentifiers.SEVERITY)) {
                    return this.fromIdentifier((Identifier)internalValue);
                }
                if (typeId.equals(IInternalTypeIdentifiers.UUID)) {
                    return this.fromUUID((UUID)internalValue);
                }
                if (typeId.equals(IInternalTypeIdentifiers.TAGS)) {
                    return ((SeparatedStringList)internalValue).getSeparatedString();
                }
                if (typeId.equals(IInternalTypeIdentifiers.TAG) || typeId.equals(IInternalTypeIdentifiers.MEDIUM_HTML) || typeId.equals(IInternalTypeIdentifiers.LARGE_HTML) || typeId.equals(IInternalTypeIdentifiers.SMALL_STRING) || typeId.equals(IInternalTypeIdentifiers.MEDIUM_STRING) || typeId.equals(IInternalTypeIdentifiers.LARGE_STRING) || typeId.equals(IInternalTypeIdentifiers.WIKI)) {
                    return (String)internalValue;
                }
                if (typeId.equals(IInternalTypeIdentifiers.TIMESTAMP)) {
                    return DateUtils.formatTimeRFC3339((Date)((Timestamp)internalValue));
                }
                if (typeId.equals(IInternalTypeIdentifiers.BOOLEAN)) {
                    return ((Boolean)internalValue).toString();
                }
                if (typeId.equals(IInternalTypeIdentifiers.FLOAT)) {
                    return ((Float)internalValue).toString();
                }
                if (typeId.equals(IInternalTypeIdentifiers.DECIMAL)) {
                    return ((BigDecimal)internalValue).toString();
                }
                if (typeId.equals(IInternalTypeIdentifiers.LONG) || typeId.equals(IInternalTypeIdentifiers.DURATION)) {
                    return ((Long)internalValue).toString();
                }
                if (typeId.equals(IInternalTypeIdentifiers.INTEGER)) {
                    return ((Integer)internalValue).toString();
                }
                if (internalValue instanceof Identifier) {
                    return ((Identifier)internalValue).getStringIdentifier();
                }
            }
            catch (TeamRepositoryException teamRepositoryException) {}
        }
        return null;
    }

    public static boolean isDefaultValue(IWorkItemCommon workItemCommon, IAttribute attribute, IWorkItem newState, Object value) throws TeamRepositoryException {
        if ("duration".equals(attribute.getAttributeType()) && value instanceof Long) {
            return (Long)value == 0L || (Long)value == -1L;
        }
        if (IWorkItem.STATE_PROPERTY.equals(attribute.getIdentifier())) {
            Identifier<IState> state;
            Identifier<IWorkflowAction> startActionId;
            IWorkflowInfo workflowInfo = workItemCommon.findWorkflowInfo(newState, null);
            return workflowInfo != null && (startActionId = workflowInfo.getStartActionId()) != null && (state = workflowInfo.getActionResultState(startActionId)) != null && state.getStringIdentifier().equals(value);
        }
        if (IWorkItem.RESOLUTION_PROPERTY.equals(attribute.getIdentifier())) {
            Identifier<IResolution>[] resolutionIds;
            Identifier<IWorkflowAction> startActionId;
            if (value == null || EMPTY_STRING.equals(value) || InternalWorkflowKeys.LEGACY_ECLIPSEWAY_RESOLUTION_UNRESOLVED.getStringIdentifier().equals(value)) {
                return true;
            }
            IWorkflowInfo workflowInfo = workItemCommon.findWorkflowInfo(newState, null);
            if (workflowInfo != null && (startActionId = workflowInfo.getStartActionId()) != null && (resolutionIds = workflowInfo.getResolutionIds(startActionId)).length > 0) {
                Identifier<IResolution> defaultResolution = resolutionIds[0];
                return defaultResolution.getStringIdentifier().equals(value);
            }
            return false;
        }
        if (value instanceof AbstractCollection) {
            Object next;
            if ("subscriptions".equals(attribute.getAttributeType()) && ((AbstractCollection)value).size() == 1 && (next = ((AbstractCollection)value).iterator().next()) instanceof IItemHandle && ((IItemHandle)next).sameItemId((IItemHandle)workItemCommon.getAuditableCommon().getUser())) {
                return true;
            }
            return ((AbstractCollection)value).size() == 0;
        }
        Object defaultValue = attribute.getDefaultValue(workItemCommon.getAuditableCommon(), newState, null);
        if (defaultValue instanceof String && value instanceof String) {
            return defaultValue.equals(value);
        }
        if (defaultValue instanceof IItemHandle && value instanceof IItemHandle) {
            IItemHandle dfltItem = (IItemHandle)defaultValue;
            IItemHandle newValue = (IItemHandle)value;
            return dfltItem.getItemId().equals((Object)newValue.getItemId());
        }
        return value == defaultValue || value != null && value.equals(defaultValue);
    }

    public static boolean isSupportedWorkItemAttribute(IAttribute attribute) throws TeamRepositoryException {
        if (attribute == null || attribute.isInternal() || attribute.isReadOnly()) {
            return false;
        }
        return !IGNORED_ATTRIBUTES.contains(attribute.getIdentifier());
    }

    @Override
    public boolean isMultiValueAttribute(Identifier<IAttribute> identifier) {
        Identifier attributeType = this.getAttributeType(identifier);
        return attributeType != null && (attributeType.equals(IInternalTypeIdentifiers.APPROVALS) || attributeType.equals(IInternalTypeIdentifiers.APPROVAL_DESCRIPTORS) || attributeType.equals(IInternalTypeIdentifiers.COMMENTS) || attributeType.equals(IInternalTypeIdentifiers.CONTRIBUTOR_LIST) || attributeType.equals(IInternalTypeIdentifiers.PROCESS_AREA_LIST) || attributeType.equals(IInternalTypeIdentifiers.PROJECT_AREA_LIST) || attributeType.equals(IInternalTypeIdentifiers.SUBSCRIPTIONS) || attributeType.equals(IInternalTypeIdentifiers.TEAM_AREA_LIST) || attributeType.equals(IInternalTypeIdentifiers.WORK_ITEM_LIST) || EnumerationListAttributeType.isEnumerationListIdentifier(attributeType.getStringIdentifier()));
    }

    private String fromIdentifier(Identifier<?> id) {
        return id.getStringIdentifier();
    }

    private <T> Identifier<T> toIdentifier(Class<T> type, String stringIdentifier) {
        return Identifier.create(type, stringIdentifier);
    }

    private String fromItem(IItemHandle handle) {
        Location location = Location.itemLocation((IItemHandle)handle, (String)this.getAuditableCommon().getRepositoryURI());
        return location.toAbsoluteUri().toString();
    }

    private IItem toItem(String pubValue, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            Location location = Location.location((URI)URI.create(pubValue));
            IItemType itemType = location.getItemType();
            if (itemType == null) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.getString("WorkItemTemplateFacade.ERROR_ILLEGAL_ITEM_REFERENCE"), (Object)pubValue, (Object[])new Object[0]));
            }
            return this.getAuditableCommon().resolveAuditableByLocation(location, ItemProfile.createFullProfile(itemType), monitor);
        }
        catch (IllegalArgumentException ex) {
            throw new TeamRepositoryException(ex.getCause());
        }
    }

    private String fromUUID(UUID id) {
        return id.getUuidValue();
    }

    private UUID toUUID(String pubValue) {
        return UUID.valueOf((String)pubValue);
    }

    private String fromContributor(IContributorHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        IContributor con = this.getAuditableCommon().fetchCurrentAuditable((IAuditableHandle)handle, ItemProfile.CONTRIBUTOR_DEFAULT, monitor);
        return con.getUserId();
    }

    private IContributorHandle toContributor(String pubValue, IProgressMonitor monitor) throws TeamRepositoryException {
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)BaseContributorQueryModel.ContributorQueryModel.ROOT);
        query.filter(BaseContributorQueryModel.ContributorQueryModel.ROOT.userId()._eq(pubValue));
        QueryIterator queryIterator = this.getItemCommon().getAuditableCommon().getItemQueryIterator(query, new Object[0], null, null);
        try {
            if (queryIterator.hasNext(monitor)) {
                IContributorHandle iContributorHandle = (IContributorHandle)queryIterator.next(monitor);
                return iContributorHandle;
            }
        }
        finally {
            queryIterator.close();
        }
        return null;
    }

    private String fromIteration(IIterationHandle iteration, IProgressMonitor monitor) throws TeamRepositoryException {
        return IterationsHelper.createIterationPath(iteration, this.getAuditableCommon(), monitor);
    }

    private IIteration toIteration(String pubValue, IProgressMonitor monitor) throws TeamRepositoryException {
        return IterationsHelper.resolveIterationFromPath((IProcessAreaHandle)this.getProjectArea(monitor), pubValue, this.getAuditableCommon(), monitor);
    }

    private String fromCategory(ICategoryHandle category, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getItemCommon().resolveHierarchicalName(category, monitor);
    }

    private ICategoryHandle toCategory(String pubValue, IProgressMonitor monitor) throws TeamRepositoryException {
        ICategory unassignedCategory;
        String[] namePath = pubValue.split("/");
        ICategoryHandle result = this.getItemCommon().findCategoryByNamePath((IProjectAreaHandle)this.getProjectArea(monitor), Arrays.asList(namePath), monitor);
        if (result == null && (unassignedCategory = this.getItemCommon().findUnassignedCategory((IProjectAreaHandle)this.getProjectArea(monitor), ICategory.SMALL_PROFILE, null)).getCategoryId().getInternalRepresentation().replace("/", EMPTY_STRING).equals(pubValue)) {
            result = unassignedCategory;
        }
        return result;
    }

    private Identifier<IAttributeType> adjustMultiValueIdenfiers(Identifier<IAttributeType> typeId) {
        if (typeId.equals(IInternalTypeIdentifiers.SUBSCRIPTIONS) || typeId.equals(IInternalTypeIdentifiers.CONTRIBUTOR_LIST)) {
            typeId = IInternalTypeIdentifiers.CONTRIBUTOR;
        } else if (typeId.equals(IInternalTypeIdentifiers.PROCESS_AREA_LIST)) {
            typeId = IInternalTypeIdentifiers.PROCESS_AREA;
        } else if (typeId.equals(IInternalTypeIdentifiers.PROJECT_AREA_LIST)) {
            typeId = IInternalTypeIdentifiers.PROJECT_AREA;
        } else if (typeId.equals(IInternalTypeIdentifiers.TEAM_AREA_LIST)) {
            typeId = IInternalTypeIdentifiers.TEAM_AREA;
        } else if (typeId.equals(IInternalTypeIdentifiers.WORK_ITEM_LIST)) {
            typeId = IInternalTypeIdentifiers.WORK_ITEM;
        }
        return typeId;
    }
}

