/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.workitem.common.internal.model.Category;
import com.ibm.team.workitem.common.internal.util.CategoriesHelper;
import com.ibm.team.workitem.common.internal.util.CategoriesManager;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.CategoryId;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;

public class CategoryTreeNode {
    private final CategoriesManager fManager;
    private CategoryTreeNode fParent;
    private final Set<CategoryTreeNode> fChildren;
    private Category fCategory;
    private boolean fDirty;

    static CategoryTreeNode createRoot(CategoriesManager manager, ICategory category) {
        Assert.isTrue((!category.isWorkingCopy() ? 1 : 0) != 0);
        Assert.isTrue((boolean)CategoriesHelper.isRootCategoryId(category.getCategoryId()));
        return new CategoryTreeNode(manager, null, (ICategory)category.getWorkingCopy(), false);
    }

    private CategoryTreeNode(CategoryTreeNode parent, ICategory category, boolean isNew) {
        this(parent.fManager, parent, category, isNew);
    }

    private CategoryTreeNode(CategoriesManager manager, CategoryTreeNode parent, ICategory category, boolean isNew) {
        Assert.isNotNull((Object)manager);
        Assert.isNotNull((Object)category);
        this.fManager = manager;
        this.fParent = parent;
        this.fCategory = (Category)category;
        this.fDirty = isNew;
        this.fChildren = new HashSet<CategoryTreeNode>();
        if (this.fParent != null) {
            if (isNew) {
                this.fParent.addNewChild(this);
            } else {
                this.fParent.addExistingChild(this);
            }
        }
        this.checkConsistency();
    }

    private void checkConsistency() {
        ITeamAreaHandle defaultTeamArea = this.fCategory.getDefaultTeamArea();
        if (defaultTeamArea != null) {
            boolean found = false;
            for (ITeamAreaHandle teamArea : this.fCategory.getTeamAreas()) {
                if (!defaultTeamArea.sameItemId((IItemHandle)teamArea)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.fDirty = true;
                this.fCategory.getTeamAreas().add(defaultTeamArea);
            }
        }
        ItemHandleAwareHashSet<IDevelopmentLine> seen = new ItemHandleAwareHashSet<IDevelopmentLine>();
        if (defaultTeamArea != null) {
            IDevelopmentLine line = this.fManager.getDevelopmentLine(defaultTeamArea);
            seen.add(line);
        }
        Iterator iter = this.fCategory.getTeamAreas().iterator();
        while (iter.hasNext()) {
            ITeamAreaHandle teamArea = (ITeamAreaHandle)iter.next();
            if (teamArea == null) {
                this.fDirty = true;
                iter.remove();
                continue;
            }
            IDevelopmentLine line = this.fManager.getDevelopmentLine(teamArea);
            if (seen.contains(line) && !teamArea.sameItemId((IItemHandle)defaultTeamArea)) {
                this.fDirty = true;
                iter.remove();
            }
            seen.add(line);
        }
    }

    public ICategoryHandle getCategory() {
        return (ICategoryHandle)this.fCategory.getItemHandle();
    }

    public CategoryId getCategoryId() {
        return this.fCategory.getCategoryId();
    }

    public String getName() {
        return this.fCategory.getName();
    }

    public void renameTo(String name) {
        Assert.isNotNull((Object)name);
        Assert.isTrue((name.length() > 0 ? 1 : 0) != 0);
        Assert.isNotNull((Object)this.getParent());
        if (!name.equals(this.getName())) {
            for (CategoryTreeNode sibling : this.getParent().getChildren()) {
                if (sibling == this) continue;
                Assert.isTrue((!name.equals(sibling.getName()) ? 1 : 0) != 0);
            }
            this.fDirty = true;
            this.fCategory.setName(name);
            this.updateCategoryIds(this.fCategory.getCategoryId(), name);
        }
    }

    private void updateCategoryIds(CategoryId from, String to) {
        this.updateCategoryId(from, to);
        for (CategoryTreeNode child : this.getChildren()) {
            child.updateCategoryIds(from, to);
        }
    }

    private void updateCategoryId(CategoryId from, String to) {
        this.fDirty = true;
        CategoriesHelper.updateCategoryId(this.fCategory, from, to);
    }

    public CategoryTreeNode getParent() {
        return this.fParent;
    }

    public Set<CategoryTreeNode> getChildren() {
        return Collections.unmodifiableSet(this.fChildren);
    }

    public CategoryTreeNode createChild(String name) {
        for (CategoryTreeNode node : this.getChildren()) {
            if (!node.getName().equals(name)) continue;
            node.archiveTree(false);
            return node;
        }
        ICategory category = CategoriesHelper.createCategory(this.fManager.getAuditableCommon(), this.getItem(), name);
        return new CategoryTreeNode(this, category, true);
    }

    CategoryTreeNode createChildFromExisting(ICategory category) {
        Assert.isTrue((!category.isWorkingCopy() ? 1 : 0) != 0);
        Assert.isTrue((!CategoriesHelper.isRootCategoryId(category.getCategoryId()) ? 1 : 0) != 0);
        return new CategoryTreeNode(this, (ICategory)category.getWorkingCopy(), false);
    }

    public ITeamArea getTeamArea(IDevelopmentLineHandle line) {
        if (line != null) {
            for (ITeamAreaHandle teamArea : this.fCategory.getTeamAreas()) {
                if (!line.sameItemId((IItemHandle)this.fManager.getDevelopmentLine(teamArea))) continue;
                return this.fManager.getTeamArea(teamArea);
            }
            return null;
        }
        ITeamAreaHandle teamArea = this.fCategory.getDefaultTeamArea();
        if (teamArea == null) {
            return null;
        }
        return this.fManager.getTeamArea(teamArea);
    }

    public void setDefaultTeamArea(ITeamAreaHandle handle) {
        ITeamArea teamArea = null;
        if (handle != null) {
            teamArea = this.fManager.getTeamArea(handle);
            Assert.isNotNull((Object)teamArea);
        }
        this.associateSubtree(null, (ITeamAreaHandle)teamArea);
    }

    public void setDevelopmentLineTeamArea(ITeamAreaHandle handle) {
        ITeamArea teamArea = this.fManager.getTeamArea(handle);
        Assert.isNotNull((Object)teamArea);
        IDevelopmentLine developmentLine = this.fManager.getDevelopmentLine(handle);
        Assert.isNotNull((Object)developmentLine);
        this.associateSubtree((IDevelopmentLineHandle)developmentLine, (ITeamAreaHandle)teamArea);
    }

    public void clearDevelopmentLineTeamArea(IDevelopmentLineHandle developmentLine) {
        this.associateSubtree(developmentLine, null);
    }

    public void disassociate(IDevelopmentLineHandle developmentLine, boolean forceNull) {
        this.associateSubtree(developmentLine, (ITeamAreaHandle)(forceNull ? null : (this.getParent() != null ? this.getParent().getTeamArea(developmentLine) : null)));
    }

    public boolean canDisassociate(IDevelopmentLineHandle developmentLine) {
        ITeamArea teamArea = this.getTeamArea(developmentLine);
        return teamArea != null && !this.equals((IItemHandle)teamArea, (IItemHandle)(this.getParent() != null ? this.getParent().getTeamArea(developmentLine) : null)) || teamArea == null && this.getParent() != null && this.getParent().getTeamArea(developmentLine) != null;
    }

    private void associateSubtree(IDevelopmentLineHandle line, ITeamAreaHandle teamArea) {
        ITeamArea oldTeamArea = this.getTeamArea(line);
        this.associateNode(line, teamArea);
        for (CategoryTreeNode child : this.getChildren()) {
            if (!this.equals((IItemHandle)oldTeamArea, (IItemHandle)child.getTeamArea(line))) continue;
            child.associateSubtree(line, teamArea);
        }
    }

    private void associateNode(IDevelopmentLineHandle line, ITeamAreaHandle teamArea) {
        Assert.isTrue((teamArea == null || this.fManager.getTeamArea(teamArea) != null ? 1 : 0) != 0);
        if (this.equals((IItemHandle)teamArea, (IItemHandle)this.getTeamArea(line))) {
            return;
        }
        this.fDirty = true;
        if (line != null) {
            this.basicAssociateLine(line, teamArea);
            ITeamAreaHandle defaultTeamArea = this.fCategory.getDefaultTeamArea();
            if (defaultTeamArea != null && line.sameItemId((IItemHandle)this.fManager.getDevelopmentLine(defaultTeamArea))) {
                this.fCategory.setDefaultTeamArea(teamArea);
            }
        } else {
            ITeamAreaHandle oldDefault = this.fCategory.getDefaultTeamArea();
            if (oldDefault != null) {
                IDevelopmentLine oldLine = this.fManager.getDevelopmentLine(oldDefault);
                this.basicAssociateLine((IDevelopmentLineHandle)oldLine, null);
            }
            this.fCategory.setDefaultTeamArea(teamArea);
            if (teamArea != null) {
                this.basicAssociateLine((IDevelopmentLineHandle)this.fManager.getDevelopmentLine(teamArea), teamArea);
            }
        }
    }

    private void basicAssociateLine(IDevelopmentLineHandle line, ITeamAreaHandle teamArea) {
        Assert.isTrue((teamArea == null || this.equals((IItemHandle)line, (IItemHandle)this.fManager.getDevelopmentLine(teamArea)) ? 1 : 0) != 0);
        Iterator iter = this.fCategory.getTeamAreas().iterator();
        while (iter.hasNext()) {
            IDevelopmentLine teamAreaDevLine = this.fManager.getDevelopmentLine((ITeamAreaHandle)iter.next());
            if (!this.equals((IItemHandle)line, (IItemHandle)teamAreaDevLine)) continue;
            iter.remove();
        }
        if (teamArea != null) {
            this.fCategory.getTeamAreas().add(teamArea);
        }
    }

    public boolean isFiltered() {
        return this.fCategory.isFiltered();
    }

    public void filterTree(boolean filtered) {
        if (!filtered) {
            this.unfilterPath(this.getParent());
        }
        this.setFiltered(filtered);
        for (CategoryTreeNode child : this.getChildren()) {
            child.filterTree(filtered);
        }
    }

    private void unfilterPath(CategoryTreeNode node) {
        if (node == null) {
            return;
        }
        node.setFiltered(false);
        this.unfilterPath(node.getParent());
    }

    private void setFiltered(boolean filtered) {
        if (filtered != this.fCategory.isFiltered()) {
            this.fDirty = true;
            this.fCategory.setFiltered(filtered);
        }
    }

    public boolean isArchived() {
        return this.fCategory.isArchived();
    }

    public boolean isUnassigned() {
        return this.fCategory.isUnassigned();
    }

    public void archiveTree(boolean archived) {
        if (!archived) {
            this.unarchivePath(this.getParent());
        }
        this.setArchived(archived);
        for (CategoryTreeNode child : this.getChildren()) {
            child.archiveTree(archived);
        }
    }

    private void unarchivePath(CategoryTreeNode node) {
        if (node == null) {
            return;
        }
        node.setArchived(false);
        this.unfilterPath(node.getParent());
    }

    void setArchived(boolean archived) {
        if (archived != this.fCategory.isArchived()) {
            this.fDirty = true;
            this.fCategory.setArchived(archived);
        }
    }

    public List<ITeamAreaHandle> getTeamAreas() {
        return this.fCategory.getAssociatedTeamAreas();
    }

    public void moveTo(CategoryTreeNode newParent) {
        Assert.isTrue((newParent.getManager() == this.getManager() ? 1 : 0) != 0);
        Assert.isNotNull((Object)this.getParent());
        Assert.isTrue((!newParent.isSubcategory(this) ? 1 : 0) != 0);
        if (this.getParent() == newParent) {
            return;
        }
        CategoryId newId = CategoriesHelper.createCategoryId(newParent.getCategoryId(), this.getName());
        for (CategoryTreeNode child : newParent.getChildren()) {
            Assert.isTrue((!child.getCategoryId().equals(newId) ? 1 : 0) != 0);
        }
        CategoryTreeNode oldParent = this.getParent();
        this.fDirty = true;
        oldParent.removeChild(this);
        newParent.addNewChild(this);
        this.fParent = newParent;
        this.updateCategoryIds(oldParent.getCategoryId(), newParent.getCategoryId());
        if (newParent.isArchived() && !this.isArchived()) {
            this.archiveTree(true);
        }
        if (newParent.isFiltered() && !this.isFiltered()) {
            this.filterTree(true);
        }
        if (newParent.isReadAccessEnabled() && !this.isReadAccessEnabled()) {
            this.readAccessTree(true);
        }
        if (this.equals((IItemHandle)oldParent.getTeamArea(null), (IItemHandle)this.getTeamArea(null))) {
            this.setDefaultTeamArea((ITeamAreaHandle)newParent.getTeamArea(null));
        }
        for (IDevelopmentLine developmentLine : this.getManager().getDevelopmentLines()) {
            if (!this.equals((IItemHandle)oldParent.getTeamArea((IDevelopmentLineHandle)developmentLine), (IItemHandle)this.getTeamArea((IDevelopmentLineHandle)developmentLine))) continue;
            this.associateSubtree((IDevelopmentLineHandle)developmentLine, (ITeamAreaHandle)newParent.getTeamArea((IDevelopmentLineHandle)developmentLine));
        }
    }

    private void updateCategoryIds(CategoryId from, CategoryId to) {
        this.updateCategoryId(from, to);
        for (CategoryTreeNode child : this.getChildren()) {
            child.updateCategoryIds(from, to);
        }
    }

    private void updateCategoryId(CategoryId from, CategoryId to) {
        this.fDirty = true;
        CategoriesHelper.updateCategoryId(this.fCategory, from, to);
    }

    public boolean isSubcategory(CategoryTreeNode node) {
        return this.getCategoryId().getInternalRepresentation().startsWith(node.getCategoryId().getInternalRepresentation());
    }

    private void addNewChild(CategoryTreeNode child) {
        this.fDirty = true;
        this.addExistingChild(child);
    }

    private void addExistingChild(CategoryTreeNode child) {
        for (CategoryTreeNode node : this.fChildren) {
            Assert.isTrue((!node.getCategory().sameItemId((IItemHandle)child.getCategory()) ? 1 : 0) != 0);
            Assert.isTrue((!node.getCategoryId().equals(child.getCategoryId()) ? 1 : 0) != 0);
        }
        this.fChildren.add(child);
    }

    boolean removeChild(CategoryTreeNode child) {
        return this.fChildren.remove(child);
    }

    public XMLString getDescription() {
        return this.fCategory.getHTMLDescription();
    }

    public void setDescription(XMLString description) {
        if (!this.fCategory.getHTMLDescription().equals((Object)description)) {
            this.fCategory.setHTMLDescription(description);
            this.fDirty = true;
        }
    }

    public boolean isReadAccessEnabled() {
        return this.fCategory.isReadAccessEnabled();
    }

    public void readAccessTree(boolean enabled) {
        if (!enabled) {
            this.disableReadAccessPath(this.getParent());
        }
        this.setReadAccessEnabled(enabled);
        for (CategoryTreeNode child : this.getChildren()) {
            child.readAccessTree(enabled);
        }
    }

    private void disableReadAccessPath(CategoryTreeNode node) {
        if (node == null) {
            return;
        }
        node.setReadAccessEnabled(false);
        this.disableReadAccessPath(node.getParent());
    }

    public void setReadAccessEnabled(boolean value) {
        if (this.fCategory.isReadAccessEnabled() != value) {
            this.fCategory.setReadAccessEnabled(value);
            this.fDirty = true;
        }
    }

    boolean isDirty() {
        return this.fDirty;
    }

    ICategory getItem() {
        return this.fCategory;
    }

    void setItem(ICategory category) {
        Assert.isTrue((!category.isWorkingCopy() ? 1 : 0) != 0);
        this.fCategory = (Category)category.getWorkingCopy();
        this.fDirty = false;
    }

    public CategoriesManager getManager() {
        return this.fManager;
    }

    private boolean equals(IItemHandle left, IItemHandle right) {
        return left == right || left != null && left.sameItemId(right);
    }
}

