/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.QueryIterator;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;

public class ItemQueryIterator<T extends IItemHandle>
extends QueryIterator<T> {
    private final IAuditableCommon fAuditableCommon;
    private final IItemQuery fQuery;
    private final Object[] fParameters;
    private final UUID[] fContextIds;
    private final QueryIterator.ReadMode fReadMode;
    private IItemQueryPage fPage;
    private Iterator<T> fIterator;

    public ItemQueryIterator(IAuditableCommon auditableCommon, IItemQuery query, Object[] parameters, UUID[] contextIds, QueryIterator.ReadMode mode) {
        this.fAuditableCommon = auditableCommon;
        this.fQuery = query;
        this.fParameters = parameters != null ? parameters : IQueryService.EMPTY_PARAMETERS;
        this.fContextIds = contextIds;
        this.fReadMode = mode != null ? mode : QueryIterator.ReadMode.COMMITTED;
    }

    @Override
    public boolean hasNext(IProgressMonitor monitor) throws TeamRepositoryException {
        this.update(monitor);
        return this.fIterator.hasNext();
    }

    @Override
    public T next(IProgressMonitor monitor) throws TeamRepositoryException {
        this.update(monitor);
        return (T)((IItemHandle)this.fIterator.next());
    }

    private void update(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fPage == null) {
            this.fPage = this.fReadMode == QueryIterator.ReadMode.COMMITTED ? this.fAuditableCommon.queryItemsInContext(this.fQuery, this.fParameters, 512, this.fContextIds, monitor) : this.fAuditableCommon.uncommittedQueryItems(this.fQuery, this.fParameters, 512, monitor);
            this.fIterator = this.fPage.getItemHandles().iterator();
        }
        while (!this.fIterator.hasNext() && this.fPage.hasNext()) {
            this.fPage = (IItemQueryPage)this.fAuditableCommon.fetchPage(this.fPage.getToken(), this.fPage.getNextStartPosition(), 512, monitor);
            this.fIterator = this.fPage.getItemHandles().iterator();
        }
    }
}

