/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.wiki.transformer;

import com.ibm.team.repository.common.Location;
import java.net.URI;

public interface IItemReferenceDetector {
    public Reference detect(String var1);

    public static class Reference {
        private URI fUri;
        private Location fLocation;
        private String fId;
        private String fName;
        private String fContentType;

        public Reference(URI uri) {
            this(uri, null);
        }

        public Reference(URI uri, String id) {
            this.fUri = uri;
            this.fId = id;
        }

        public Reference(Location location) {
            this(location, null);
        }

        public Reference(Location location, String id) {
            this.fLocation = location;
            this.fId = id;
        }

        public String getReference() {
            if (this.fUri != null) {
                return this.fUri.toString();
            }
            if (this.fLocation != null) {
                return this.fLocation.toAbsoluteUri().toString();
            }
            return null;
        }

        public void setUri(URI uri) {
            this.fUri = uri;
        }

        public void setLocation(Location location) {
            this.fLocation = location;
        }

        public Location getLocation() {
            return this.fLocation;
        }

        public URI getUri() {
            return this.fUri;
        }

        public void setId(String id) {
            this.fId = id;
        }

        public String getId() {
            return this.fId;
        }

        public void setName(String name) {
            this.fName = name;
        }

        public String getName() {
            return this.fName;
        }

        public void setContentType(String ct) {
            this.fContentType = ct;
        }

        public String getContentType() {
            return this.fContentType;
        }
    }
}

