/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.internal.util;

import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.transport.TeamContent;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IWorkItemClient;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;

public class RemoteImages {
    public static URL getCachedImageContentServiceURL(URI uri) throws MalformedURLException {
        File file = RemoteImages.getLocalFile(uri, false);
        if (file.exists()) {
            return file.toURI().toURL();
        }
        return null;
    }

    public static URL resolveImageContent(IWorkItemClient workItemClient, URI uri, IProgressMonitor monitor) throws TeamRepositoryException, MalformedURLException {
        return RemoteImages.resolveImageContent(workItemClient, uri, false, monitor);
    }

    public static URL resolveImageContent(IWorkItemClient workItemClient, URI uri, boolean decorated, IProgressMonitor monitor) throws TeamRepositoryException, MalformedURLException {
        return RemoteImages.doResolveImageContent(workItemClient, uri, decorated, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static URL doResolveImageContent(IWorkItemClient workItemClient, URI uri, boolean decorated, IProgressMonitor monitor) throws TeamRepositoryException, MalformedURLException {
        File localFile = RemoteImages.getLocalFile(uri, decorated);
        if (localFile.exists()) return localFile.toURI().toURL();
        TeamContent content = workItemClient.getImageContent(uri, decorated, monitor);
        if (content == null) {
            localFile.delete();
            throw new ItemNotFoundException(NLS.bind((String)"Image not found: {0}", (Object)uri.toString(), (Object[])new Object[0]));
        }
        File tempFile = RemoteImages.createTempFile("remoteImage");
        try {
            FileOutputStream out = null;
            InputStream in = content.getInputStream();
            try {
                out = new FileOutputStream(tempFile);
                RemoteImages.copyStream(in, out);
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (IOException e) {
            tempFile.delete();
            throw new TeamRepositoryException("Could not stream image", (Throwable)e);
        }
        Class<RemoteImages> clazz = RemoteImages.class;
        synchronized (RemoteImages.class) {
            if (!localFile.exists()) {
                if (tempFile.renameTo(localFile)) return localFile.toURI().toURL();
                throw new TeamRepositoryException(NLS.bind((String)"Could not create {0}", (Object)localFile.getPath(), (Object[])new Object[0]));
            } else {
                tempFile.delete();
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return localFile.toURI().toURL();
        }
    }

    private static File createTempFile(String prefix) {
        IPath tempPath = RemoteImages.getRootURL().append(String.valueOf(prefix) + UUID.generate().getUuidValue() + ".tmp");
        return new File(tempPath.toOSString());
    }

    private static File getLocalFile(URI uri, boolean decorated) {
        Path path = new Path(uri.getPath());
        String scope = decorated && uri.getQuery() != null ? String.valueOf(uri.getHost()) + Integer.toString((String.valueOf(uri.getPath()) + uri.getQuery()).hashCode()) : String.valueOf(uri.getHost()) + Integer.toString(uri.getPath().hashCode());
        String identifier = path.lastSegment().replaceAll("[^\\w\\.]", "_");
        String osString = RemoteImages.getFilePathFromConfigArea(scope, identifier).toOSString();
        if (decorated && uri.getQuery() != null) {
            osString = osString.replace(".gif", ".png");
        }
        return new File(osString);
    }

    private static IPath getFilePathFromConfigArea(String scope, String identifier) {
        return RemoteImages.getRootURL().append(String.valueOf(scope) + "_" + identifier);
    }

    public static IPath getRootURL() {
        IPath path = RemoteImages.getRootPath();
        File root = new File((path = path.append("com.ibm.team.workitem.client.remoteImages")).toOSString());
        if (!root.exists()) {
            root.mkdir();
        }
        return path;
    }

    private static IPath getRootPath() {
        if (Platform.isRunning()) {
            ConfigurationScope configurationScope = new ConfigurationScope();
            return configurationScope.getLocation();
        }
        String tempDir = System.getProperty("java.io.tmpdir");
        return Path.fromOSString((String)tempDir);
    }

    private static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] buffer = new byte[1024];
        int readBytes = 0;
        while ((readBytes = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, readBytes);
        }
    }
}

