/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.dto.impl;

import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.scm.common.FlowFlags;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import com.ibm.team.scm.common.internal.dto.DateRange;
import com.ibm.team.scm.common.internal.dto.FlowFilter;
import com.ibm.team.scm.common.internal.dto.NameFilter;
import com.ibm.team.scm.common.internal.dto.ScmDtoFactory;
import com.ibm.team.scm.common.internal.dto.ScmDtoPackage;
import com.ibm.team.scm.common.internal.dto.WorkspaceEnum;
import com.ibm.team.scm.common.internal.dto.WorkspaceSearchCriteria;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class WorkspaceSearchCriteriaImpl
extends EObjectImpl
implements WorkspaceSearchCriteria {
    protected int ALL_FLAGS = 0;
    protected static final WorkspaceEnum KIND_EDEFAULT = WorkspaceEnum.WORKSPACES_LITERAL;
    protected WorkspaceEnum kind = KIND_EDEFAULT;
    protected static final int KIND_ESETFLAG = 1;
    protected NameFilter optionalNameFilter;
    protected static final int OPTIONAL_NAME_FILTER_ESETFLAG = 2;
    protected DateRange optionalDateRange;
    protected static final int OPTIONAL_DATE_RANGE_ESETFLAG = 4;
    protected FlowFilter optionalFlowFilter;
    protected static final int OPTIONAL_FLOW_FILTER_ESETFLAG = 8;
    protected EList optionalOwnerFilters;
    protected NameFilter optionalOwnerNameFilter;
    protected static final int OPTIONAL_OWNER_NAME_FILTER_ESETFLAG = 16;
    protected static final boolean NAME_UNION_EDEFAULT = false;
    protected static final int NAME_UNION_EFLAG = 32;
    protected static final int NAME_UNION_ESETFLAG = 64;
    protected static final boolean OLDEST_FIRST_EDEFAULT = false;
    protected static final int OLDEST_FIRST_EFLAG = 128;
    protected static final int OLDEST_FIRST_ESETFLAG = 256;

    protected WorkspaceSearchCriteriaImpl() {
    }

    protected EClass eStaticClass() {
        return ScmDtoPackage.eINSTANCE.getWorkspaceSearchCriteria();
    }

    @Override
    public WorkspaceEnum getKind() {
        return this.kind;
    }

    @Override
    public void setKind(WorkspaceEnum newKind) {
        WorkspaceEnum oldKind = this.kind;
        this.kind = newKind == null ? KIND_EDEFAULT : newKind;
        boolean oldKindESet = (this.ALL_FLAGS & 1) != 0;
        this.ALL_FLAGS |= 1;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldKind, (Object)this.kind, !oldKindESet));
        }
    }

    @Override
    public void unsetKind() {
        WorkspaceEnum oldKind = this.kind;
        boolean oldKindESet = (this.ALL_FLAGS & 1) != 0;
        this.kind = KIND_EDEFAULT;
        this.ALL_FLAGS &= 0xFFFFFFFE;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 0, (Object)oldKind, (Object)KIND_EDEFAULT, oldKindESet));
        }
    }

    @Override
    public boolean isSetKind() {
        return (this.ALL_FLAGS & 1) != 0;
    }

    @Override
    public NameFilter getOptionalNameFilter() {
        if (this.optionalNameFilter != null && ((EObject)this.optionalNameFilter).eIsProxy()) {
            InternalEObject oldOptionalNameFilter = (InternalEObject)this.optionalNameFilter;
            this.optionalNameFilter = (NameFilter)this.eResolveProxy(oldOptionalNameFilter);
            if (this.optionalNameFilter != oldOptionalNameFilter && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 1, (Object)oldOptionalNameFilter, (Object)this.optionalNameFilter));
            }
        }
        return this.optionalNameFilter;
    }

    public NameFilter basicGetOptionalNameFilter() {
        return this.optionalNameFilter;
    }

    @Override
    public void setOptionalNameFilter(NameFilter newOptionalNameFilter) {
        NameFilter oldOptionalNameFilter = this.optionalNameFilter;
        this.optionalNameFilter = newOptionalNameFilter;
        boolean oldOptionalNameFilterESet = (this.ALL_FLAGS & 2) != 0;
        this.ALL_FLAGS |= 2;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldOptionalNameFilter, (Object)this.optionalNameFilter, !oldOptionalNameFilterESet));
        }
    }

    @Override
    public void unsetOptionalNameFilter() {
        NameFilter oldOptionalNameFilter = this.optionalNameFilter;
        boolean oldOptionalNameFilterESet = (this.ALL_FLAGS & 2) != 0;
        this.optionalNameFilter = null;
        this.ALL_FLAGS &= 0xFFFFFFFD;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 1, (Object)oldOptionalNameFilter, null, oldOptionalNameFilterESet));
        }
    }

    @Override
    public boolean isSetOptionalNameFilter() {
        return (this.ALL_FLAGS & 2) != 0;
    }

    @Override
    public DateRange getOptionalDateRange() {
        if (this.optionalDateRange != null && ((EObject)this.optionalDateRange).eIsProxy()) {
            InternalEObject oldOptionalDateRange = (InternalEObject)this.optionalDateRange;
            this.optionalDateRange = (DateRange)this.eResolveProxy(oldOptionalDateRange);
            if (this.optionalDateRange != oldOptionalDateRange && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 2, (Object)oldOptionalDateRange, (Object)this.optionalDateRange));
            }
        }
        return this.optionalDateRange;
    }

    public DateRange basicGetOptionalDateRange() {
        return this.optionalDateRange;
    }

    @Override
    public void setOptionalDateRange(DateRange newOptionalDateRange) {
        DateRange oldOptionalDateRange = this.optionalDateRange;
        this.optionalDateRange = newOptionalDateRange;
        boolean oldOptionalDateRangeESet = (this.ALL_FLAGS & 4) != 0;
        this.ALL_FLAGS |= 4;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldOptionalDateRange, (Object)this.optionalDateRange, !oldOptionalDateRangeESet));
        }
    }

    @Override
    public void unsetOptionalDateRange() {
        DateRange oldOptionalDateRange = this.optionalDateRange;
        boolean oldOptionalDateRangeESet = (this.ALL_FLAGS & 4) != 0;
        this.optionalDateRange = null;
        this.ALL_FLAGS &= 0xFFFFFFFB;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 2, (Object)oldOptionalDateRange, null, oldOptionalDateRangeESet));
        }
    }

    @Override
    public boolean isSetOptionalDateRange() {
        return (this.ALL_FLAGS & 4) != 0;
    }

    @Override
    public FlowFilter getOptionalFlowFilter() {
        if (this.optionalFlowFilter != null && ((EObject)this.optionalFlowFilter).eIsProxy()) {
            InternalEObject oldOptionalFlowFilter = (InternalEObject)this.optionalFlowFilter;
            this.optionalFlowFilter = (FlowFilter)this.eResolveProxy(oldOptionalFlowFilter);
            if (this.optionalFlowFilter != oldOptionalFlowFilter && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 3, (Object)oldOptionalFlowFilter, (Object)this.optionalFlowFilter));
            }
        }
        return this.optionalFlowFilter;
    }

    public FlowFilter basicGetOptionalFlowFilter() {
        return this.optionalFlowFilter;
    }

    @Override
    public void setOptionalFlowFilter(FlowFilter newOptionalFlowFilter) {
        FlowFilter oldOptionalFlowFilter = this.optionalFlowFilter;
        this.optionalFlowFilter = newOptionalFlowFilter;
        boolean oldOptionalFlowFilterESet = (this.ALL_FLAGS & 8) != 0;
        this.ALL_FLAGS |= 8;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldOptionalFlowFilter, (Object)this.optionalFlowFilter, !oldOptionalFlowFilterESet));
        }
    }

    @Override
    public void unsetOptionalFlowFilter() {
        FlowFilter oldOptionalFlowFilter = this.optionalFlowFilter;
        boolean oldOptionalFlowFilterESet = (this.ALL_FLAGS & 8) != 0;
        this.optionalFlowFilter = null;
        this.ALL_FLAGS &= 0xFFFFFFF7;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 3, (Object)oldOptionalFlowFilter, null, oldOptionalFlowFilterESet));
        }
    }

    @Override
    public boolean isSetOptionalFlowFilter() {
        return (this.ALL_FLAGS & 8) != 0;
    }

    @Override
    public List getOptionalOwnerFilters() {
        if (this.optionalOwnerFilters == null) {
            this.optionalOwnerFilters = new EObjectResolvingEList.Unsettable(IAuditableHandle.class, (InternalEObject)this, 4){

                protected boolean isUnique() {
                    return false;
                }
            };
        }
        return this.optionalOwnerFilters;
    }

    @Override
    public void unsetOptionalOwnerFilters() {
        if (this.optionalOwnerFilters != null) {
            ((InternalEList.Unsettable)this.optionalOwnerFilters).unset();
        }
    }

    @Override
    public boolean isSetOptionalOwnerFilters() {
        return this.optionalOwnerFilters != null && ((InternalEList.Unsettable)this.optionalOwnerFilters).isSet();
    }

    @Override
    public NameFilter getOptionalOwnerNameFilter() {
        if (this.optionalOwnerNameFilter != null && ((EObject)this.optionalOwnerNameFilter).eIsProxy()) {
            InternalEObject oldOptionalOwnerNameFilter = (InternalEObject)this.optionalOwnerNameFilter;
            this.optionalOwnerNameFilter = (NameFilter)this.eResolveProxy(oldOptionalOwnerNameFilter);
            if (this.optionalOwnerNameFilter != oldOptionalOwnerNameFilter && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 5, (Object)oldOptionalOwnerNameFilter, (Object)this.optionalOwnerNameFilter));
            }
        }
        return this.optionalOwnerNameFilter;
    }

    public NameFilter basicGetOptionalOwnerNameFilter() {
        return this.optionalOwnerNameFilter;
    }

    @Override
    public void setOptionalOwnerNameFilter(NameFilter newOptionalOwnerNameFilter) {
        NameFilter oldOptionalOwnerNameFilter = this.optionalOwnerNameFilter;
        this.optionalOwnerNameFilter = newOptionalOwnerNameFilter;
        boolean oldOptionalOwnerNameFilterESet = (this.ALL_FLAGS & 0x10) != 0;
        this.ALL_FLAGS |= 0x10;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldOptionalOwnerNameFilter, (Object)this.optionalOwnerNameFilter, !oldOptionalOwnerNameFilterESet));
        }
    }

    @Override
    public void unsetOptionalOwnerNameFilter() {
        NameFilter oldOptionalOwnerNameFilter = this.optionalOwnerNameFilter;
        boolean oldOptionalOwnerNameFilterESet = (this.ALL_FLAGS & 0x10) != 0;
        this.optionalOwnerNameFilter = null;
        this.ALL_FLAGS &= 0xFFFFFFEF;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 5, (Object)oldOptionalOwnerNameFilter, null, oldOptionalOwnerNameFilterESet));
        }
    }

    @Override
    public boolean isSetOptionalOwnerNameFilter() {
        return (this.ALL_FLAGS & 0x10) != 0;
    }

    @Override
    public boolean isNameUnion() {
        return (this.ALL_FLAGS & 0x20) != 0;
    }

    @Override
    public void setNameUnion(boolean newNameUnion) {
        boolean oldNameUnion;
        boolean bl = oldNameUnion = (this.ALL_FLAGS & 0x20) != 0;
        this.ALL_FLAGS = newNameUnion ? (this.ALL_FLAGS |= 0x20) : (this.ALL_FLAGS &= 0xFFFFFFDF);
        boolean oldNameUnionESet = (this.ALL_FLAGS & 0x40) != 0;
        this.ALL_FLAGS |= 0x40;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, oldNameUnion, newNameUnion, !oldNameUnionESet));
        }
    }

    @Override
    public void unsetNameUnion() {
        boolean oldNameUnion = (this.ALL_FLAGS & 0x20) != 0;
        boolean oldNameUnionESet = (this.ALL_FLAGS & 0x40) != 0;
        this.ALL_FLAGS &= 0xFFFFFFDF;
        this.ALL_FLAGS &= 0xFFFFFFBF;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 6, oldNameUnion, false, oldNameUnionESet));
        }
    }

    @Override
    public boolean isSetNameUnion() {
        return (this.ALL_FLAGS & 0x40) != 0;
    }

    @Override
    public boolean isOldestFirst() {
        return (this.ALL_FLAGS & 0x80) != 0;
    }

    @Override
    public void setOldestFirst(boolean newOldestFirst) {
        boolean oldOldestFirst;
        boolean bl = oldOldestFirst = (this.ALL_FLAGS & 0x80) != 0;
        this.ALL_FLAGS = newOldestFirst ? (this.ALL_FLAGS |= 0x80) : (this.ALL_FLAGS &= 0xFFFFFF7F);
        boolean oldOldestFirstESet = (this.ALL_FLAGS & 0x100) != 0;
        this.ALL_FLAGS |= 0x100;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, oldOldestFirst, newOldestFirst, !oldOldestFirstESet));
        }
    }

    @Override
    public void unsetOldestFirst() {
        boolean oldOldestFirst = (this.ALL_FLAGS & 0x80) != 0;
        boolean oldOldestFirstESet = (this.ALL_FLAGS & 0x100) != 0;
        this.ALL_FLAGS &= 0xFFFFFF7F;
        this.ALL_FLAGS &= 0xFFFFFEFF;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 7, oldOldestFirst, false, oldOldestFirstESet));
        }
    }

    @Override
    public boolean isSetOldestFirst() {
        return (this.ALL_FLAGS & 0x100) != 0;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getKind();
            }
            case 1: {
                if (resolve) {
                    return this.getOptionalNameFilter();
                }
                return this.basicGetOptionalNameFilter();
            }
            case 2: {
                if (resolve) {
                    return this.getOptionalDateRange();
                }
                return this.basicGetOptionalDateRange();
            }
            case 3: {
                if (resolve) {
                    return this.getOptionalFlowFilter();
                }
                return this.basicGetOptionalFlowFilter();
            }
            case 4: {
                return this.getOptionalOwnerFilters();
            }
            case 5: {
                if (resolve) {
                    return this.getOptionalOwnerNameFilter();
                }
                return this.basicGetOptionalOwnerNameFilter();
            }
            case 6: {
                return this.isNameUnion() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 7: {
                return this.isOldestFirst() ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setKind((WorkspaceEnum)((Object)newValue));
                return;
            }
            case 1: {
                this.setOptionalNameFilter((NameFilter)newValue);
                return;
            }
            case 2: {
                this.setOptionalDateRange((DateRange)newValue);
                return;
            }
            case 3: {
                this.setOptionalFlowFilter((FlowFilter)newValue);
                return;
            }
            case 4: {
                this.getOptionalOwnerFilters().clear();
                this.getOptionalOwnerFilters().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setOptionalOwnerNameFilter((NameFilter)newValue);
                return;
            }
            case 6: {
                this.setNameUnion((Boolean)newValue);
                return;
            }
            case 7: {
                this.setOldestFirst((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.unsetKind();
                return;
            }
            case 1: {
                this.unsetOptionalNameFilter();
                return;
            }
            case 2: {
                this.unsetOptionalDateRange();
                return;
            }
            case 3: {
                this.unsetOptionalFlowFilter();
                return;
            }
            case 4: {
                this.unsetOptionalOwnerFilters();
                return;
            }
            case 5: {
                this.unsetOptionalOwnerNameFilter();
                return;
            }
            case 6: {
                this.unsetNameUnion();
                return;
            }
            case 7: {
                this.unsetOldestFirst();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.isSetKind();
            }
            case 1: {
                return this.isSetOptionalNameFilter();
            }
            case 2: {
                return this.isSetOptionalDateRange();
            }
            case 3: {
                return this.isSetOptionalFlowFilter();
            }
            case 4: {
                return this.isSetOptionalOwnerFilters();
            }
            case 5: {
                return this.isSetOptionalOwnerNameFilter();
            }
            case 6: {
                return this.isSetNameUnion();
            }
            case 7: {
                return this.isSetOldestFirst();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (kind: ");
        if ((this.ALL_FLAGS & 1) != 0) {
            result.append((Object)this.kind);
        } else {
            result.append("<unset>");
        }
        result.append(", nameUnion: ");
        if ((this.ALL_FLAGS & 0x40) != 0) {
            result.append((this.ALL_FLAGS & 0x20) != 0);
        } else {
            result.append("<unset>");
        }
        result.append(", oldestFirst: ");
        if ((this.ALL_FLAGS & 0x100) != 0) {
            result.append((this.ALL_FLAGS & 0x80) != 0);
        } else {
            result.append("<unset>");
        }
        result.append(')');
        return result.toString();
    }

    @Override
    public List<IAuditableHandle> getFilterByOwnerOptional() {
        return this.getOptionalOwnerFilters();
    }

    @Override
    public IWorkspaceSearchCriteria setExactName(String namePattern) {
        NameFilter name = ScmDtoFactory.eINSTANCE.createNameFilter();
        name.setExact(true);
        name.setMatchPattern(namePattern);
        this.setOptionalNameFilter(name);
        return this;
    }

    @Override
    public IWorkspaceSearchCriteria setExactOwnerName(String namePattern) {
        NameFilter name = ScmDtoFactory.eINSTANCE.createNameFilter();
        name.setExact(true);
        name.setMatchPattern(namePattern);
        this.setOptionalOwnerNameFilter(name);
        return this;
    }

    @Override
    public IWorkspaceSearchCriteria setPartialOwnerName(String namePattern) {
        NameFilter name = ScmDtoFactory.eINSTANCE.createNameFilter();
        name.setExact(false);
        name.setMatchPattern(namePattern);
        this.setOptionalOwnerNameFilter(name);
        return this;
    }

    @Override
    public IWorkspaceSearchCriteria setFlowFilter(IWorkspaceHandle target, int flowType) {
        if (target == null) {
            throw new IllegalArgumentException();
        }
        if (!FlowFlags.isValid(flowType)) {
            throw new IllegalArgumentException();
        }
        FlowFilter newOptionalFlowFilter = ScmDtoFactory.eINSTANCE.createFlowFilter();
        newOptionalFlowFilter.setFlowKind(flowType);
        newOptionalFlowFilter.setTarget(target);
        this.setOptionalFlowFilter(newOptionalFlowFilter);
        return this;
    }

    @Override
    public IWorkspaceSearchCriteria setKind(int kind) {
        if (kind < 1 || kind > 3) {
            throw new IllegalArgumentException();
        }
        switch (kind) {
            case 3: {
                this.setKind(WorkspaceEnum.BOTH_LITERAL);
                break;
            }
            case 1: {
                this.setKind(WorkspaceEnum.STREAMS_LITERAL);
                break;
            }
            case 2: {
                this.setKind(WorkspaceEnum.WORKSPACES_LITERAL);
            }
        }
        return this;
    }

    @Override
    public IWorkspaceSearchCriteria setModifiedAfterOptional(Date d) {
        DateRange range = this.getOptionalDateRange();
        if (range == null) {
            range = ScmDtoFactory.eINSTANCE.createDateRange();
            this.setOptionalDateRange(range);
        }
        range.setStart(new Timestamp(d.getTime()));
        return this;
    }

    @Override
    public IWorkspaceSearchCriteria setModifiedBeforeOptional(Date d) {
        DateRange range = this.getOptionalDateRange();
        if (range == null) {
            range = ScmDtoFactory.eINSTANCE.createDateRange();
            this.setOptionalDateRange(range);
        }
        range.setEnd(new Timestamp(d.getTime()));
        return this;
    }

    @Override
    public IWorkspaceSearchCriteria setPartialName(String namePattern) {
        NameFilter name = ScmDtoFactory.eINSTANCE.createNameFilter();
        name.setExact(false);
        name.setMatchPattern(namePattern);
        this.setOptionalNameFilter(name);
        return this;
    }

    @Override
    public IWorkspaceSearchCriteria setPartialNameIgnoreCase(String namePattern) {
        NameFilter name = ScmDtoFactory.eINSTANCE.createNameFilter();
        name.setExact(false);
        name.setMatchPattern(namePattern);
        name.setIgnoreCase(true);
        this.setOptionalNameFilter(name);
        return this;
    }

    @Override
    public IWorkspaceSearchCriteria setPartialOwnerNameIgnoreCase(String namePattern) {
        NameFilter name = ScmDtoFactory.eINSTANCE.createNameFilter();
        name.setExact(false);
        name.setIgnoreCase(true);
        name.setMatchPattern(namePattern);
        this.setOptionalOwnerNameFilter(name);
        return this;
    }

    @Override
    public IWorkspaceSearchCriteria setRequireNameFilterUnion(boolean value) {
        this.setNameUnion(value);
        return this;
    }
}

