/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.process;

import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.internal.process.IFauxXmlNode;
import com.ibm.team.scm.common.internal.process.PCD_asObject;
import com.ibm.team.scm.common.internal.process.PCD_defaultValue;
import com.ibm.team.scm.common.internal.process.PCD_mayBeNull;
import com.ibm.team.scm.common.internal.process.PCD_serializationName;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ProcessConfigDeserializer {
    public <t> t deserialize(IFauxXmlNode node, Class<t> type) throws DeserializationException {
        return this.deserialize(new DeserializationInstruction(), node, type);
    }

    public <t> t deserialize(DeserializationInstruction inst, IFauxXmlNode node, Class<t> type) throws DeserializationException {
        t base;
        try {
            base = type.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new DeserializationException(e);
        }
        catch (InstantiationException e) {
            throw new DeserializationException(e);
        }
        this.deserializeInto(inst, node, base);
        return base;
    }

    public static String findSerializationNameFor(Field f) {
        PCD_serializationName anno = f.getAnnotation(PCD_serializationName.class);
        if (anno == null) {
            return f.getName();
        }
        return anno.value();
    }

    private void deserializeInto(DeserializationInstruction inst, IFauxXmlNode node, Object t) throws DeserializationException {
        Class<?> type = t.getClass();
        HashMap<String, List<IFauxXmlNode>> namedChildren = this.fetchNamedChildren(node);
        Field[] fieldArray = type.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                Object value;
                Field f;
                block7: {
                    List<IFauxXmlNode> nodes;
                    block8: {
                        String name;
                        block9: {
                            block6: {
                                PCD_defaultValue def;
                                List<IFauxXmlNode> list;
                                HashMap<String, List<IFauxXmlNode>> kiddies;
                                f = fieldArray[n2];
                                if (ProcessConfigDeserializer.shouldSkipSerialize(f)) break block5;
                                name = ProcessConfigDeserializer.findSerializationNameFor(f);
                                if (!ProcessConfigDeserializer.isAttributeType(f.getType())) break block6;
                                String attr = f.getAnnotation(PCD_asObject.class) == null ? node.getAttribute(name) : ((kiddies = this.fetchNamedChildren(node)).containsKey(name) ? ((list = kiddies.get(name)).size() >= 1 ? list.get(0).getAttribute("value") : null) : null);
                                value = attr == null && f.getAnnotation(PCD_mayBeNull.class) == null ? ((def = f.getAnnotation(PCD_defaultValue.class)) == null ? inst.handleMissingAttribute(node, f, t) : this.convert(f, def.value())) : this.convert(f, attr);
                                break block7;
                            }
                            nodes = namedChildren.get(name);
                            if (nodes != null) break block8;
                            if (!f.getType().isAssignableFrom(List.class)) break block9;
                            value = new ArrayList();
                            break block7;
                        }
                        if (f.getAnnotation(PCD_mayBeNull.class) == null) {
                            throw new DeserializationException("Missing field: " + name);
                        }
                        break block5;
                    }
                    value = this.convert(inst, f, nodes);
                }
                try {
                    f.set(t, value);
                }
                catch (IllegalArgumentException e) {
                    throw new DeserializationException(e);
                }
                catch (IllegalAccessException e) {
                    throw new DeserializationException(e);
                }
            }
            ++n2;
        }
    }

    public static boolean isAttributeType(Class<?> type) {
        return type == Boolean.TYPE || type == Integer.TYPE || type == Double.TYPE || type.isEnum() || type == UUID.class || type == String.class;
    }

    public static boolean shouldSkipSerialize(Field f) {
        int mods = f.getModifiers();
        return Modifier.isTransient(mods) || Modifier.isStatic(mods);
    }

    private HashMap<String, List<IFauxXmlNode>> fetchNamedChildren(IFauxXmlNode node) {
        HashMap<String, List<IFauxXmlNode>> kids = new HashMap<String, List<IFauxXmlNode>>();
        for (IFauxXmlNode child : node.getChildren()) {
            String name = child.getNodeName();
            List<IFauxXmlNode> nodes = kids.get(name);
            if (nodes == null) {
                nodes = new ArrayList<IFauxXmlNode>();
                kids.put(name, nodes);
            }
            nodes.add(child);
        }
        return kids;
    }

    private Object convert(DeserializationInstruction inst, Field f, List<IFauxXmlNode> nodes) throws DeserializationException {
        Object t;
        if (f.getType() == List.class) {
            ParameterizedType generic = (ParameterizedType)f.getGenericType();
            Type[] args = generic.getActualTypeArguments();
            if (args == null) {
                throw new DeserializationException("Lists must have a generic type. For " + f);
            }
            ArrayList<Object> toReturn = new ArrayList<Object>(nodes.size());
            Class type = (Class)args[0];
            if (ProcessConfigDeserializer.isAttributeType(type)) {
                for (IFauxXmlNode node : nodes) {
                    HashMap<String, List<IFauxXmlNode>> kids;
                    Object converted = f.getAnnotation(PCD_asObject.class) == null ? this.convert(f, node.getAttribute("value")) : ((kids = this.fetchNamedChildren(node)).containsKey("value") && kids.get("value").size() >= 1 ? kids.get("value").get(0).getAttribute("value") : null);
                    toReturn.add(converted);
                }
            } else {
                for (IFauxXmlNode node : nodes) {
                    Object item;
                    try {
                        item = type.newInstance();
                    }
                    catch (IllegalAccessException e) {
                        throw new DeserializationException(e);
                    }
                    catch (InstantiationException e) {
                        throw new DeserializationException(e);
                    }
                    this.deserializeInto(inst, node, item);
                    toReturn.add(item);
                }
            }
            return toReturn;
        }
        if (nodes.size() != 1) {
            throw new DeserializationException(String.valueOf(f.getName()) + "/" + ProcessConfigDeserializer.findSerializationNameFor(f));
        }
        try {
            t = f.getType().newInstance();
        }
        catch (IllegalAccessException e) {
            throw new DeserializationException(e);
        }
        catch (InstantiationException e) {
            throw new DeserializationException(e);
        }
        this.deserializeInto(inst, nodes.get(0), t);
        return t;
    }

    private Object convert(Field f, String attr) {
        if (f.getType() == Boolean.TYPE) {
            return Boolean.valueOf(attr);
        }
        if (f.getType() == Integer.TYPE) {
            return Integer.valueOf(attr);
        }
        if (f.getType() == Double.TYPE) {
            return Double.valueOf(attr);
        }
        if (f.getType().isEnum() && attr != null) {
            return Enum.valueOf(f.getType(), attr);
        }
        if (f.getType() == UUID.class) {
            return UUID.valueOf((String)attr);
        }
        return attr;
    }

    public static class DeserializationException
    extends Exception {
        public DeserializationException(Exception e) {
            super(e);
        }

        public DeserializationException(String msg) {
            super(msg);
        }
    }

    public static class DeserializationInstruction {
        public Object handleMissingAttribute(IFauxXmlNode xml, Field f, Object target) throws DeserializationException {
            if (f.getType().isAssignableFrom(Boolean.class) || f.getType().isAssignableFrom(Boolean.TYPE)) {
                return false;
            }
            if (f.getType().isAssignableFrom(Integer.class) || f.getType().isAssignableFrom(Integer.TYPE)) {
                return 0;
            }
            if (f.getType().isAssignableFrom(Double.class) || f.getType().isAssignableFrom(Double.TYPE)) {
                return 0.0;
            }
            if (f.getType().isEnum()) {
                return null;
            }
            if (f.getType().isAssignableFrom(UUID.class)) {
                return null;
            }
            if (f.getType().isAssignableFrom(String.class)) {
                return null;
            }
            throw new DeserializationException("Unknown field type for: " + f);
        }
    }
}

