/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.links.common.internal;

import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.ILinkHandle;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.internal.IBaseLinkService;
import com.ibm.team.links.common.internal.ReferenceUtils;
import com.ibm.team.links.common.internal.registry.LinkTypeRegistry;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.links.internal.links.AuditableLink;
import com.ibm.team.repository.common.IContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.validation.PropertyConstraintException;
import java.util.Collection;

public class AuditableLinkUtils {
    public static final AuditableLinkUtils INSTANCE = new AuditableLinkUtils();
    public static ReferenceUtils refUtils = ReferenceUtils.INSTANCE;

    public ILink createLink(String linkTypeId, IReference source, IReference target) throws IllegalArgumentException {
        AuditableLink result = (AuditableLink)ILink.ITEM_TYPE.createItem();
        result.setName(linkTypeId);
        result.setSourceRef(source.makeClone());
        result.setTargetRef(target.makeClone());
        result.setContextId(IContext.PUBLIC);
        return result;
    }

    public ILink createLink(String linkTypeId, IReference endPoint1, String endPoint2Id, IReference endPoint2) {
        ILinkType type = LinkTypeRegistry.INSTANCE.getLinkType(linkTypeId);
        if (type == null) {
            return this.createLink(linkTypeId, endPoint1, endPoint2);
        }
        if (endPoint2Id.equals(type.getTargetEndPointDescriptor().getId())) {
            return this.createLink(linkTypeId, endPoint1, endPoint2);
        }
        if (endPoint2Id.equals(type.getSourceEndPointDescriptor().getId())) {
            return this.createLink(linkTypeId, endPoint2, endPoint1);
        }
        String pattern = "Unknown endpoint id \"{0}\" for link type \"{1}\".";
        String message = NLS.bind(pattern, endPoint2Id, linkTypeId);
        throw new IllegalArgumentException(message);
    }

    public void saveLinks(Collection links, IBaseLinkService linkService) throws TeamRepositoryException {
        ILink[] links2 = ItemUtil.cast(links, ILink[].class);
        linkService.saveAuditableLinks(links2);
    }

    public void deleteLinks(Collection links, IBaseLinkService linkService) throws TeamRepositoryException {
        ILinkHandle[] handles = ItemUtil.cast(links, ILinkHandle[].class);
        linkService.deleteAuditableLinks(handles);
    }

    public void archiveLinks(Collection links, IBaseLinkService linkService) throws TeamRepositoryException {
        ILinkHandle[] handles = ItemUtil.cast(links, ILinkHandle[].class);
        linkService.archiveAuditableLinks(handles);
    }

    public void validateLink(ILink link, boolean requireRegisteredLinkType) throws TeamRepositoryException {
        try {
            AuditableLink auditableLink;
            String linkTypeId = link.getLinkTypeId();
            if (linkTypeId == null || linkTypeId.length() == 0) {
                throw new PropertyConstraintException("Link type is not set");
            }
            if (requireRegisteredLinkType && !LinkTypeRegistry.INSTANCE.isRegistered(linkTypeId)) {
                throw new PropertyConstraintException("Link type is not registered");
            }
            IReference source = link.getSourceRef();
            if (source == null) {
                throw new PropertyConstraintException("Source reference is not set");
            }
            ReferenceUtils.INSTANCE.checkValidity(source);
            IReference target = link.getTargetRef();
            if (target == null) {
                throw new PropertyConstraintException("Target reference is not set");
            }
            ReferenceUtils.INSTANCE.checkValidity(target);
            if (link.isWorkingCopy() && link instanceof AuditableLink && !(auditableLink = (AuditableLink)link).isSetArchived()) {
                auditableLink.setArchived(false);
            }
        }
        catch (RuntimeException ex) {
            TeamRepositoryException tre = new TeamRepositoryException(ex);
            tre.setData(link);
            throw tre;
        }
        catch (TeamRepositoryException ex) {
            ex.setData(link);
            throw ex;
        }
    }
}

