/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal;

import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.internal.util.ComponentRegistry;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.model.ItemType;
import com.ibm.team.repository.common.model.RepositoryPackage;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;

public class ItemTypeRegistry
implements IItemType.IRegistry {
    @Override
    public IItemType getItemType(String name, String modelUri) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (modelUri == null) {
            throw new IllegalArgumentException("modelUri must not be null");
        }
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(modelUri);
        if (ePackage == null) {
            return null;
        }
        EClassifier classifier = ePackage.getEClassifier(name);
        if (!(classifier instanceof EClass)) {
            return null;
        }
        EClass eClass = (EClass)classifier;
        RepositoryPackage repositoryPackage = RepositoryPackage.eINSTANCE;
        if (eClass == repositoryPackage.getAuditable() || eClass == repositoryPackage.getUnmanagedItem() || eClass == repositoryPackage.getSimpleItem() || !repositoryPackage.getItem().isSuperTypeOf(eClass)) {
            return null;
        }
        ItemType itemType = ItemUtil.itemTypeFor(eClass);
        return itemType;
    }

    @Override
    public IItemType[] getAllItemTypes() {
        return ComponentRegistry.INSTANCE.getAllItemTypes();
    }

    @Override
    public IItemType[] getLocalItemTypes() {
        return ComponentRegistry.INSTANCE.getLocalItemTypes();
    }

    @Override
    public IItemType[] getAllItemTypes(boolean includeAbstractTypes) {
        return ComponentRegistry.INSTANCE.getAllItemTypes(includeAbstractTypes);
    }
}

