/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.queryast.impl;

import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.queryast.AbstractQueryElement;
import com.ibm.team.repository.common.internal.queryast.AggregateFunction;
import com.ibm.team.repository.common.internal.queryast.AggregateFunctionType;
import com.ibm.team.repository.common.internal.queryast.AstQuery;
import com.ibm.team.repository.common.internal.queryast.BinaryOp;
import com.ibm.team.repository.common.internal.queryast.ElementType;
import com.ibm.team.repository.common.internal.queryast.FeaturePath;
import com.ibm.team.repository.common.internal.queryast.FilterElement;
import com.ibm.team.repository.common.internal.queryast.InList;
import com.ibm.team.repository.common.internal.queryast.InputArg;
import com.ibm.team.repository.common.internal.queryast.IsEmpty;
import com.ibm.team.repository.common.internal.queryast.IsNull;
import com.ibm.team.repository.common.internal.queryast.Literal;
import com.ibm.team.repository.common.internal.queryast.OrderBy;
import com.ibm.team.repository.common.internal.queryast.OrderByStateExtensions;
import com.ibm.team.repository.common.internal.queryast.Predicate;
import com.ibm.team.repository.common.internal.queryast.QueryastFactory;
import com.ibm.team.repository.common.internal.queryast.QueryastPackage;
import com.ibm.team.repository.common.internal.queryast.SelectionElement;
import com.ibm.team.repository.common.internal.queryast.impl.AbstractQueryElementImpl;
import com.ibm.team.repository.common.internal.queryast.impl.AstQueryStringTransform;
import com.ibm.team.repository.common.internal.queryast.impl.InputArgEntryImpl;
import com.ibm.team.repository.common.internal.util.EObjectUtil;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.model.Type;
import com.ibm.team.repository.common.query.IDataQuery;
import com.ibm.team.repository.common.query.IQuery;
import com.ibm.team.repository.common.query.ast.IAggregateFunction;
import com.ibm.team.repository.common.query.ast.IBoolean;
import com.ibm.team.repository.common.query.ast.IBooleanInputArg;
import com.ibm.team.repository.common.query.ast.IDateTime;
import com.ibm.team.repository.common.query.ast.IDateTimeInputArg;
import com.ibm.team.repository.common.query.ast.IEnumInputArg;
import com.ibm.team.repository.common.query.ast.IField;
import com.ibm.team.repository.common.query.ast.IInListValueSource;
import com.ibm.team.repository.common.query.ast.IInputArg;
import com.ibm.team.repository.common.query.ast.IItemHandleInputArg;
import com.ibm.team.repository.common.query.ast.IItemTypeInputArg;
import com.ibm.team.repository.common.query.ast.INumeric;
import com.ibm.team.repository.common.query.ast.INumericInputArg;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.ISelectionElement;
import com.ibm.team.repository.common.query.ast.IStateExtensions;
import com.ibm.team.repository.common.query.ast.IString;
import com.ibm.team.repository.common.query.ast.IStringField;
import com.ibm.team.repository.common.query.ast.IStringInputArg;
import com.ibm.team.repository.common.query.ast.IUUID;
import com.ibm.team.repository.common.query.ast.IUUIDInputArg;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.InternalEList;

public class AstQueryImpl
extends AbstractQueryElementImpl
implements AstQuery {
    static final String AST_QUERY_NOT_WELL_FORMED = "ast query not well formed\n {0}";
    protected EStructuralFeature targetFeature;
    protected static final boolean DISTINCT_EDEFAULT = false;
    protected boolean distinct = false;
    protected EList orderBys;
    protected EList groupBys;
    protected Predicate filter;
    protected EMap inputArgs;
    protected EList selectList;
    protected static final String ROOT_NS_URI_EDEFAULT = "";
    protected String rootNsURI = "";
    protected static final String ROOT_NAME_EDEFAULT = "";
    protected String rootName = "";
    protected FeaturePath targetPath;
    protected Predicate having;
    protected static final int RESULT_LIMIT_EDEFAULT = 0;
    protected int resultLimit = 0;
    protected static final int MAX_QUERY_TIME_EDEFAULT = -1;
    protected int maxQueryTime = -1;
    protected static final int REDACTION_RULE_VALUE_IMPL_EDEFAULT = 0;
    protected int redactionRuleValueImpl = 0;
    private int[] fReturnTypes;
    private List fDataFieldNames;
    private boolean queryAgainstAllConfigurations = false;
    public static final int USE_QUERY_SERVICE_RULES_VALUE = 0;
    public static final int REDACT_VALUE = 1;
    public static final int NO_REDACT_VALUE = 2;

    protected AstQueryImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return QueryastPackage.Literals.AST_QUERY;
    }

    @Override
    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public void setDistinct(boolean newDistinct) {
        boolean oldDistinct = this.distinct;
        this.distinct = newDistinct;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, oldDistinct, this.distinct));
        }
    }

    @Override
    public EList getOrderBys() {
        if (this.orderBys == null) {
            this.orderBys = new EObjectResolvingEList(OrderBy.class, (InternalEObject)this, 1);
        }
        return this.orderBys;
    }

    @Override
    public EList getGroupBys() {
        if (this.groupBys == null) {
            this.groupBys = new EObjectResolvingEList(FeaturePath.class, (InternalEObject)this, 2);
        }
        return this.groupBys;
    }

    @Override
    public Predicate getFilter() {
        if (this.filter != null && this.filter.eIsProxy()) {
            InternalEObject oldFilter = (InternalEObject)this.filter;
            this.filter = (Predicate)this.eResolveProxy(oldFilter);
            if (this.filter != oldFilter && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 3, (Object)oldFilter, (Object)this.filter));
            }
        }
        return this.filter;
    }

    public Predicate basicGetFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Predicate newFilter) {
        Predicate oldFilter = this.filter;
        this.filter = newFilter;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldFilter, (Object)this.filter));
        }
    }

    @Override
    public EMap getInputArgs() {
        if (this.inputArgs == null) {
            this.inputArgs = new EcoreEMap(QueryastPackage.Literals.INPUT_ARG_ENTRY, InputArgEntryImpl.class, (InternalEObject)this, 4);
        }
        return this.inputArgs;
    }

    @Override
    public EList getSelectList() {
        if (this.selectList == null) {
            this.selectList = new EObjectResolvingEList(SelectionElement.class, (InternalEObject)this, 5);
        }
        return this.selectList;
    }

    @Override
    public String getRootNsURI() {
        return this.rootNsURI;
    }

    @Override
    public void setRootNsURI(String newRootNsURI) {
        String oldRootNsURI = this.rootNsURI;
        this.rootNsURI = newRootNsURI;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldRootNsURI, (Object)this.rootNsURI));
        }
    }

    @Override
    public String getRootName() {
        return this.rootName;
    }

    @Override
    public void setRootName(String newRootName) {
        String oldRootName = this.rootName;
        this.rootName = newRootName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldRootName, (Object)this.rootName));
        }
    }

    @Override
    public FeaturePath getTargetPath() {
        if (this.targetPath != null && this.targetPath.eIsProxy()) {
            InternalEObject oldTargetPath = (InternalEObject)this.targetPath;
            this.targetPath = (FeaturePath)this.eResolveProxy(oldTargetPath);
            if (this.targetPath != oldTargetPath && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 8, (Object)oldTargetPath, (Object)this.targetPath));
            }
        }
        return this.targetPath;
    }

    public FeaturePath basicGetTargetPath() {
        return this.targetPath;
    }

    @Override
    public void setTargetPath(FeaturePath newTargetPath) {
        FeaturePath oldTargetPath = this.targetPath;
        this.targetPath = newTargetPath;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldTargetPath, (Object)this.targetPath));
        }
    }

    @Override
    public Predicate getHaving() {
        if (this.having != null && this.having.eIsProxy()) {
            InternalEObject oldHaving = (InternalEObject)this.having;
            this.having = (Predicate)this.eResolveProxy(oldHaving);
            if (this.having != oldHaving && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 9, (Object)oldHaving, (Object)this.having));
            }
        }
        return this.having;
    }

    public Predicate basicGetHaving() {
        return this.having;
    }

    @Override
    public void setHaving(Predicate newHaving) {
        Predicate oldHaving = this.having;
        this.having = newHaving;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldHaving, (Object)this.having));
        }
    }

    @Override
    public int getResultLimit() {
        return this.resultLimit;
    }

    @Override
    public void setResultLimit(int newResultLimit) {
        if (newResultLimit < 0) {
            String msg = NLS.bind("Result limit ({0}) must not be negative", newResultLimit, new Object[0]);
            throw new IllegalArgumentException(msg);
        }
        this.setResultLimitGen(newResultLimit);
    }

    public void setResultLimitGen(int newResultLimit) {
        int oldResultLimit = this.resultLimit;
        this.resultLimit = newResultLimit;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, oldResultLimit, this.resultLimit));
        }
    }

    @Override
    public int getMaxQueryTime() {
        return this.maxQueryTime;
    }

    @Override
    public void setMaxQueryTime(int newMaxQueryTime) {
        int oldMaxQueryTime = this.maxQueryTime;
        this.maxQueryTime = newMaxQueryTime;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, oldMaxQueryTime, this.maxQueryTime));
        }
    }

    @Override
    public int getRedactionRuleValueImpl() {
        return this.redactionRuleValueImpl;
    }

    @Override
    public void setRedactionRuleValueImpl(int newRedactionRuleValueImpl) {
        int oldRedactionRuleValueImpl = this.redactionRuleValueImpl;
        this.redactionRuleValueImpl = newRedactionRuleValueImpl;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, oldRedactionRuleValueImpl, this.redactionRuleValueImpl));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 4: {
                return ((InternalEList)this.getInputArgs()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public AstQuery select(ISelectionElement selectionElement) {
        this.getSelectList().add((Object)this.createSelectionElement(selectionElement));
        return this;
    }

    @Override
    public AstQuery select(ISelectionElement selectionElement1, ISelectionElement selectionElement2) {
        this.getSelectList().add((Object)this.createSelectionElement(selectionElement1));
        this.getSelectList().add((Object)this.createSelectionElement(selectionElement2));
        return this;
    }

    @Override
    public AstQuery select(ISelectionElement selectionElement1, ISelectionElement selectionElement2, ISelectionElement selectionElement3) {
        this.getSelectList().add((Object)this.createSelectionElement(selectionElement1));
        this.getSelectList().add((Object)this.createSelectionElement(selectionElement2));
        this.getSelectList().add((Object)this.createSelectionElement(selectionElement3));
        return this;
    }

    @Override
    public AstQuery select(ISelectionElement[] selectionElementArray) {
        int i = 0;
        while (i < selectionElementArray.length) {
            this.getSelectList().add((Object)this.createSelectionElement(selectionElementArray[i]));
            ++i;
        }
        return this;
    }

    private SelectionElement createSelectionElement(ISelectionElement selectionElement) {
        if (selectionElement instanceof IField) {
            IField field = (IField)selectionElement;
            FeaturePath featurePath = QueryastFactory.eINSTANCE.createFeaturePath(field);
            if (field.isRedactable()) {
                featurePath.setRedactable(true);
                featurePath.setRedactionLiteral(field.redactionLiteral());
            }
            return featurePath;
        }
        return (SelectionElement)selectionElement;
    }

    @Override
    public IAggregateFunction count() {
        return QueryastFactory.eINSTANCE.createCount();
    }

    @Override
    public IAggregateFunction count(IField field) {
        FeaturePath astField = QueryastFactory.eINSTANCE.createFeaturePath(field);
        return QueryastFactory.eINSTANCE.createCount(astField);
    }

    @Override
    public IAggregateFunction countDistinct(IField field) {
        FeaturePath astField = QueryastFactory.eINSTANCE.createFeaturePath(field);
        return QueryastFactory.eINSTANCE.createCountDistinct(astField, true);
    }

    @Override
    public IAggregateFunction max(IField field) {
        return this.createAggregationFunction(field, AggregateFunctionType.MAX_LITERAL);
    }

    @Override
    public IAggregateFunction min(IField field) {
        return this.createAggregationFunction(field, AggregateFunctionType.MIN_LITERAL);
    }

    @Override
    public IAggregateFunction sum(IField field) {
        return this.createAggregationFunction(field, AggregateFunctionType.SUM_LITERAL);
    }

    @Override
    public IAggregateFunction avg(IField field) {
        return this.createAggregationFunction(field, AggregateFunctionType.AVG_LITERAL);
    }

    private IAggregateFunction createAggregationFunction(IField field, AggregateFunctionType functionType) {
        AggregateFunction aggregateFunction = QueryastFactory.eINSTANCE.createAggregateFunction(functionType);
        aggregateFunction.setDistinct(false);
        FeaturePath astField = QueryastFactory.eINSTANCE.createFeaturePath(field);
        aggregateFunction.setField(astField);
        return aggregateFunction;
    }

    @Override
    public IPredicate and(IPredicate lhs, IPredicate rhs) {
        return QueryastFactory.eINSTANCE.createBinaryConditionalExpression((Predicate)lhs, BinaryOp.AND_LITERAL, (Predicate)rhs);
    }

    @Override
    public IPredicate or(IPredicate lhs, IPredicate rhs) {
        return QueryastFactory.eINSTANCE.createBinaryConditionalExpression((Predicate)lhs, BinaryOp.OR_LITERAL, (Predicate)rhs);
    }

    @Override
    public IPredicate not(IPredicate predicate) {
        return QueryastFactory.eINSTANCE.createNot((Predicate)predicate);
    }

    @Override
    public AstQuery orderByAsc(IField field) {
        OrderBy orderBy = this.createOrderBy(field, true, false);
        this.getOrderBys().add((Object)orderBy);
        return this;
    }

    @Override
    public AstQuery orderByAscUsingLocale(IStringField field) {
        OrderBy orderBy = this.createOrderBy(field, true, true);
        this.getOrderBys().add((Object)orderBy);
        return this;
    }

    @Override
    public AstQuery orderByDsc(IField field) {
        OrderBy orderBy = this.createOrderBy(field, false, false);
        this.getOrderBys().add((Object)orderBy);
        return this;
    }

    @Override
    public AstQuery orderByDscUsingLocale(IStringField field) {
        OrderBy orderBy = this.createOrderBy(field, false, true);
        this.getOrderBys().add((Object)orderBy);
        return this;
    }

    private OrderBy createOrderBy(IField field, boolean asc, boolean useLocale) {
        OrderBy orderBy = QueryastFactory.eINSTANCE.createOrderBy();
        orderBy.setAsc(asc);
        orderBy.setUseLocale(useLocale);
        FeaturePath astField = QueryastFactory.eINSTANCE.createFeaturePath(field);
        orderBy.setField(astField);
        return orderBy;
    }

    private OrderByStateExtensions createOrderByStateExtensions(IStateExtensions field, FilterElement key, boolean asc, boolean useLocale) {
        OrderByStateExtensions orderBy = QueryastFactory.eINSTANCE.createOrderByStateExtensions();
        orderBy.setAsc(asc);
        orderBy.setUseLocale(useLocale);
        FeaturePath astField = QueryastFactory.eINSTANCE.createFeaturePath(field);
        orderBy.setField(astField);
        orderBy.setKey(key);
        return orderBy;
    }

    @Override
    public AstQuery groupBy(IField field) {
        FeaturePath astField = QueryastFactory.eINSTANCE.createFeaturePath(field);
        this.getGroupBys().add((Object)astField);
        return this;
    }

    @Override
    public IStringInputArg newStringArg() {
        return this.newInputArg(ElementType.STRING_LITERAL);
    }

    @Override
    public INumericInputArg newIntegerArg() {
        return this.newInputArg(ElementType.INT_LITERAL);
    }

    @Override
    public INumericInputArg newLongArg() {
        return this.newInputArg(ElementType.LONG_LITERAL);
    }

    @Override
    public INumericInputArg newBigDecimalArg() {
        return this.newInputArg(ElementType.BIG_DECIMAL_LITERAL);
    }

    @Override
    public IDateTimeInputArg newDateTimeArg() {
        return this.newInputArg(ElementType.DATE_TIME_LITERAL);
    }

    @Override
    public IUUIDInputArg newUUIDArg() {
        return this.newInputArg(ElementType.UUID_LITERAL);
    }

    @Override
    public IEnumInputArg newEnumArg() {
        return this.newInputArg(ElementType.ENUM_LITERAL);
    }

    @Override
    public IBooleanInputArg newBooleanArg() {
        return this.newInputArg(ElementType.BOOLEAN_LITERAL);
    }

    @Override
    public IItemHandleInputArg newItemHandleArg() {
        return this.newInputArg(ElementType.ITEM_HANDLE_LITERAL);
    }

    @Override
    public IItemTypeInputArg newItemTypeArg() {
        return this.newInputArg(ElementType.ITEM_TYPE_LITERAL);
    }

    private InputArg newInputArg(ElementType elementType) {
        InputArg inputArg = this.createInputArg(elementType);
        this.getInputArgs().put((Object)String.valueOf(inputArg.getNum()), (Object)inputArg);
        return inputArg;
    }

    private InputArg createInputArg(ElementType elementType) {
        InputArg inputArg = QueryastFactory.eINSTANCE.createInputArg();
        inputArg.setKind(elementType);
        inputArg.setNum(this.getInputArgs().size() + 1);
        return inputArg;
    }

    public IInputArg arg(int i) {
        String key = String.valueOf(i);
        return (InputArg)this.getInputArgs().get((Object)key);
    }

    public IInputArg arg(String aName) {
        return (InputArg)this.getInputArgs().get((Object)aName);
    }

    public IUUID newUUIDLiteral(UUID uuid) {
        return QueryastFactory.eINSTANCE.createUUIDLiteral(uuid);
    }

    public IString newStringLiteral(String string) {
        return QueryastFactory.eINSTANCE.createStringLiteral(string);
    }

    public INumeric newNumericLiteral(Number number) {
        return QueryastFactory.eINSTANCE.createNumericLiteral(number);
    }

    public IDateTime newDateTimeLiteral(Date date) {
        return QueryastFactory.eINSTANCE.createDateTimeLiteral(date);
    }

    public IBoolean newBooleanLiteral(Boolean bool) {
        return QueryastFactory.eINSTANCE.createBooleanLiteral(bool);
    }

    public IBoolean newItemTypeLiteral(IItemType itemType) {
        return QueryastFactory.eINSTANCE.createItemTypeLiteral(itemType);
    }

    @Override
    public IQuery filter(IPredicate p) {
        Predicate predicate = (Predicate)p;
        this.setFilter(predicate);
        return this;
    }

    @Override
    public IQuery having(IPredicate p) {
        Predicate predicate = (Predicate)p;
        this.setHaving(predicate);
        return this;
    }

    @Override
    public IQuery distinct() {
        this.setDistinct(true);
        return this;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.isDistinct() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 1: {
                return this.getOrderBys();
            }
            case 2: {
                return this.getGroupBys();
            }
            case 3: {
                if (resolve) {
                    return this.getFilter();
                }
                return this.basicGetFilter();
            }
            case 4: {
                if (coreType) {
                    return this.getInputArgs();
                }
                return this.getInputArgs().map();
            }
            case 5: {
                return this.getSelectList();
            }
            case 6: {
                return this.getRootNsURI();
            }
            case 7: {
                return this.getRootName();
            }
            case 8: {
                if (resolve) {
                    return this.getTargetPath();
                }
                return this.basicGetTargetPath();
            }
            case 9: {
                if (resolve) {
                    return this.getHaving();
                }
                return this.basicGetHaving();
            }
            case 10: {
                return new Integer(this.getResultLimit());
            }
            case 11: {
                return new Integer(this.getMaxQueryTime());
            }
            case 12: {
                return new Integer(this.getRedactionRuleValueImpl());
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setDistinct((Boolean)newValue);
                return;
            }
            case 1: {
                this.getOrderBys().clear();
                this.getOrderBys().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getGroupBys().clear();
                this.getGroupBys().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.setFilter((Predicate)newValue);
                return;
            }
            case 4: {
                ((EStructuralFeature.Setting)this.getInputArgs()).set(newValue);
                return;
            }
            case 5: {
                this.getSelectList().clear();
                this.getSelectList().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.setRootNsURI((String)newValue);
                return;
            }
            case 7: {
                this.setRootName((String)newValue);
                return;
            }
            case 8: {
                this.setTargetPath((FeaturePath)newValue);
                return;
            }
            case 9: {
                this.setHaving((Predicate)newValue);
                return;
            }
            case 10: {
                this.setResultLimit((Integer)newValue);
                return;
            }
            case 11: {
                this.setMaxQueryTime((Integer)newValue);
                return;
            }
            case 12: {
                this.setRedactionRuleValueImpl((Integer)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setDistinct(false);
                return;
            }
            case 1: {
                this.getOrderBys().clear();
                return;
            }
            case 2: {
                this.getGroupBys().clear();
                return;
            }
            case 3: {
                this.setFilter(null);
                return;
            }
            case 4: {
                this.getInputArgs().clear();
                return;
            }
            case 5: {
                this.getSelectList().clear();
                return;
            }
            case 6: {
                this.setRootNsURI("");
                return;
            }
            case 7: {
                this.setRootName("");
                return;
            }
            case 8: {
                this.setTargetPath(null);
                return;
            }
            case 9: {
                this.setHaving(null);
                return;
            }
            case 10: {
                this.setResultLimit(0);
                return;
            }
            case 11: {
                this.setMaxQueryTime(-1);
                return;
            }
            case 12: {
                this.setRedactionRuleValueImpl(0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.distinct;
            }
            case 1: {
                return this.orderBys != null && !this.orderBys.isEmpty();
            }
            case 2: {
                return this.groupBys != null && !this.groupBys.isEmpty();
            }
            case 3: {
                return this.filter != null;
            }
            case 4: {
                return this.inputArgs != null && !this.inputArgs.isEmpty();
            }
            case 5: {
                return this.selectList != null && !this.selectList.isEmpty();
            }
            case 6: {
                return "" == null ? this.rootNsURI != null : !"".equals(this.rootNsURI);
            }
            case 7: {
                return "" == null ? this.rootName != null : !"".equals(this.rootName);
            }
            case 8: {
                return this.targetPath != null;
            }
            case 9: {
                return this.having != null;
            }
            case 10: {
                return this.resultLimit != 0;
            }
            case 11: {
                return this.maxQueryTime != -1;
            }
            case 12: {
                return this.redactionRuleValueImpl != 0;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (distinct: ");
        result.append(this.distinct);
        result.append(", rootNsURI: ");
        result.append(this.rootNsURI);
        result.append(", rootName: ");
        result.append(this.rootName);
        result.append(", resultLimit: ");
        result.append(this.resultLimit);
        result.append(", maxQueryTime: ");
        result.append(this.maxQueryTime);
        result.append(", redactionRuleValueImpl: ");
        result.append(this.redactionRuleValueImpl);
        result.append(')');
        return result.toString();
    }

    @Override
    public IItemType getRootItemType() {
        if (this.getRootName() == null || this.getRootNsURI() == null) {
            throw new IllegalStateException("Query must have a root type name and namespace URI");
        }
        IItemType aType = IItemType.IRegistry.INSTANCE.getItemType(this.getRootName(), this.getRootNsURI());
        if (aType == null) {
            String msg = NLS.bind("Unable to find type for {0}.{1}", this.getRootNsURI(), this.getRootName());
            throw new IllegalStateException(msg);
        }
        return aType;
    }

    @Override
    public boolean isRootItemTypeConfigurationAware() {
        return this.getRootItemType().isConfigurationAware();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EStructuralFeature getTargetFeature() {
        if (this.targetPath == null) {
            return null;
        }
        AstQueryImpl astQueryImpl = this;
        synchronized (astQueryImpl) {
            if (this.targetFeature == null) {
                StringTokenizer tok = new StringTokenizer(this.targetPath.getPath(), ".");
                EClass eClass = ItemUtil.getTypeEClass((Type)((Object)this.getRootItemType()));
                EStructuralFeature result = null;
                while (tok.hasMoreElements()) {
                    result = eClass.getEStructuralFeature(tok.nextToken());
                    if (!ItemUtil.isHandle(eClass = ItemUtil.getTargetClassIfFacade((EReference)result))) continue;
                    eClass = ItemUtil.getItemEClass(eClass);
                }
                this.targetFeature = result;
            }
            return this.targetFeature;
        }
    }

    @Override
    public IItemType getReturnItemType() {
        if (this.getTargetFeature() == null) {
            return this.getRootItemType();
        }
        EClass eClass = ItemUtil.resolveReferenceTypeCompletely((EReference)this.getTargetFeature());
        return ItemUtil.itemTypeFor(eClass);
    }

    @Override
    public EClass getRootEClass() {
        return ItemUtil.getTypeEClass((Type)((Object)this.getRootItemType()));
    }

    @Override
    public int[] getParameterTypes() {
        EMap inputArguments = this.getInputArgs();
        if (inputArguments.size() == 0) {
            return new int[0];
        }
        int[] parameterTypes = new int[inputArguments.size()];
        for (Object object : inputArguments.values()) {
            InputArg inputArg = (InputArg)object;
            parameterTypes[inputArg.getNum() - 1] = this.getQueryDataType(inputArg.getKind());
        }
        return parameterTypes;
    }

    private int getQueryDataType(ElementType elementType) {
        switch (elementType.getValue()) {
            case 0: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 1: {
                return 3;
            }
            case 3: {
                return 0;
            }
            case 6: {
                return 5;
            }
            case 2: {
                return 0;
            }
            case 5: {
                return 6;
            }
            case 7: {
                return 1;
            }
            case 10: {
                return 0;
            }
            case 9: {
                return 4;
            }
        }
        return 2;
    }

    @Override
    public String getQueryString() {
        StringBuffer b = new StringBuffer();
        b.append(this.getClass().getSimpleName()).append("(").append(this.toJavaString()).append(")");
        return b.toString();
    }

    @Override
    public int[] getReturnTypes() {
        return this.fReturnTypes;
    }

    @Override
    public void setReturnTypes(int[] types) {
        this.fReturnTypes = types;
    }

    @Override
    public IItemType getReturnType() {
        return this.getReturnItemType();
    }

    @Override
    public void allPathsOn(List l, boolean forURIAttribute) {
        Iterator it = this.getSelectList().iterator();
        while (it.hasNext()) {
            ((AbstractQueryElement)it.next()).allPathsOn(l, forURIAttribute);
        }
        if (this.getFilter() != null) {
            this.getFilter().allPathsOn(l, forURIAttribute);
        }
        it = this.getGroupBys().iterator();
        while (it.hasNext()) {
            ((AbstractQueryElement)it.next()).allPathsOn(l, forURIAttribute);
        }
        it = this.getOrderBys().iterator();
        while (it.hasNext()) {
            ((AbstractQueryElement)it.next()).allPathsOn(l, forURIAttribute);
        }
        if (this.getTargetPath() != null) {
            this.getTargetPath().allPathsOn(l, forURIAttribute);
        }
    }

    @Override
    public List getDataFieldNames() {
        if (this.fDataFieldNames == null) {
            this.fDataFieldNames = this.defaultDataFieldNames();
        }
        return this.fDataFieldNames;
    }

    private List defaultDataFieldNames() {
        ArrayList<String> aList = new ArrayList<String>();
        if (this.getSelectList().isEmpty()) {
            aList.add("itemId");
            aList.add("stateId");
            if (this.getReturnTypes().length == 3) {
                aList.add("discriminator");
            }
            return aList;
        }
        for (SelectionElement each : this.getSelectList()) {
            aList.add(each.toSelectionNameString());
        }
        return aList;
    }

    @Override
    public boolean isOnlyInIsEmptyPredicate(String aPath) {
        Iterator it;
        List<Predicate> l = this.allPredicates();
        if (l.isEmpty()) {
            return false;
        }
        if (this.getTargetPath() != null && this.getTargetPath().getPath().equals(aPath)) {
            return false;
        }
        if (!this.getSelectList().isEmpty()) {
            it = this.getSelectList().iterator();
            while (it.hasNext()) {
                if (!((AbstractQueryElement)it.next()).isReferingToPath(aPath)) continue;
                return false;
            }
        }
        it = l.iterator();
        ArrayList<Predicate> preds = new ArrayList<Predicate>();
        while (it.hasNext()) {
            Predicate each = (Predicate)it.next();
            if (!each.isReferingToPath(aPath)) continue;
            preds.add(each);
        }
        it = preds.iterator();
        while (it.hasNext()) {
            if (it.next() instanceof IsEmpty) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isReferingToPath(String p) {
        Iterator it = this.getSelectList().iterator();
        while (it.hasNext()) {
            if (!((AbstractQueryElement)it.next()).isReferingToPath(p)) continue;
            return true;
        }
        if (this.getFilter() != null && this.getFilter().isReferingToPath(p)) {
            return true;
        }
        it = this.getGroupBys().iterator();
        while (it.hasNext()) {
            if (!((AbstractQueryElement)it.next()).isReferingToPath(p)) continue;
            return true;
        }
        it = this.getOrderBys().iterator();
        while (it.hasNext()) {
            if (!((AbstractQueryElement)it.next()).isReferingToPath(p)) continue;
            return true;
        }
        return this.getTargetPath() != null && this.getTargetPath().isReferingToPath(p);
    }

    @Override
    public boolean isOnlyInStateExtensionPredicates(String aPath) {
        Iterator it;
        List<Predicate> l = this.allPredicates();
        if (l.isEmpty()) {
            return false;
        }
        if (this.getTargetPath() != null && this.getTargetPath().getPath().equals(aPath)) {
            return false;
        }
        if (!this.getSelectList().isEmpty()) {
            it = this.getSelectList().iterator();
            while (it.hasNext()) {
                if (!((AbstractQueryElement)it.next()).isReferingToPath(aPath)) continue;
                return false;
            }
        }
        it = l.iterator();
        ArrayList<Predicate> preds = new ArrayList<Predicate>();
        while (it.hasNext()) {
            Predicate each = (Predicate)it.next();
            if (!each.isReferingToPath(aPath)) continue;
            preds.add(each);
        }
        for (Predicate eachPred : preds) {
            if (eachPred.isStateExtensionPredicate()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAbsentOrOnlyInIsNullOrIsEmptyPredicate(String aPath) {
        List<Predicate> predicates = this.allPredicates();
        for (Predicate predicate : predicates) {
            if (predicate instanceof IsNull || predicate instanceof IsEmpty) continue;
            List<FeaturePath> featurePaths = predicate.allImmediateFeaturePathChildren();
            Iterator iterator = featurePaths.iterator();
            while (iterator.hasNext()) {
                FeaturePath featurePath = (FeaturePath)iterator.next();
                if (!featurePath.getPath().startsWith(aPath)) continue;
                return false;
            }
        }
        EList selects = this.getSelectList();
        for (AbstractQueryElement select : selects) {
            if (!select.isReferingToPath(aPath)) continue;
            return false;
        }
        EList orderByList = this.getOrderBys();
        for (AbstractQueryElement orderBy : orderByList) {
            if (!orderBy.isReferingToPath(aPath)) continue;
            return false;
        }
        return true;
    }

    public void allPredicatesOn(List<Predicate> l) {
        if (this.getFilter() != null) {
            this.getFilter().allPredicatesOn(l);
        }
    }

    @Override
    public List<Predicate> allPredicates() {
        ArrayList<Predicate> l = new ArrayList<Predicate>();
        this.allPredicatesOn(l);
        return l;
    }

    @Override
    public boolean isSameQuery(IQuery query) {
        if (!(query instanceof AstQuery)) {
            return false;
        }
        AstQuery astQuery = (AstQuery)query;
        return EObjectUtil.areEqual(this, astQuery, true);
    }

    @Override
    public String toJavaString() {
        return new AstQueryStringTransform(this).toJavaString();
    }

    @Override
    public String toDynamicJavaString() {
        return new AstQueryStringTransform(this).toDynamicJavaString();
    }

    @Override
    public void isWellFormedCheck() throws TeamRepositoryException {
        if (!this.isWellFormed()) {
            throw new TeamRepositoryException(NLS.bind(AST_QUERY_NOT_WELL_FORMED, this.toJavaString(), new Object[0]));
        }
    }

    public boolean isWellFormed() {
        if (this.getRootItemType() == null) {
            return false;
        }
        Iterator it = this.getSelectList().iterator();
        while (it.hasNext()) {
            if (((SelectionElement)it.next()).isWellFormed()) continue;
            return false;
        }
        if (this.getFilter() != null && !this.getFilter().isWellFormed()) {
            return false;
        }
        if (!this.areOrderBysWellFormed()) {
            return false;
        }
        it = this.getGroupBys().iterator();
        while (it.hasNext()) {
            if (((SelectionElement)it.next()).isWellFormed()) continue;
            return false;
        }
        return this.getHaving() == null || this.getHaving().isWellFormed();
    }

    private int countOrderBy(OrderBy anOrderBy) {
        Iterator it = this.getOrderBys().iterator();
        int n = 0;
        while (it.hasNext()) {
            if (!((OrderBy)it.next()).isSameAs(anOrderBy)) continue;
            ++n;
        }
        return n;
    }

    private boolean areOrderBysWellFormed() {
        for (OrderBy each : this.getOrderBys()) {
            if (this.countOrderBy(each) > 1) {
                return false;
            }
            if (each.isWellFormed()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<IItemType> getQueriedItemTypes() {
        HashSet<IItemType> results = new HashSet<IItemType>();
        results.add(this.getRootItemType());
        TreeIterator iterator = this.eAllContents();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof FeaturePath)) continue;
            FeaturePath featurePath = (FeaturePath)object;
            List<IItemType> types = featurePath.getAllItemTypes();
            results.addAll(types);
        }
        return results;
    }

    @Override
    public List<IInListValueSource> allInListsWithValueSources() {
        ArrayList<IInListValueSource> aList = new ArrayList<IInListValueSource>();
        if (this.getFilter() == null) {
            return aList;
        }
        for (Predicate each : this.allPredicates()) {
            if (!(each instanceof InList) || ((InList)each).getInputValueSource() == null) continue;
            aList.add((IInListValueSource)((Object)each));
        }
        return aList;
    }

    @Override
    public boolean requiresWriteCapability() {
        return !this.allInListsWithValueSources().isEmpty();
    }

    @Override
    public AstQuery orderByAsc(IStateExtensions ext, String key) {
        Literal keyLiteral = QueryastFactory.eINSTANCE.createStringLiteral(key);
        OrderByStateExtensions anOrderBy = this.createOrderByStateExtensions(ext, keyLiteral, true, false);
        this.getOrderBys().add((Object)anOrderBy);
        return this;
    }

    @Override
    public AstQuery orderByAsc(IStateExtensions ext, IString key) {
        FilterElement keyLiteral = QueryastFactory.eINSTANCE.createFilterElement(key);
        OrderByStateExtensions anOrderBy = this.createOrderByStateExtensions(ext, keyLiteral, true, false);
        this.getOrderBys().add((Object)anOrderBy);
        return this;
    }

    @Override
    public AstQuery orderByAscUsingLocale(IStateExtensions ext, String key) {
        Literal keyLiteral = QueryastFactory.eINSTANCE.createStringLiteral(key);
        OrderByStateExtensions anOrderBy = this.createOrderByStateExtensions(ext, keyLiteral, true, true);
        this.getOrderBys().add((Object)anOrderBy);
        return this;
    }

    @Override
    public AstQuery orderByAscUsingLocale(IStateExtensions ext, IString key) {
        FilterElement keyLiteral = QueryastFactory.eINSTANCE.createFilterElement(key);
        OrderByStateExtensions anOrderBy = this.createOrderByStateExtensions(ext, keyLiteral, true, true);
        this.getOrderBys().add((Object)anOrderBy);
        return this;
    }

    @Override
    public AstQuery orderByDsc(IStateExtensions ext, String key) {
        Literal keyLiteral = QueryastFactory.eINSTANCE.createStringLiteral(key);
        OrderByStateExtensions anOrderBy = this.createOrderByStateExtensions(ext, keyLiteral, false, false);
        this.getOrderBys().add((Object)anOrderBy);
        return this;
    }

    @Override
    public AstQuery orderByDsc(IStateExtensions ext, IString key) {
        FilterElement keyLiteral = QueryastFactory.eINSTANCE.createFilterElement(key);
        OrderByStateExtensions anOrderBy = this.createOrderByStateExtensions(ext, keyLiteral, false, false);
        this.getOrderBys().add((Object)anOrderBy);
        return this;
    }

    @Override
    public AstQuery orderByDscUsingLocale(IStateExtensions ext, String key) {
        Literal keyLiteral = QueryastFactory.eINSTANCE.createStringLiteral(key);
        OrderByStateExtensions anOrderBy = this.createOrderByStateExtensions(ext, keyLiteral, false, true);
        this.getOrderBys().add((Object)anOrderBy);
        return this;
    }

    @Override
    public AstQuery orderByDscUsingLocale(IStateExtensions ext, IString key) {
        FilterElement keyLiteral = QueryastFactory.eINSTANCE.createFilterElement(key);
        OrderByStateExtensions anOrderBy = this.createOrderByStateExtensions(ext, keyLiteral, false, true);
        this.getOrderBys().add((Object)anOrderBy);
        return this;
    }

    public List getStateExtensionOrderBys() {
        ArrayList sublist = new ArrayList();
        for (Object each : this.getOrderBys()) {
            if (!(each instanceof OrderByStateExtensions)) continue;
            sublist.add(each);
        }
        return sublist;
    }

    @Override
    public boolean isPathUsedInOrderBy(String path) {
        ArrayList allPaths = new ArrayList();
        for (AbstractQueryElement orderBy : this.orderBys) {
            if (orderBy instanceof OrderByStateExtensions) continue;
            orderBy.allPathsOn(allPaths, false);
        }
        return allPaths.contains(path);
    }

    @Override
    public IDataQuery.RedactionRule getRedactionRule() {
        IDataQuery.RedactionRule redactionRule = IDataQuery.RedactionRule.USE_QUERY_SERVICE_RULES;
        switch (this.getRedactionRuleValueImpl()) {
            case 1: {
                redactionRule = IDataQuery.RedactionRule.REDACT;
                break;
            }
            case 2: {
                redactionRule = IDataQuery.RedactionRule.NO_REDACT;
                break;
            }
            default: {
                redactionRule = IDataQuery.RedactionRule.USE_QUERY_SERVICE_RULES;
            }
        }
        return redactionRule;
    }

    @Override
    public void setRedactionRule(IDataQuery.RedactionRule aRule) {
        this.setRedactionRuleValueImpl(aRule.getValue());
    }

    @Override
    public boolean getQueryAgainstAllStreams() {
        return this.queryAgainstAllConfigurations;
    }

    @Override
    public void setQueryAgainstAllStreams(boolean value) {
        this.queryAgainstAllConfigurations = value;
    }
}

