/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.transport;

import com.ibm.team.repository.common.internal.util.ComponentConfigurationRegistry;
import com.ibm.team.repository.common.internal.util.ComponentRegistry;
import com.ibm.team.repository.common.transport.ComponentConfiguration;
import com.ibm.team.repository.common.transport.ITeamServer;
import com.ibm.team.repository.common.transport.ITeamService;
import com.ibm.team.repository.common.transport.TeamServerConfiguration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractTeamServer
implements ITeamServer {
    private final Map<Class, ITeamService> teamServices = new HashMap<Class, ITeamService>(101);
    private String userid;
    private String password;
    private TeamServerConfiguration configuration;
    private String repoURL;
    protected boolean loadSessionState = false;

    protected AbstractTeamServer(String url) {
        this.repoURL = url;
        this.configuration = new TeamServerConfiguration();
    }

    @Override
    public void setCredentials(String userid, String password) {
        this.userid = userid;
        this.password = password;
    }

    @Override
    public void setLoadSessionState(boolean loadState) {
        this.loadSessionState = loadState;
    }

    @Override
    public final String getUserid() {
        return this.userid;
    }

    protected final String getPassword() {
        return this.password;
    }

    @Override
    public final String getRepositoryURL() {
        return this.repoURL;
    }

    public void setRepositoryURL(String url) {
        if (url == null) {
            throw new IllegalArgumentException("Repository url must not be null");
        }
        this.repoURL = url;
    }

    @Override
    public void setConfiguration(TeamServerConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("TeamServerConfiguration must not be null");
        }
        this.configuration = configuration;
    }

    @Override
    public final TeamServerConfiguration getConfiguration() {
        return this.configuration;
    }

    public abstract ITeamService createTeamService(Class<?> var1, Object var2, String var3, List<ComponentConfiguration> var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final ITeamService getService(Class serviceClass) {
        if (serviceClass == null) {
            return null;
        }
        Map<Class, ITeamService> map = this.teamServices;
        synchronized (map) {
            ITeamService teamService = this.teamServices.get(serviceClass);
            if (teamService != null) {
                return teamService;
            }
            try {
                Object implementation = this.buildServiceImplementation(serviceClass);
                String version = this.lookupServiceVersion(serviceClass);
                List<ComponentConfiguration> componentConfigurations = ComponentConfigurationRegistry.INSTANCE.getComponentConfigurations();
                teamService = this.createTeamService(serviceClass, implementation, version, componentConfigurations);
                if (teamService == null) {
                    return null;
                }
                this.teamServices.put(serviceClass, teamService);
                return teamService;
            }
            catch (Throwable t) {
                t.printStackTrace();
                return null;
            }
        }
    }

    private String lookupServiceVersion(Class serviceClass) {
        String serviceUri = serviceClass.getName();
        String version = ComponentRegistry.INSTANCE.getServiceVersion(serviceUri);
        return version;
    }

    protected abstract Object buildServiceImplementation(Class<?> var1);

    @Override
    public final Object getServiceImplementation(Class serviceClass) {
        ITeamService teamService = this.getService(serviceClass);
        if (teamService == null) {
            return null;
        }
        Object implementation = teamService.getImplementation();
        return implementation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ITeamService getServiceByName(String serviceClassName) {
        if (serviceClassName == null) {
            throw new IllegalArgumentException("serviceClassName must not be null");
        }
        Map<Class, ITeamService> map = this.teamServices;
        synchronized (map) {
            Set<Class> classes = this.teamServices.keySet();
            for (Class clazz : classes) {
                String className = clazz.getName();
                boolean match = className.equals(serviceClassName);
                if (!match) continue;
                ITeamService service = this.getService(clazz);
                return service;
            }
        }
        return null;
    }
}

