/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IItemCustomAttributes;
import com.ibm.team.scm.client.internal.ItemCustomAttributes;
import com.ibm.team.scm.client.internal.SCMClientUtil;
import com.ibm.team.scm.client.internal.WorkspaceManager;
import com.ibm.team.scm.common.IRepositoryProgressMonitorHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.ICustomAttributeList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

public class VersionableCustomAttributes
extends ItemCustomAttributes
implements IItemCustomAttributes {
    private final WorkspaceManager workspaceManager;
    private final IVersionableHandle versionable;

    protected VersionableCustomAttributes(IVersionableHandle versionable, ICustomAttributeList extendedAttrs, WorkspaceManager workspaceManager) {
        super(extendedAttrs);
        this.workspaceManager = workspaceManager;
        this.versionable = versionable;
    }

    @Override
    public void saveCustomAttributes(IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor);
        Assert.isLegal((this.versionable != null ? 1 : 0) != 0);
        Assert.isLegal((boolean)this.versionable.hasStateId());
        this.workspaceManager.getServerConfigurationService().saveCustomAttributesForVersionable(this.versionable, this.extendedAttrs, (IRepositoryProgressMonitorHandle)SCMClientUtil.monitorFor(monitor));
    }
}

