/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.feeds;

import com.ibm.team.repository.common.feeds.IFeedEventGroup;
import com.ibm.team.repository.common.feeds.IFeedEventType;
import com.ibm.team.repository.common.feeds.IFeedEventTypeManager;
import com.ibm.team.repository.common.feeds.IFeedObjectType;
import com.ibm.team.repository.common.feeds.IFeedVerb;
import com.ibm.team.repository.common.feeds.internal.EventGroup;
import com.ibm.team.repository.common.feeds.internal.EventType;
import com.ibm.team.repository.common.feeds.internal.ObjectType;
import com.ibm.team.repository.common.feeds.internal.Verb;
import com.ibm.team.repository.common.internal.nls.Messages;
import com.ibm.team.repository.common.util.ExtensionRegistryReader;
import com.ibm.team.repository.common.util.NLS;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;

public abstract class AbstractFeedEventTypeManager
implements IFeedEventTypeManager {
    private static final String EVENTS_EXTENSION_POINT = "events";
    private static final String EVENT_TYPE_ID = "eventType";
    private static final String EVENT_GROUP_ID = "eventGroup";
    private static final String EVENT_TYPE_REFERENCE_ID = "eventTypeReference";
    private static final String EVENT_VERB_ID = "verb";
    private static final String EVENT_OBJECT_TYPE_ID = "objectType";
    protected static final String EXT_ID = "id";
    protected static final String EXT_ICONURI_ID = "iconUri";
    protected static final String EXT_VISIBLE_BY_DEFAULT = "isVisibleByDefault";
    private ExtensionRegistryReader fRegistryReader;
    protected final Set<IFeedEventType> fEventTypes = new HashSet<IFeedEventType>();
    protected final Set<IFeedEventGroup> fEventGroups = new HashSet<IFeedEventGroup>();
    protected final Set<IFeedVerb> fVerbDefinitions = new HashSet<IFeedVerb>();
    protected final Set<IFeedObjectType> fObjectTypeDefinition = new HashSet<IFeedObjectType>();
    private boolean fIsDisposed;

    protected abstract URL createAbsoluteUrl(String var1, IConfigurationElement var2) throws MalformedURLException;

    private URL createIconUrl(String id, IConfigurationElement element) throws Exception {
        URL pluginAbsoluteIconUrl = null;
        try {
            String pluginRelativeIconUri = element.getAttribute(EXT_ICONURI_ID);
            pluginAbsoluteIconUrl = this.createAbsoluteUrl(pluginRelativeIconUri, element);
        }
        catch (MalformedURLException e) {
            throw new Exception(NLS.bind(Messages.getServerString("AbstractEventTypeManager.ERROR_INIT_EVENT_TYPE"), id, new Object[0]), e);
        }
        return pluginAbsoluteIconUrl;
    }

    protected void readContributions() {
        this.fRegistryReader = new ExtensionRegistryReader("com.ibm.team.foundation.common", EVENTS_EXTENSION_POINT){

            protected Object handleExtensionAdded(IConfigurationElement element) throws Exception {
                String id = element.getAttribute(AbstractFeedEventTypeManager.EXT_ID);
                if (AbstractFeedEventTypeManager.EVENT_TYPE_ID.equals(element.getName())) {
                    this.handleEventTypeAdded(id, AbstractFeedEventTypeManager.this.createIconUrl(id, element), element);
                } else if (AbstractFeedEventTypeManager.EVENT_GROUP_ID.equals(element.getName())) {
                    this.handleEventGroupAdded(id, AbstractFeedEventTypeManager.this.createIconUrl(id, element), element);
                } else if (AbstractFeedEventTypeManager.EVENT_VERB_ID.equals(element.getName())) {
                    this.handleVerbAdded(id, element);
                } else if (AbstractFeedEventTypeManager.EVENT_OBJECT_TYPE_ID.equals(element.getName())) {
                    this.handleObjectTypeAdded(id, element);
                }
                return null;
            }

            private void handleEventTypeAdded(String id, URL pluginAbsoluteIconUrl, IConfigurationElement element) throws Exception {
                AbstractFeedEventTypeManager.this.fEventTypes.add(new EventType(id, pluginAbsoluteIconUrl, element));
            }

            private void handleEventGroupAdded(String id, URL pluginAbsoluteIconUrl, IConfigurationElement element) throws Exception {
                String visibleByDefault = element.getAttribute(AbstractFeedEventTypeManager.EXT_VISIBLE_BY_DEFAULT);
                IConfigurationElement[] eventTypeReferences = element.getChildren(AbstractFeedEventTypeManager.EVENT_TYPE_REFERENCE_ID);
                ArrayList<String> eventTypeIds = new ArrayList<String>(eventTypeReferences.length);
                IConfigurationElement[] iConfigurationElementArray = eventTypeReferences;
                int n = eventTypeReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement eventTypeReference = iConfigurationElementArray[n2];
                    String eventTypeId = eventTypeReference.getAttribute(AbstractFeedEventTypeManager.EXT_ID);
                    eventTypeIds.add(eventTypeId);
                    ++n2;
                }
                EventGroup group = new EventGroup(id, pluginAbsoluteIconUrl, visibleByDefault == null || Boolean.valueOf(visibleByDefault) != false, eventTypeIds, element);
                AbstractFeedEventTypeManager.this.fEventGroups.add(group);
            }

            private void handleVerbAdded(String id, IConfigurationElement element) {
                AbstractFeedEventTypeManager.this.fVerbDefinitions.add(new Verb(id, element));
            }

            private void handleObjectTypeAdded(String id, IConfigurationElement element) {
                AbstractFeedEventTypeManager.this.fObjectTypeDefinition.add(new ObjectType(id, element));
            }
        };
        this.fRegistryReader.start();
    }

    @Override
    public Collection<? extends IFeedEventType> getEventTypes() {
        return this.fEventTypes;
    }

    @Override
    public Collection<? extends IFeedEventGroup> getEventGroups() {
        return this.fEventGroups;
    }

    @Override
    public Collection<? extends IFeedVerb> getVerbs() {
        return this.fVerbDefinitions;
    }

    @Override
    public Collection<? extends IFeedObjectType> getObjectTypes() {
        return this.fObjectTypeDefinition;
    }

    public boolean isDisposed() {
        return this.fIsDisposed;
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.fRegistryReader.stop();
            this.fIsDisposed = true;
        }
    }
}

