/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.queryast.impl;

import com.ibm.team.repository.common.internal.queryast.impl.AbstractQueryElementImpl;
import com.ibm.team.repository.common.internal.queryast.impl.FeaturePathImpl;
import com.ibm.team.repository.common.internal.queryast.impl.IQueryStringTransform;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class AstFeaturePathStringTransform
implements IQueryStringTransform {
    private FeaturePathImpl fFeaturePath;

    public AstFeaturePathStringTransform(FeaturePathImpl aPath) {
        this.featurePath(aPath);
    }

    private FeaturePathImpl featurePath() {
        return this.fFeaturePath;
    }

    private void featurePath(FeaturePathImpl p) {
        this.fFeaturePath = p;
    }

    public void toJavaStringOn(StringBuffer b) {
        if (this.featurePath().getPath().length() == 0) {
            b.append(this.featurePath().getPathRootName()).append("QueryModel").append(".ROOT").append(";");
            return;
        }
        this.toJavaString(b, "r");
    }

    public void toJavaString(StringBuffer b, String aRoot) {
        String[] anArray = this.getPathArray();
        if (aRoot != null) {
            b.append(aRoot);
            if (anArray.length != 0) {
                b.append(".");
            }
        }
        int i = 0;
        while (i < anArray.length) {
            b.append(AbstractQueryElementImpl.pathStepName(anArray[i])).append("()");
            if (anArray[i].charAt(0) == '(') {
                b.append("_target(").append(AbstractQueryElementImpl.pathStepClassCast(anArray[i]).getName()).append("QueryModel").append(".ROOT").append(")");
            }
            if (i < anArray.length - 1) {
                b.append(".");
            }
            ++i;
        }
    }

    private String[] getPathArray() {
        List<String> aList = AbstractQueryElementImpl.parsePath(this.featurePath().getPath());
        Iterator<String> tok = aList.iterator();
        int n = this.featurePath().isExtended() ? aList.size() - 1 : aList.size();
        String[] anArray = new String[n];
        int i = 0;
        while (i < n) {
            anArray[i] = tok.next();
            ++i;
        }
        return anArray;
    }

    public void toDynamicJavaStringOn(StringBuffer b) {
        if (this.featurePath().getPath().length() == 0) {
            b.append("ItemUtil.itemTypeFor(").append("\"").append(this.featurePath().getPathRootName()).append("\"").append(", ").append("\"").append(this.featurePath().getPathRootNsURI()).append("\"").append(").getQueryModel();");
            return;
        }
        EStructuralFeature f = this.featurePath().getEFeature();
        b.append("(").append("(");
        if (f instanceof EAttribute) {
            b.append(this.fieldTypeCast());
        } else if (((EReference)f).isMany()) {
            b.append("IManyItemQueryModel");
        } else {
            b.append("ISingleItemQueryModel");
        }
        b.append(")").append(" ");
        this.toDynamicJavaStringOn(b, "d");
        b.append(")");
    }

    private String fieldTypeCast() {
        switch (this.featurePath().getKind().getValue()) {
            case 2: 
            case 5: 
            case 6: {
                return "INumericField";
            }
            case 0: {
                return "IStringField";
            }
            case 4: {
                return "IUUIDField";
            }
            case 3: {
                return "IEnumField";
            }
            case 1: {
                return "IDateTimeField";
            }
            case 7: {
                return "IBooleanField";
            }
        }
        return "<unknown field type>";
    }

    public void toDynamicJavaStringOn(StringBuffer b, String aRoot) {
        String[] anArray = this.getPathArray();
        if (aRoot != null) {
            b.append(aRoot);
            if (anArray.length != 0) {
                b.append(".");
            }
        }
        int i = 0;
        while (i < anArray.length) {
            b.append("getReference(").append("\"").append(AbstractQueryElementImpl.pathStepName(anArray[i])).append("\"").append(")");
            if (anArray[i].charAt(0) == '(') {
                b.append("_target(").append("QueryModel").append(".ROOT").append(")");
            }
            if (i < anArray.length - 1) {
                b.append(".");
            }
            ++i;
        }
    }
}

