/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.transport;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Locale;

public final class HostUtil {
    public static boolean authorityEquivalent(URI uri1, URI uri2) {
        String scheme2;
        if (uri1 == null) {
            throw new IllegalArgumentException("uri1 must not be null");
        }
        if (uri2 == null) {
            throw new IllegalArgumentException("uri2 must not be null");
        }
        if (!uri1.isAbsolute()) {
            throw new IllegalArgumentException("uri1 must be absolute");
        }
        if (!uri2.isAbsolute()) {
            throw new IllegalArgumentException("uri2 must be absolute");
        }
        String scheme1 = uri1.getScheme();
        if (scheme1 == null) {
            scheme1 = "";
        }
        if ((scheme2 = uri2.getScheme()) == null) {
            scheme2 = "";
        }
        if (!scheme1.toLowerCase(Locale.ENGLISH).equals(scheme2.toLowerCase(Locale.ENGLISH))) {
            return false;
        }
        int port1 = uri1.getPort();
        int port2 = uri2.getPort();
        if (port1 == -1) {
            port1 = scheme1.toLowerCase(Locale.ENGLISH).equals("https") ? 443 : 80;
        }
        if (port2 == -1) {
            port2 = scheme2.toLowerCase(Locale.ENGLISH).equals("https") ? 443 : 80;
        }
        if (port1 != port2) {
            return false;
        }
        String hostname1 = uri1.getHost();
        if (hostname1 == null) {
            return false;
        }
        String hostname2 = uri2.getHost();
        if (hostname2 == null) {
            return false;
        }
        return hostname1.toLowerCase(Locale.ENGLISH).equals(hostname2.toLowerCase(Locale.ENGLISH));
    }

    public static boolean authorityEquiv(URI uri1, URI uri2) {
        String scheme2;
        if (uri1 == null) {
            throw new IllegalArgumentException("uri1 must not be null");
        }
        if (uri2 == null) {
            throw new IllegalArgumentException("uri2 must not be null");
        }
        if (!uri1.isAbsolute()) {
            throw new IllegalArgumentException("uri1 must be absolute");
        }
        if (!uri2.isAbsolute()) {
            throw new IllegalArgumentException("uri2 must be absolute");
        }
        String scheme1 = uri1.getScheme();
        if (scheme1 == null) {
            scheme1 = "";
        }
        if ((scheme2 = uri2.getScheme()) == null) {
            scheme2 = "";
        }
        if (!scheme1.toLowerCase(Locale.ROOT).equals(scheme2.toLowerCase(Locale.ROOT))) {
            return false;
        }
        int port1 = uri1.getPort();
        int port2 = uri2.getPort();
        if (port1 == -1) {
            port1 = scheme1.toLowerCase().equals("https") ? 443 : 80;
        }
        if (port2 == -1) {
            port2 = scheme2.toLowerCase().equals("https") ? 443 : 80;
        }
        if (port1 != port2) {
            return false;
        }
        String hostname1 = uri1.getHost();
        String hostname2 = uri2.getHost();
        return HostUtil.hostsEquiv(hostname1, hostname2);
    }

    public static boolean hostsEquiv(String hostname1, String hostname2) {
        if (hostname1 == null) {
            return false;
        }
        if (hostname2 == null) {
            return false;
        }
        if (!hostname1.toLowerCase().equals(hostname2.toLowerCase(Locale.ROOT))) {
            InetAddress[] ip1 = null;
            InetAddress[] ip2 = null;
            try {
                ip1 = InetAddress.getAllByName(hostname1);
                ip2 = InetAddress.getAllByName(hostname2);
            }
            catch (UnknownHostException unknownHostException) {
                return false;
            }
            if (!HostUtil.foundIn(ip1, ip2)) {
                return false;
            }
        }
        return true;
    }

    private static boolean foundIn(InetAddress[] addrs1, InetAddress[] addrs2) {
        if (addrs1 == null) {
            throw new IllegalArgumentException("addrs1 must not be null");
        }
        if (addrs2 == null) {
            throw new IllegalArgumentException("addrs2 must not be null");
        }
        boolean addrFound = false;
        InetAddress[] inetAddressArray = addrs1;
        int n = addrs1.length;
        int n2 = 0;
        while (n2 < n) {
            InetAddress addr1 = inetAddressArray[n2];
            InetAddress[] inetAddressArray2 = addrs2;
            int n3 = addrs2.length;
            int n4 = 0;
            while (n4 < n3) {
                InetAddress addr2 = inetAddressArray2[n4];
                if (addr1.equals(addr2)) {
                    addrFound = true;
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        return addrFound;
    }
}

