/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.internal;

import com.ibm.icu.text.DateFormat;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContext;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.internal.Messages;
import com.ibm.team.workitem.client.internal.ModelPlugin;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.internal.attributevaluelabelprovider.IAttributeValueLabelProvider;
import com.ibm.team.workitem.common.internal.util.LocalizationContext;
import com.ibm.team.workitem.common.internal.util.SeparatedStringList;
import com.ibm.team.workitem.common.internal.util.Utils;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.Duration;
import com.ibm.team.workitem.common.model.DurationFormat;
import com.ibm.team.workitem.common.model.IApproval;
import com.ibm.team.workitem.common.model.IApprovalDescriptor;
import com.ibm.team.workitem.common.model.IApprovalState;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.IComment;
import com.ibm.team.workitem.common.model.IEnumeration;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.IResolution;
import com.ibm.team.workitem.common.model.IState;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.Messages;
import com.ibm.team.workitem.common.model.WorkItemApprovals;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;

public class ClientAttributeValueLabelProviderFactory {
    private static final HashMap<String, Class<? extends ClientLabelProvider>> PROVIDERS = new HashMap();
    private static final HashMap<String, Class<? extends ClientLabelProvider>> TYPE_PROVIDERS;
    private static final HashMap<String, ItemProfile<?>> PROVIDER_PROFILES;

    static {
        PROVIDERS.put(IWorkItem.STATE_PROPERTY, StateLabelProvider.class);
        PROVIDERS.put(IWorkItem.RESOLUTION_PROPERTY, ResolutionLabelProvider.class);
        PROVIDERS.put(IItem.CONTEXT_ID_PROPERTY, SecurityContextLabelProvider.class);
        PROVIDERS.put(IWorkItem.DURATION_PROPERTY, DurationLabelProvider.class);
        TYPE_PROVIDERS = new HashMap();
        TYPE_PROVIDERS.put("type", TypeLabelProvider.class);
        TYPE_PROVIDERS.put("severity", EnumerationLabelProvider.class);
        TYPE_PROVIDERS.put("priority", EnumerationLabelProvider.class);
        TYPE_PROVIDERS.put("timestamp", DateLabelProvider.class);
        TYPE_PROVIDERS.put("category", CategoryLabelProvider.class);
        TYPE_PROVIDERS.put("interval", IterationLabelProvider.class);
        TYPE_PROVIDERS.put("mediumHtml", HTMLLabelProvider.class);
        TYPE_PROVIDERS.put("html", HTMLLabelProvider.class);
        TYPE_PROVIDERS.put("smallString", ClientLabelProvider.class);
        TYPE_PROVIDERS.put("mediumString", ClientLabelProvider.class);
        TYPE_PROVIDERS.put("string", ClientLabelProvider.class);
        TYPE_PROVIDERS.put("boolean", ClientLabelProvider.class);
        TYPE_PROVIDERS.put("contributor", ClientLabelProvider.class);
        TYPE_PROVIDERS.put("deliverable", ClientLabelProvider.class);
        TYPE_PROVIDERS.put("duration", ClientLabelProvider.class);
        TYPE_PROVIDERS.put("decimal", ClientLabelProvider.class);
        TYPE_PROVIDERS.put("float", ClientLabelProvider.class);
        TYPE_PROVIDERS.put("integer", ClientLabelProvider.class);
        TYPE_PROVIDERS.put("long", ClientLabelProvider.class);
        TYPE_PROVIDERS.put("tags", TagsLabelProvider.class);
        TYPE_PROVIDERS.put("teamArea", ClientLabelProvider.class);
        TYPE_PROVIDERS.put("processArea", ClientLabelProvider.class);
        TYPE_PROVIDERS.put("projectArea", ClientLabelProvider.class);
        TYPE_PROVIDERS.put("workItem", WorkItemLabelProvider.class);
        TYPE_PROVIDERS.put("approvals", ApprovalLabelProvider.class);
        TYPE_PROVIDERS.put("approvalDescriptors", ApprovalDescriptorLabelProvider.class);
        TYPE_PROVIDERS.put("comments", CommentHeaderLabelProvider.class);
        PROVIDER_PROFILES = new HashMap();
        PROVIDER_PROFILES.put(ClientAttributeValueLabelProviderFactory.getItemTypeKey(IContributor.ITEM_TYPE), ItemProfile.CONTRIBUTOR_DEFAULT);
        PROVIDER_PROFILES.put(ClientAttributeValueLabelProviderFactory.getItemTypeKey(ICategory.ITEM_TYPE), ICategory.SMALL_PROFILE);
        PROVIDER_PROFILES.put(ClientAttributeValueLabelProviderFactory.getItemTypeKey(IIteration.ITEM_TYPE), ItemProfile.ITERATION_DEFAULT);
        PROVIDER_PROFILES.put(ClientAttributeValueLabelProviderFactory.getItemTypeKey(IWorkItem.ITEM_TYPE), IWorkItem.SMALL_PROFILE);
        PROVIDER_PROFILES.put(ClientAttributeValueLabelProviderFactory.getItemTypeKey(IProjectArea.ITEM_TYPE), ItemProfile.PROJECT_AREA_DEFAULT);
        PROVIDER_PROFILES.put(ClientAttributeValueLabelProviderFactory.getItemTypeKey(ITeamArea.ITEM_TYPE), ItemProfile.TEAM_AREA_DEFAULT);
    }

    private ClientAttributeValueLabelProviderFactory() {
    }

    private static String getItemTypeKey(IItemType type) {
        return String.valueOf(type.getNamespaceURI()) + type.getName();
    }

    private static ItemProfile<?> getItemProfile(IItemType type) {
        ItemProfile profile = PROVIDER_PROFILES.get(ClientAttributeValueLabelProviderFactory.getItemTypeKey(type));
        if (profile == null) {
            profile = ItemProfile.createFullProfile((IItemType)type);
        }
        return profile;
    }

    public static boolean hasLabelProvider(String attributeIdentifier, String typeIdentifier) {
        return ClientAttributeValueLabelProviderFactory.getLabelProviderClass(attributeIdentifier, typeIdentifier) != null;
    }

    public static IAttributeValueLabelProvider createLabelProvider(IAttribute attribute, IWorkflowInfo workflowInfo, IWorkItemCommon workItemCommon) {
        Class<? extends ClientLabelProvider> providerClass = ClientAttributeValueLabelProviderFactory.getLabelProviderClass(attribute.getIdentifier(), attribute.getAttributeType());
        ClientLabelProvider labelProvider = ClientAttributeValueLabelProviderFactory.instatiateLabelProvider(providerClass);
        labelProvider.init(attribute, workflowInfo, workItemCommon);
        return labelProvider;
    }

    private static ClientLabelProvider instatiateLabelProvider(Class<? extends ClientLabelProvider> providerClass) {
        if (providerClass == null) {
            return new ClientLabelProvider();
        }
        try {
            return providerClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<? extends ClientLabelProvider> getLabelProviderClass(String attributeIdentifier, String typeIdentifier) {
        Class<? extends ClientLabelProvider> providerClass = PROVIDERS.get(attributeIdentifier);
        if (providerClass == null) {
            providerClass = TYPE_PROVIDERS.get(typeIdentifier);
        }
        if (providerClass == null) {
            String type = Utils.getValueAttributeTypeId((String)attributeIdentifier, (String)typeIdentifier);
            providerClass = TYPE_PROVIDERS.get(type);
        }
        if (providerClass == null && AttributeTypes.isEnumerationAttributeType((String)typeIdentifier)) {
            providerClass = EnumerationLabelProvider.class;
        }
        if (providerClass == null && AttributeTypes.isEnumerationListAttributeType((String)typeIdentifier)) {
            providerClass = EnumerationListLabelProvider.class;
        }
        return providerClass;
    }

    static class ApprovalDescriptorLabelProvider
    extends ClientLabelProvider {
        ApprovalDescriptorLabelProvider() {
        }

        @Override
        public String getText(Object element, IProgressMonitor monitor) {
            if (element instanceof IApprovalDescriptor) {
                IApprovalDescriptor descriptor = (IApprovalDescriptor)element;
                IApprovalState cumulativeState = WorkItemApprovals.getState((String)descriptor.getCumulativeStateIdentifier());
                DateFormat dateFormat = DateFormat.getDateTimeInstance((int)2, (int)3);
                Timestamp dueDate = descriptor.getDueDate();
                if (dueDate == null) {
                    return NLS.bind((String)Messages.ClientAttributeValueLabelProvider_APPROVALS_DESCRIPTOR_FORMAT, (Object)descriptor.getName(), (Object[])new Object[]{cumulativeState.getDisplayName()});
                }
                return NLS.bind((String)Messages.ClientAttributeValueLabelProvider_APPROVALS_DESCRIPTOR_DUE_FORMAT, (Object)descriptor.getName(), (Object[])new Object[]{cumulativeState.getDisplayName(), dateFormat.format((Date)dueDate)});
            }
            return super.getText(element, monitor);
        }
    }

    static class ApprovalLabelProvider
    extends ClientLabelProvider {
        ApprovalLabelProvider() {
        }

        @Override
        protected void init(IAttribute attribute, IWorkflowInfo info, IWorkItemCommon workItemCommon) {
            super.init(attribute, info, workItemCommon);
        }

        @Override
        public String getText(Object element, IProgressMonitor monitor) {
            if (element instanceof IApproval) {
                IApproval approval = (IApproval)element;
                IApprovalState currState = WorkItemApprovals.getState((String)approval.getStateIdentifier());
                IAuditableCommon auditableCommon = this.getAuditableCommon();
                IContributor contributor = null;
                String contributorName = null;
                try {
                    contributor = (IContributor)auditableCommon.resolveAuditable((IAuditableHandle)approval.getApprover(), ItemProfile.CONTRIBUTOR_DEFAULT, monitor);
                    contributorName = contributor.getName();
                }
                catch (TeamRepositoryException e) {
                    ModelPlugin.log("Exception caught while resolving approvals contributor", (Exception)((Object)e));
                    contributorName = Messages.ClientAttributeValueLabelProvider_APPROVALS_NO_CONTRIBUTOR;
                }
                return NLS.bind((String)Messages.ClientAttributeValueLabelProvider_APPROVALS_FORMAT, (Object)currState.getDisplayName(), (Object[])new Object[]{contributorName});
            }
            return super.getText(element, monitor);
        }
    }

    static class CategoryLabelProvider
    extends ClientLabelProvider {
        private static final String HIERARCHICAL_NAME_DELIMITER = "   ";

        CategoryLabelProvider() {
        }

        @Override
        public String getText(Object element, IProgressMonitor monitor) {
            if ((element = this.getElement(element)) instanceof ICategory) {
                ICategory category = (ICategory)element;
                StringBuffer name = new StringBuffer();
                int i = 0;
                int n = category.getDepth();
                while (i < n) {
                    name.append(HIERARCHICAL_NAME_DELIMITER);
                    ++i;
                }
                name.append(category.getName());
                return name.toString();
            }
            return super.getText(element, monitor);
        }
    }

    public static class ClientLabelProvider
    implements IAttributeValueLabelProvider {
        private IAttribute fAttribute;
        private IWorkflowInfo fWorkflowInfo;
        private IWorkItemCommon fWorkItemCommon;

        protected void init(IAttribute attribute, IWorkflowInfo info, IWorkItemCommon workItemCommon) {
            this.fAttribute = attribute;
            this.fWorkItemCommon = workItemCommon;
            this.fWorkflowInfo = info;
        }

        protected IAttribute getAttribute() {
            return this.fAttribute;
        }

        protected IAuditableCommon getAuditableCommon() {
            return this.fWorkItemCommon.getAuditableCommon();
        }

        protected IWorkItemCommon getWorkItemCommon() {
            return this.fWorkItemCommon;
        }

        protected IProjectAreaHandle getProjectArea() {
            return this.fAttribute.getProjectArea();
        }

        protected IWorkflowInfo getWorkflowInfo() {
            return this.fWorkflowInfo;
        }

        public String getText(Object element, IProgressMonitor monitor) {
            if ((element = this.getElement(element)) == null) {
                return Messages.ClientAttributeValueLabelProvider_UNASSIGNED_LITERAL;
            }
            return AttributeExpression.toString((Object)element);
        }

        protected Object getElement(Object element) {
            if (element instanceof IAuditableHandle) {
                IAuditableHandle handle = (IAuditableHandle)element;
                if (handle.hasFullState()) {
                    return handle;
                }
                try {
                    return this.getAuditableCommon().resolveAuditable(handle, ClientAttributeValueLabelProviderFactory.getItemProfile(handle.getItemType()), null);
                }
                catch (PermissionDeniedException permissionDeniedException) {
                    return Messages.ClientAttributeValueLabelProvider_NOT_AVAILABLE;
                }
                catch (ItemNotFoundException itemNotFoundException) {
                    return Messages.ClientAttributeValueLabelProvider_NOT_AVAILABLE;
                }
                catch (TeamRepositoryException e) {
                    this.log("Could not resolve auditable: " + handle.getItemType().getName() + ", itemId: " + handle.getItemId().getUuidValue(), (Exception)((Object)e));
                    return element;
                }
            }
            if (element instanceof UUID) {
                return this.getAuditableCommon().resolveAccessContext((UUID)element, null);
            }
            return element;
        }

        protected void log(String message, Exception e) {
            ModelPlugin.log(message, e);
        }
    }

    static class CommentHeaderLabelProvider
    extends ClientLabelProvider {
        CommentHeaderLabelProvider() {
        }

        @Override
        public String getText(Object element, IProgressMonitor monitor) {
            if (element instanceof List) {
                String contributorName;
                List comments = (List)element;
                if (comments == null || comments.isEmpty()) {
                    return null;
                }
                IComment lastComment = (IComment)comments.get(comments.size() - 1);
                try {
                    IContributor contributor = (IContributor)this.getAuditableCommon().resolveAuditable((IAuditableHandle)lastComment.getCreator(), ItemProfile.CONTRIBUTOR_DEFAULT, monitor);
                    contributorName = contributor.getName();
                }
                catch (TeamRepositoryException e) {
                    ModelPlugin.log("Exception caught while resolving comments contributor", (Exception)((Object)e));
                    contributorName = Messages.ClientAttributeValueLabelProvider_COMMENTS_NO_CONTRIBUTOR;
                }
                String datestamp = DateFormat.getDateTimeInstance((int)2, (int)3).format((Date)lastComment.getCreationDate());
                return NLS.bind((String)Messages.ClientAttributeValueLabelProvider_COMMENTS_FORMAT, (Object)comments.size(), (Object[])new Object[]{contributorName, datestamp});
            }
            return super.getText(element, monitor);
        }
    }

    static class DateLabelProvider
    extends ClientLabelProvider {
        DateLabelProvider() {
        }

        @Override
        public String getText(Object element, IProgressMonitor monitor) {
            if (element instanceof Date) {
                return String.valueOf(((Date)element).getTime());
            }
            return super.getText(element, monitor);
        }
    }

    static class DurationLabelProvider
    extends ClientLabelProvider {
        private DurationFormat fDurationFormat = null;

        DurationLabelProvider() {
        }

        @Override
        public synchronized String getText(Object element, IProgressMonitor monitor) {
            if (element instanceof Number) {
                if (this.fDurationFormat == null) {
                    this.fDurationFormat = new DurationFormat(Locale.getDefault());
                    this.fDurationFormat.setUpperBoundOutputUnit(DurationFormat.Units.Hours);
                    this.fDurationFormat.setUnspecifiedString("");
                }
                return this.fDurationFormat.format(new Duration(((Number)element).longValue()));
            }
            return super.getText(element, monitor);
        }
    }

    static class EnumerationLabelProvider
    extends ClientLabelProvider {
        private long fLastAccessed;
        private IEnumeration<?> fCachedEnumeration;

        EnumerationLabelProvider() {
        }

        @Override
        public String getText(Object element, IProgressMonitor monitor) {
            Object value = this.getElement(element);
            if (value instanceof Identifier) {
                Identifier identifier = (Identifier)value;
                ILiteral literal = this.getLiteral((Identifier<ILiteral>)identifier);
                if (literal != null) {
                    return literal.getName();
                }
                return identifier.getStringIdentifier();
            }
            return super.getText(element, monitor);
        }

        private ILiteral getLiteral(Identifier<ILiteral> identifier) {
            IEnumeration<?> enumeration = this.getEnumeration();
            if (enumeration != null) {
                return enumeration.findEnumerationLiteral(identifier);
            }
            return null;
        }

        private IEnumeration<?> getEnumeration() {
            if (System.currentTimeMillis() - this.fLastAccessed > 1000L) {
                this.fCachedEnumeration = this.resolveEnumeration();
            }
            this.fLastAccessed = System.currentTimeMillis();
            return this.fCachedEnumeration;
        }

        private IEnumeration<?> resolveEnumeration() {
            try {
                IAttribute attribute = this.getAttribute();
                IEnumeration enumeration = this.getWorkItemCommon().findCachedEnumeration(attribute);
                if (enumeration == null) {
                    enumeration = this.getWorkItemCommon().resolveEnumeration((IAttributeHandle)attribute, null);
                }
                return enumeration;
            }
            catch (TeamRepositoryException e) {
                this.log("Error resolving enumeration", (Exception)((Object)e));
                return null;
            }
        }
    }

    static class EnumerationListLabelProvider
    extends ListLabelProvider {
        private EnumerationLabelProvider fEnumerationLabelProvider = new EnumerationLabelProvider();

        EnumerationListLabelProvider() {
        }

        @Override
        protected String getItemText(Object item, IProgressMonitor monitor) {
            return this.fEnumerationLabelProvider.getText(item, monitor);
        }

        @Override
        protected void init(IAttribute attribute, IWorkflowInfo info, IWorkItemCommon workItemCommon) {
            super.init(attribute, info, workItemCommon);
            this.fEnumerationLabelProvider.init(attribute, info, workItemCommon);
        }
    }

    static class HTMLLabelProvider
    extends ClientLabelProvider {
        HTMLLabelProvider() {
        }

        @Override
        public String getText(Object element, IProgressMonitor monitor) {
            XMLString xmlString = XMLString.createFromXMLText((String)super.getText(element, monitor));
            return xmlString.getPlainText();
        }
    }

    static class IterationLabelProvider
    extends ClientLabelProvider {
        IterationLabelProvider() {
        }

        @Override
        public String getText(Object element, IProgressMonitor monitor) {
            String text = this.getLabel(element = this.getElement(element));
            if (text != null) {
                return text;
            }
            return super.getText(element, monitor);
        }

        private String getLabel(Object value) {
            if (value == null) {
                return Messages.UnassignedValues.getTarget((LocalizationContext)LocalizationContext.getDefault());
            }
            if (value instanceof IIteration) {
                return this.getIterationName((IIteration)value);
            }
            return null;
        }

        private String getIterationName(IIteration iteration) {
            return iteration.getName() != null && !"".equals(iteration.getName()) ? iteration.getName() : iteration.getId();
        }
    }

    static abstract class ListLabelProvider
    extends ClientLabelProvider {
        ListLabelProvider() {
        }

        @Override
        public String getText(Object element, IProgressMonitor monitor) {
            Object value = element;
            StringBuilder builder = new StringBuilder();
            if (value instanceof Collection) {
                ArrayList collection = (ArrayList)value;
                Comparator comparator = this.getItemComparator();
                if (comparator != null) {
                    collection = new ArrayList(collection);
                    Collections.sort(collection, comparator);
                }
                Iterator it = collection.iterator();
                while (it.hasNext()) {
                    Object o = it.next();
                    String itemLabel = this.getItemText(o, monitor);
                    builder.append(itemLabel);
                    if (!it.hasNext() || itemLabel.length() <= 0) continue;
                    builder.append(", ");
                }
                return builder.toString();
            }
            return this.getItemText(element, monitor);
        }

        protected abstract String getItemText(Object var1, IProgressMonitor var2);

        protected Comparator getItemComparator() {
            return null;
        }
    }

    static class ResolutionLabelProvider
    extends ClientLabelProvider {
        ResolutionLabelProvider() {
        }

        @Override
        public String getText(Object element, IProgressMonitor monitor) {
            Identifier<IResolution> resolution = this.getResolution(element);
            if (resolution != null) {
                return this.getName(resolution);
            }
            return super.getText(element, monitor);
        }

        private Identifier<IResolution> getResolution(Object element) {
            if (element instanceof Identifier) {
                return (Identifier)element;
            }
            if (element instanceof String && element.toString().length() > 0) {
                return Identifier.create(IResolution.class, (String)element.toString());
            }
            if (element instanceof Integer) {
                int state = (Integer)element;
                return Identifier.create(IResolution.class, (String)Integer.toString(state));
            }
            return null;
        }

        private String getName(Identifier<IResolution> resolution) {
            if (this.getWorkflowInfo() != null) {
                return this.getWorkflowInfo().getResolutionName(resolution);
            }
            return this.getWorkItemCommon().findCachedCombinedWorkflowInfos(this.getProjectArea()).getResolutionName(resolution);
        }
    }

    static class SecurityContextLabelProvider
    extends ClientLabelProvider {
        SecurityContextLabelProvider() {
        }

        @Override
        public String getText(Object element, IProgressMonitor monitor) {
            if (IContext.PUBLIC.equals(element = this.getElement(element))) {
                return Messages.ClientAttributeValueLabelProvider_PUBLIC;
            }
            return super.getText(element, monitor);
        }
    }

    static class StateLabelProvider
    extends ClientLabelProvider {
        StateLabelProvider() {
        }

        @Override
        public String getText(Object element, IProgressMonitor monitor) {
            Identifier<IState> state = this.getState(element);
            if (state != null) {
                return this.getName(state);
            }
            return super.getText(element, monitor);
        }

        private Identifier<IState> getState(Object element) {
            if (element instanceof Identifier) {
                return (Identifier)element;
            }
            if (element instanceof String && element.toString().length() > 0) {
                return Identifier.create(IState.class, (String)element.toString());
            }
            if (element instanceof Integer) {
                int state = (Integer)element;
                return Identifier.create(IState.class, (String)Integer.toString(state));
            }
            return null;
        }

        private String getName(Identifier<IState> state) {
            if (this.getWorkflowInfo() != null) {
                return this.getWorkflowInfo().getStateName(state);
            }
            return this.getWorkItemCommon().findCachedCombinedWorkflowInfos(this.getProjectArea()).getStateName(state);
        }
    }

    static class TagsLabelProvider
    extends ClientLabelProvider {
        TagsLabelProvider() {
        }

        @Override
        public String getText(Object element, IProgressMonitor monitor) {
            if (element instanceof Collection) {
                return SeparatedStringList.toCommaSeparatedValue((Collection)((Collection)element));
            }
            return element.toString();
        }
    }

    static class TypeLabelProvider
    extends ClientLabelProvider {
        TypeLabelProvider() {
        }

        @Override
        public String getText(Object element, IProgressMonitor monitor) {
            IWorkItemType type = this.getWorkItemType(element);
            if (type != null) {
                return type.getDisplayName();
            }
            return super.getText(element, monitor);
        }

        private IWorkItemType getWorkItemType(Object element) {
            if (element instanceof String) {
                String identifier = (String)element;
                element = this.getWorkItemCommon().findCachedWorkItemType(this.getProjectArea(), identifier);
                if (element == null) {
                    try {
                        element = this.getWorkItemCommon().findWorkItemType(this.getProjectArea(), identifier, null);
                    }
                    catch (TeamRepositoryException e) {
                        this.log("Could not resolve work item type: " + identifier, (Exception)((Object)e));
                    }
                }
            }
            if (element instanceof IWorkItemType) {
                return (IWorkItemType)element;
            }
            return null;
        }
    }

    static class WorkItemLabelProvider
    extends ClientLabelProvider {
        WorkItemLabelProvider() {
        }

        @Override
        public String getText(Object element, IProgressMonitor monitor) {
            if ((element = this.getElement(element)) instanceof IWorkItem) {
                return WorkItemTextUtilities.getWorkItemText((IWorkItem)((IWorkItem)element));
            }
            return super.getText(element, monitor);
        }
    }
}

