/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.internal.template;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemTemplateClient;
import com.ibm.team.workitem.client.internal.ClientServiceContext;
import com.ibm.team.workitem.client.internal.template.Messages;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.ICommonServiceContext;
import com.ibm.team.workitem.common.internal.IWorkItemTemplateService;
import com.ibm.team.workitem.common.internal.ServiceRunnable;
import com.ibm.team.workitem.common.internal.template.WorkItemTemplateDescriptor;
import com.ibm.team.workitem.common.internal.template.WorkItemTemplateSerializable;
import com.ibm.team.workitem.common.internal.template.xml.XMLTemplateParser;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.template.IAttributeVariable;
import com.ibm.team.workitem.common.template.IWorkItemTemplate;
import com.ibm.team.workitem.common.template.IWorkItemTemplateHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

public class WorkItemTemplateClient
implements IWorkItemTemplateClient {
    private final ICommonServiceContext fContext;

    public WorkItemTemplateClient(IClientLibraryContext context) {
        if (context == null) {
            throw new IllegalArgumentException(Messages.WorkItemTemplateClient_ERROR_ON_INITIALIZATION);
        }
        this.fContext = new ClientServiceContext(context);
    }

    @Override
    public String createTemplateIdentifier(final IProjectAreaHandle project, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)project);
        ServiceRunnable<String> runnable = new ServiceRunnable<String>(){

            public String run() throws TeamRepositoryException {
                return WorkItemTemplateClient.this.getService().createTemplateIdentifier(project);
            }
        };
        return (String)this.fContext.callCancelableService((ServiceRunnable)runnable, monitor);
    }

    @Override
    public void createTemplate(final IWorkItemTemplateHandle handle, final List<IWorkItem> workItems, IProgressMonitor monitor) throws TeamRepositoryException {
        this.assertValidHandle(handle);
        Assert.isNotNull(workItems);
        ServiceRunnable<Object> runnable = new ServiceRunnable<Object>(){

            public Object run() throws TeamRepositoryException {
                WorkItemTemplateDescriptor desc = new WorkItemTemplateDescriptor(handle);
                desc.setWorkItems(workItems);
                WorkItemTemplateClient.this.getService().createTemplate(WorkItemTemplateSerializable.serializeTemplateDescriptor((WorkItemTemplateDescriptor)desc));
                return null;
            }
        };
        this.fContext.callCancelableService((ServiceRunnable)runnable, monitor);
    }

    @Override
    public void removeTemplate(final IWorkItemTemplateHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        this.assertValidHandle(handle);
        ServiceRunnable<Object> runnable = new ServiceRunnable<Object>(){

            public Object run() throws TeamRepositoryException {
                WorkItemTemplateClient.this.getService().removeTemplate(handle.getId(), handle.getProjectArea());
                return null;
            }
        };
        this.fContext.callCancelableService((ServiceRunnable)runnable, monitor);
    }

    @Override
    public IWorkItemTemplateHandle getTemplateHandle(final String identifier, final IProjectAreaHandle project, IProgressMonitor monitor) throws TeamRepositoryException {
        this.assertValidString(identifier);
        Assert.isNotNull((Object)project);
        ServiceRunnable<IWorkItemTemplateHandle> runnable = new ServiceRunnable<IWorkItemTemplateHandle>(){

            public IWorkItemTemplateHandle run() throws TeamRepositoryException {
                Object[] data = WorkItemTemplateClient.this.getService().getTemplate(identifier, project);
                if (data == null || data.length == 0) {
                    return null;
                }
                return WorkItemTemplateSerializable.deserializeTemplateHandle((Object[])data);
            }
        };
        return (IWorkItemTemplateHandle)this.fContext.callCancelableService((ServiceRunnable)runnable, monitor);
    }

    @Override
    public List<IWorkItemTemplateHandle> getTemplateHandles(final IProjectAreaHandle project, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)project);
        ServiceRunnable<List<IWorkItemTemplateHandle>> runnable = new ServiceRunnable<List<IWorkItemTemplateHandle>>(){

            public List<IWorkItemTemplateHandle> run() throws TeamRepositoryException {
                int entryLength;
                ArrayList<IWorkItemTemplateHandle> result = new ArrayList<IWorkItemTemplateHandle>();
                Object[] handles = WorkItemTemplateClient.this.getService().getAvailableTemplates2(project);
                if (handles.length >= (entryLength = 6)) {
                    int idx = 0;
                    while (idx < handles.length) {
                        Object[] curEntry = new Object[entryLength];
                        int entryIdx = 0;
                        while (entryIdx < entryLength) {
                            curEntry[entryIdx] = handles[idx + entryIdx];
                            ++entryIdx;
                        }
                        result.add(WorkItemTemplateSerializable.deserializeTemplateHandle((Object[])curEntry));
                        idx += entryLength;
                    }
                }
                return result;
            }
        };
        return (List)this.fContext.callCancelableService((ServiceRunnable)runnable, monitor);
    }

    @Override
    public IWorkItemTemplate fetchTemplate(final IWorkItemTemplateHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        this.assertValidHandle(handle);
        ServiceRunnable<IWorkItemTemplate> runnable = new ServiceRunnable<IWorkItemTemplate>(){

            public IWorkItemTemplate run() throws TeamRepositoryException {
                String content = WorkItemTemplateClient.this.getService().resolveTemplate(handle.getId(), handle.getProjectArea());
                if (content == null || content.length() == 0) {
                    return null;
                }
                XMLTemplateParser parser = new XMLTemplateParser(handle.getProjectArea(), (IWorkItemCommon)WorkItemTemplateClient.this.fContext.getService(IWorkItemCommon.class));
                return parser.parseTemplate(content);
            }
        };
        return (IWorkItemTemplate)this.fContext.callCancelableService((ServiceRunnable)runnable, monitor);
    }

    @Override
    public int[] instantiateTemplate(final IWorkItemTemplateHandle handle, final Map<IAttributeVariable, Object> variables, IProgressMonitor monitor) throws TeamRepositoryException {
        this.assertValidHandle(handle);
        Assert.isNotNull(variables);
        ServiceRunnable<int[]> runnable = new ServiceRunnable<int[]>(){

            public int[] run() throws TeamRepositoryException {
                return WorkItemTemplateClient.this.getService().instantiateTemplate(handle.getId(), WorkItemTemplateSerializable.serializeVariableValues((Map)variables), handle.getProjectArea());
            }
        };
        return (int[])this.fContext.callCancelableService((ServiceRunnable)runnable, monitor);
    }

    @Override
    public void importTemplate(final IWorkItemTemplate template, final boolean overwrite, IProgressMonitor monitor) throws TeamRepositoryException {
        this.assertValidHandle((IWorkItemTemplateHandle)template);
        Assert.isNotNull((Object)template.getContent());
        ServiceRunnable<Object> runnable = new ServiceRunnable<Object>(){

            public Object run() throws TeamRepositoryException {
                WorkItemTemplateClient.this.getService().importTemplate2(template.getContent(), overwrite, template.getProjectArea());
                return null;
            }
        };
        this.fContext.callCancelableService((ServiceRunnable)runnable, monitor);
    }

    public IWorkItemTemplateService getService() throws TeamRepositoryException {
        IWorkItemTemplateService service = (IWorkItemTemplateService)this.fContext.getService(IWorkItemTemplateService.class);
        if (service == null) {
            throw new TeamRepositoryException(Messages.WorkItemTemplateClient_ERROR_ON_ACCESSING_TEMPLATE_SERVICE);
        }
        return service;
    }

    private void assertValidHandle(IWorkItemTemplateHandle handle) {
        Assert.isNotNull((Object)handle);
        this.assertValidString(handle.getId());
        Assert.isNotNull((Object)handle.getProjectArea());
    }

    private boolean assertValidString(String str) {
        return Assert.isTrue((str != null && str.length() > 0 ? 1 : 0) != 0);
    }
}

