/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.runtime;

import com.urbancode.commons.util.StringUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpConnectionSettings {
    private static final Logger logger = Logger.getLogger(HttpConnectionSettings.class);
    public static final Pattern URI_PATTERN = Pattern.compile("^(?:(http|https)://)?([^/:]+)(?::(\\d+))?/?$");
    private URI serverUri;
    private String proxyHost;
    private int proxyPort = -1;
    private String proxyUserName;
    private String proxyPassword;
    private Collection<Pattern> nonProxiedHostPatterns = new HashSet<Pattern>();

    public static URI parseUri(String uri) {
        URI result = null;
        try {
            result = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("invalid url: " + uri, e);
        }
        return result;
    }

    public HttpConnectionSettings(String serverUriStr) {
        if (serverUriStr == null) {
            throw new NullPointerException("The server URI for connecting with the server was null. Please set 'WEB_URL' in the environment.");
        }
        URI uri = HttpConnectionSettings.parseUri(serverUriStr);
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("uri is not absolute: " + serverUriStr);
        }
        if (uri.getScheme() == null) {
            throw new IllegalArgumentException("uri does not specify a scheme: " + serverUriStr);
        }
        if (uri.getHost() == null) {
            throw new IllegalArgumentException("uri does not specify a host: " + serverUriStr);
        }
        this.serverUri = uri;
        this.setProxySettingsFromProperties(System.getProperties());
    }

    public String getServerAddress() {
        return this.serverUri.toString();
    }

    public String getScheme() {
        return this.serverUri.getScheme();
    }

    public String getHostName() {
        return this.serverUri.getHost();
    }

    public int getPort() {
        return this.serverUri.getPort();
    }

    public String getPath() {
        return this.serverUri.getPath();
    }

    public void setProxySettingsFromProperties(Properties properties) {
        String nonProxyHostsProperty = properties.getProperty("http.nonProxyHosts");
        if (nonProxyHostsProperty != null) {
            for (String patternString : nonProxyHostsProperty.split("\\|+")) {
                if ((patternString = patternString.trim()).length() <= 0) continue;
                try {
                    Pattern pattern = this.convertExpressionToPattern(patternString);
                    this.nonProxiedHostPatterns.add(pattern);
                }
                catch (PatternSyntaxException e) {
                    logger.error((Object)("Invalid nonProxyHost pattern - " + patternString), (Throwable)e);
                }
            }
        }
        String hostStr = properties.getProperty("http.proxyHost");
        String portStr = properties.getProperty("http.proxyPort", "-1");
        String username = properties.getProperty("http.proxyUserName");
        username = properties.getProperty("http.proxyUser", username);
        String password = properties.getProperty("http.proxyPassword");
        if (!StringUtil.isEmpty((String)hostStr)) {
            this.setProxyHost(hostStr);
            try {
                this.setProxyPort(Integer.valueOf(portStr));
            }
            catch (NumberFormatException e) {
                logger.error((Object)("Invalid http.proxyPort property value (" + portStr + " is not a number)"), (Throwable)e);
            }
            this.setProxyUserName(username);
            this.setProxyPassword(password);
        }
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUserName() {
        return this.proxyUserName;
    }

    public void setProxyUserName(String proxyUserName) {
        this.proxyUserName = proxyUserName;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public Collection<Pattern> getNonProxyiedHostPatterns() {
        return Collections.unmodifiableCollection(this.nonProxiedHostPatterns);
    }

    public boolean shouldProxy() {
        String host = this.getHostName();
        if (host == null || StringUtil.isEmpty((String)this.getProxyHost())) {
            return false;
        }
        boolean shouldProxy = true;
        for (Pattern nonProxyPattern : this.getNonProxyiedHostPatterns()) {
            if (!nonProxyPattern.matcher(host).matches()) continue;
            shouldProxy = false;
            break;
        }
        return shouldProxy;
    }

    protected Pattern convertExpressionToPattern(String patternString) throws PatternSyntaxException {
        String quoteChars = "[" + "\\.+[]^$?{}|()".replaceAll(".", "\\\\$0") + "]";
        String regexPattern = patternString.replaceAll(quoteChars, "\\\\$0").replace("*", ".*");
        return Pattern.compile(regexPattern);
    }

    protected URI parseUriAlternate(String uri) {
        URI result;
        String host;
        URI part = URI.create(uri.trim());
        if (part.getPath() != null) {
            throw new IllegalArgumentException("Path is not allowed - " + uri);
        }
        if (part.getQuery() != null) {
            throw new IllegalArgumentException("Query is not allowed - " + uri);
        }
        if (part.getFragment() != null) {
            throw new IllegalArgumentException("Fragment is not allowed - " + uri);
        }
        if (part.getUserInfo() != null) {
            throw new IllegalArgumentException("User Info is not allowed - " + uri);
        }
        String scheme = part.getScheme();
        if (scheme == null) {
            scheme = "http";
        }
        if ((host = part.getHost()) == null) {
            throw new IllegalArgumentException("A host is required - " + uri);
        }
        int port = part.getPort();
        try {
            result = new URI(scheme, null, host, port, null, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("invalid url: " + uri, e);
        }
        return result;
    }
}

