/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.registry.metadata;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.registry.Injectable;
import org.apache.wink.common.internal.registry.InjectableFactory;
import org.apache.wink.common.internal.registry.metadata.AbstractMetadataCollector;
import org.apache.wink.common.internal.registry.metadata.ClassMetadata;
import org.apache.wink.common.internal.utils.GenericsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderMetadataCollector
extends AbstractMetadataCollector {
    private static final Logger logger = LoggerFactory.getLogger(ProviderMetadataCollector.class);

    private ProviderMetadataCollector(Class<?> clazz) {
        super(clazz);
    }

    public static boolean isProvider(Class<?> cls) {
        logger.trace("isProvider({}) entry", cls);
        if (cls == Object.class) {
            logger.trace("isProvider() exit returning false");
            return false;
        }
        if (Modifier.isInterface(cls.getModifiers()) || Modifier.isAbstract(cls.getModifiers())) {
            if (logger.isWarnEnabled()) {
                logger.warn(Messages.getMessage("providerIsInterfaceOrAbstract", cls));
            }
            logger.trace("isProvider() exit returning false");
            return false;
        }
        if (cls.getAnnotation(Provider.class) != null) {
            return true;
        }
        for (Class<?> declaringClass = cls; declaringClass != null && !declaringClass.equals(Object.class); declaringClass = declaringClass.getSuperclass()) {
            Class<?>[] interfaces;
            Class<?> superclass = declaringClass.getSuperclass();
            if (superclass != null && superclass.getAnnotation(Provider.class) != null) {
                if (logger.isWarnEnabled()) {
                    logger.warn(Messages.getMessage("providerShouldBeAnnotatedDirectly", cls, superclass));
                }
                logger.trace("isProvider({}) exit returning true", superclass);
                return true;
            }
            for (Class<?> interfaceClass : interfaces = declaringClass.getInterfaces()) {
                if (interfaceClass.getAnnotation(Provider.class) == null) continue;
                if (logger.isWarnEnabled()) {
                    logger.warn(Messages.getMessage("providerShouldBeAnnotatedDirectly", cls, interfaceClass));
                }
                logger.trace("isProvider({}) exit returning true", interfaceClass);
                return true;
            }
        }
        logger.trace("isProvider() exit returning false");
        return false;
    }

    public static ClassMetadata collectMetadata(Class<?> clazz) {
        logger.trace("collectMetadata({})", clazz);
        ProviderMetadataCollector collector = new ProviderMetadataCollector(clazz);
        collector.parseConstructors();
        collector.parseFields();
        ClassMetadata md = collector.getMetadata();
        logger.trace("collectMetadata() exit returning {}", md);
        return md;
    }

    @Override
    protected final boolean isConstructorParameterValid(Injectable fp) {
        return fp.getParamType() == Injectable.ParamType.CONTEXT;
    }

    @Override
    protected Injectable parseAccessibleObject(AccessibleObject field, Type fieldType) {
        Context context = field.getAnnotation(Context.class);
        if (context != null) {
            return InjectableFactory.getInstance().createContextParam(GenericsUtils.getClassType(fieldType, ((Member)((Object)field)).getDeclaringClass()), field.getAnnotations(), (Member)((Object)field));
        }
        return null;
    }
}

