/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.application;

import java.lang.reflect.Modifier;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.apache.wink.common.WinkApplication;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.registry.ProvidersRegistry;
import org.apache.wink.common.internal.registry.metadata.ProviderMetadataCollector;
import org.apache.wink.common.internal.registry.metadata.ResourceMetadataCollector;
import org.apache.wink.server.internal.registry.ResourceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationProcessor.class);
    private final Application application;
    private final ResourceRegistry resourceRegistry;
    private final ProvidersRegistry providersRegistry;
    private final boolean isSystemApplication;

    public ApplicationProcessor(Application application, ResourceRegistry resourceRegistry, ProvidersRegistry providersRegistry, boolean isSystemApplication) {
        this.application = application;
        this.resourceRegistry = resourceRegistry;
        this.providersRegistry = providersRegistry;
        this.isSystemApplication = isSystemApplication;
    }

    public void process() {
        Set<Class<?>> classes;
        Set<Object> singletons;
        logger.trace("Processing Application: {}", this.application);
        double priority = 0.5;
        if (this.application instanceof WinkApplication) {
            priority = ((WinkApplication)this.application).getPriority();
            logger.trace("WinkApplication priority is set to: {}", priority);
        }
        if ((singletons = this.application.getSingletons()) != null && singletons.size() > 0) {
            this.processSingletons(singletons, priority);
        }
        if ((classes = this.application.getClasses()) != null && classes.size() > 0) {
            this.processClasses(classes, priority);
        }
        if (this.application instanceof WinkApplication) {
            this.processWinkApplication((WinkApplication)this.application);
        }
        if (!this.isSystemApplication && logger.isInfoEnabled()) {
            logger.info(Messages.getMessage("applicationProcessed", this.application.getClass().getName()));
        }
        logger.trace("Processing of Application completed.");
    }

    private void processWinkApplication(WinkApplication sApplication) {
        Set<Object> instances = sApplication.getInstances();
        double priority = sApplication.getPriority();
        if (instances == null) {
            logger.trace("WinkApplication.getInstances() returned null");
            return;
        }
        for (Object obj : instances) {
            try {
                logger.trace("Processing instance: {}", obj);
                Class<?> cls = obj.getClass();
                if (ResourceMetadataCollector.isDynamicResource(cls)) {
                    this.resourceRegistry.addResource(obj, priority);
                    continue;
                }
                if (ResourceMetadataCollector.isStaticResource(cls)) {
                    this.resourceRegistry.addResource(obj, priority);
                    continue;
                }
                if (ProviderMetadataCollector.isProvider(cls)) {
                    this.providersRegistry.addProvider(obj, priority, this.isSystemApplication);
                    continue;
                }
                if (!logger.isWarnEnabled()) continue;
                logger.warn(Messages.getMessage("classNotADynamicResourceNorResourceNorProvider", obj.getClass().getName()));
            }
            catch (Exception e) {
                if (logger.isErrorEnabled()) {
                    logger.error(Messages.getMessage("exceptionOccurredDuringInstanceProcessing", obj.getClass().getCanonicalName()), e);
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug(Messages.getMessage("exceptionOccurredDuringInstanceProcessing", obj.getClass().getCanonicalName()), e);
            }
            catch (NoClassDefFoundError e) {
                if (logger.isErrorEnabled()) {
                    logger.error(Messages.getMessage("exceptionOccurredDuringInstanceProcessing", obj.getClass().getCanonicalName()), e);
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug(Messages.getMessage("exceptionOccurredDuringInstanceProcessing", obj.getClass().getCanonicalName()), e);
            }
        }
    }

    private void processClasses(Set<Class<?>> classes, double priority) {
        for (Class<?> cls : classes) {
            try {
                logger.trace("Processing class: {}", cls);
                int modifiers = cls.getModifiers();
                if (Modifier.isInterface(modifiers) || Modifier.isAbstract(modifiers)) {
                    logger.trace("Class {} is an interface or abstract class and will not be added as a resource or provider.", cls);
                    continue;
                }
                if (ResourceMetadataCollector.isStaticResource(cls)) {
                    this.resourceRegistry.addResource(cls, priority);
                    continue;
                }
                if (ProviderMetadataCollector.isProvider(cls)) {
                    this.providersRegistry.addProvider(cls, priority, this.isSystemApplication);
                    continue;
                }
                if (!logger.isWarnEnabled()) continue;
                logger.warn(Messages.getMessage("classNotAResourceNorProvider", cls.getName()));
            }
            catch (Exception e) {
                if (logger.isErrorEnabled()) {
                    logger.error(Messages.getMessage("exceptionOccurredDuringClassProcessing", cls.getName()), e);
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug(Messages.getMessage("exceptionOccurredDuringClassProcessing", cls.getCanonicalName()), e);
            }
            catch (NoClassDefFoundError e) {
                if (logger.isErrorEnabled()) {
                    logger.error(Messages.getMessage("exceptionOccurredDuringClassProcessing", cls.getCanonicalName()), e);
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug(Messages.getMessage("exceptionOccurredDuringClassProcessing", cls.getCanonicalName()), e);
            }
        }
    }

    private void processSingletons(Set<Object> singletons, double priority) {
        for (Object obj : singletons) {
            try {
                logger.trace("Processing singleton: {}", obj);
                Class<?> cls = obj.getClass();
                if (ResourceMetadataCollector.isStaticResource(cls)) {
                    this.resourceRegistry.addResource(obj, priority);
                    continue;
                }
                if (ProviderMetadataCollector.isProvider(cls)) {
                    this.providersRegistry.addProvider(obj, priority, this.isSystemApplication);
                    continue;
                }
                if (!logger.isWarnEnabled()) continue;
                logger.warn(Messages.getMessage("classNotAResourceNorProvider", obj.getClass()));
            }
            catch (Exception e) {
                if (logger.isErrorEnabled()) {
                    logger.warn(Messages.getMessage("exceptionOccurredDuringSingletonProcessing", obj.getClass().getCanonicalName()), e);
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug(Messages.getMessage("exceptionOccurredDuringSingletonProcessing", obj.getClass().getCanonicalName()), e);
            }
            catch (NoClassDefFoundError e) {
                if (logger.isErrorEnabled()) {
                    logger.error(Messages.getMessage("exceptionOccurredDuringSingletonProcessing", obj.getClass().getCanonicalName()), e);
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug(Messages.getMessage("exceptionOccurredDuringSingletonProcessing", obj.getClass().getCanonicalName()), e);
            }
        }
    }
}

