/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.providers.entity.html;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.wink.common.internal.i18n.Messages;

class OutputStreamHttpServletResponseWrapper
extends HttpServletResponseWrapper {
    ServletOutputStreamWrapper servletOutputStreamWrapper = null;
    PrintWriter printWriter = null;
    boolean isOutputStream = false;

    public OutputStreamHttpServletResponseWrapper(HttpServletResponse response, OutputStream outputStream) {
        super(response);
        this.servletOutputStreamWrapper = new ServletOutputStreamWrapper(outputStream);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.printWriter != null) {
            throw new IllegalStateException(Messages.getMessage("cannotGetOutputStreamSinceWriterRequested"));
        }
        this.isOutputStream = true;
        return this.servletOutputStreamWrapper;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.isOutputStream) {
            throw new IllegalStateException(Messages.getMessage("writerCannotGetWriterSinceOutputStreamRequested"));
        }
        if (this.printWriter != null) {
            return this.printWriter;
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)((Object)this.servletOutputStreamWrapper), this.getCharacterEncoding());
        this.printWriter = new PrintWriter((Writer)outputStreamWriter, true);
        return this.printWriter;
    }

    void flushOutput() throws IOException {
        if (this.isOutputStream && this.servletOutputStreamWrapper != null) {
            this.servletOutputStreamWrapper.flush();
        } else if (this.printWriter != null) {
            this.printWriter.flush();
        }
    }

    public class ServletOutputStreamWrapper
    extends ServletOutputStream {
        OutputStream outputStream;

        public ServletOutputStreamWrapper(OutputStream outputStream) {
            this.outputStream = outputStream;
        }

        public void write(int value) throws IOException {
            this.outputStream.write(value);
        }
    }
}

