/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.team.connector.scm.client.TreeNode;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.wvcm.WvcmException;

public class Forest<T> {
    private final Map<T, TreeNode<T>> nodes;

    public Forest(int capacity) {
        this(capacity, null);
    }

    public Forest(int capacity, Comparator<T> c) {
        this.nodes = c == null ? new LinkedHashMap() : new TreeMap(c);
    }

    public void addLinkage(T predecessor, T item, String label, boolean isMergeParent) {
        TreeNode<T> node = this.nodes.get(item);
        TreeNode<T> parentNode = null;
        if (predecessor == null) {
            if (node == null) {
                node = new TreeNode<T>(item, label);
            }
        } else {
            parentNode = this.nodes.get(predecessor);
            if (parentNode == null) {
                parentNode = new TreeNode<T>(predecessor);
                this.nodes.put(predecessor, parentNode);
            }
            if (node == null) {
                node = new TreeNode<T>(item, label);
                node.addParent(parentNode, isMergeParent);
            } else {
                node.addParent(parentNode, isMergeParent);
                node.label = label;
            }
            parentNode.addChild(node);
        }
        node.label = label;
        this.nodes.put(item, node);
    }

    public TreeNode<T> get(T item) {
        return this.nodes.get(item);
    }

    public List<T> items() {
        ArrayList results = new ArrayList(this.nodes.size());
        Collection<TreeNode<T>> values = this.nodes.values();
        for (TreeNode<T> node : values) {
            results.add(node.item);
        }
        return results;
    }

    public List<TreeNode<T>> roots() {
        ArrayList<TreeNode<T>> results = new ArrayList<TreeNode<T>>();
        Collection<TreeNode<T>> values = this.nodes.values();
        for (TreeNode<T> node : values) {
            if (!node.predecessors.isEmpty()) continue;
            results.add(node);
        }
        return results;
    }

    public int rootCount() {
        Collection<TreeNode<T>> values = this.nodes.values();
        int result = 0;
        for (TreeNode<T> node : values) {
            if (!node.predecessors.isEmpty()) continue;
            ++result;
        }
        return result;
    }

    public void print(PrintStream stream) throws WvcmException {
        List<TreeNode<T>> roots = this.roots();
        for (TreeNode node : roots) {
            node.traverse(new PrintNodeVisitor(stream), 0);
            stream.println();
        }
    }

    public boolean parentAndChildLinkagesAreValid() {
        Collection<TreeNode<T>> values = this.nodes.values();
        for (TreeNode<T> node : values) {
            if (node.parentAndChildLinkagesAreValid()) continue;
            return false;
        }
        return true;
    }

    public void visitTreeRoots(TreeNode.ITreeNodeVisitor<T> visitor) throws WvcmException {
        List<TreeNode<T>> roots = this.roots();
        for (TreeNode<T> node : roots) {
            node.traverse(visitor, 0);
        }
    }

    public int nodeCount() {
        return this.nodes.size();
    }

    public static interface IItemPrinter<T> {
        public void printItem(PrintStream var1, T var2) throws WvcmException;
    }

    public static class PrintNodeVisitor<T>
    implements TreeNode.ITreeNodeVisitor<T> {
        private final PrintStream printStream;
        public static final String SPACE = String.valueOf(' ');
        public static final String VERTICAL_BAR = String.valueOf('|');

        private PrintNodeVisitor(PrintStream printStream) {
            this.printStream = printStream;
        }

        @Override
        public void visit(TreeNode<T> node, int depth) throws WvcmException {
            if (depth > 0) {
                this.printStream.append(VERTICAL_BAR);
                int width = 4 * depth;
                int i = 0;
                while (i < width) {
                    this.printStream.append(SPACE);
                    ++i;
                }
            }
            this.printStream.print("+----");
            this.printStream.print(node.label);
            this.printStream.println();
        }
    }
}

