/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.interop.InteropUtilities;
import com.ibm.rational.wvcm.ri.impl.SymbolicLinkVersionImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoFileItem;
import com.ibm.team.connector.scm.client.JzRepoSymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.wvcm.ControllableSymbolicLink;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.WorkspaceProvider;
import javax.wvcm.WvcmException;

public class JzRepoSymbolicLinkVersion
extends JzRepoFileItem {
    public JzRepoSymbolicLinkVersion(JzProvider provider, Location loc) {
        super(provider, loc);
    }

    @Override
    public Class<?> get_proxyClass() {
        return SymbolicLinkVersionImpl.class;
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)ControllableSymbolicLink.LINK_TARGET)) {
            IVersionableHandle myHandle = (IVersionableHandle)this.getItemHandle(feedback);
            return JzRepoSymbolicLinkVersion.getTarget(this.provider(), this.location(), myHandle, feedback);
        }
        if (propertyName.equals((Object)InteropUtilities.PN_SYMLINK_TARGET_IS_DIR)) {
            IVersionable ver = this.fetchCompleteState(feedback);
            Boolean result = ver instanceof ISymbolicLink ? Boolean.valueOf(((ISymbolicLink)ver).isDirectoryLink()) : null;
            return result;
        }
        if (propertyName.equals((Object)ControllableSymbolicLink.CHILD_MAP)) {
            HashMap result = new HashMap();
            return result;
        }
        if (propertyName.equals((Object)ControllableSymbolicLink.CHILD_LIST)) {
            ArrayList result = new ArrayList();
            return result;
        }
        if (propertyName.equals((Object)Resource.CREATION_DATE)) {
            IVersionableHandle myHandle = (IVersionableHandle)this.getItemHandle(feedback);
            return JzRepoSymbolicLinkVersion.getCreationDate(this.provider(), myHandle, feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    static Object getTarget(JzProvider p, JzLocation location, IVersionableHandle myHandle, SrvcFeedback feedback) throws WvcmException {
        String linkTargetPath;
        IVersionable ver = JzRepoSymbolicLinkVersion.fetchCompleteState(p, myHandle, feedback);
        if (ver instanceof ISymbolicLink) {
            linkTargetPath = ((ISymbolicLink)ver).getTarget();
        } else {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            JzRepoFileItem.doReadContent(out, p, myHandle, null, feedback);
            linkTargetPath = JzRepoSymbolicLink.readSymbolicLinkTarget((WorkspaceProvider)p, location, out, feedback);
        }
        return linkTargetPath;
    }

    static Object getCreationDate(JzProvider p, IVersionableHandle myHandle, SrvcFeedback feedback) throws WvcmException {
        IVersionable ver = JzRepoSymbolicLinkVersion.fetchCompleteState(p, myHandle, feedback);
        Date creationDate = ver instanceof ISymbolicLink ? ((ISymbolicLink)ver).getLinkTimestamp() : null;
        return creationDate;
    }

    private ISymbolicLink getSymbolicLink(SrvcFeedback feedback) throws WvcmException {
        this.provider().applyDeferredContentCommits(feedback);
        return (ISymbolicLink)this.fetchCompleteState(feedback);
    }

    private String getTarget(SrvcFeedback feedback) throws WvcmException {
        return this.getSymbolicLink(feedback).getTarget();
    }

    @Override
    protected boolean hasSameContent(SrvcResource otherVersion, SrvcFeedback feedback) throws WvcmException {
        boolean symbolicLinksSupported = "true".equalsIgnoreCase(this.provider().getSymlinksSupported());
        if (symbolicLinksSupported) {
            JzRepoFileItem otherFileItem = (JzRepoFileItem)otherVersion;
            String myTarget = this.getTarget(feedback);
            String otherTarget = ((ISymbolicLink)otherFileItem.fetchCompleteState(feedback)).getTarget();
            return myTarget.equals(otherTarget);
        }
        return super.hasSameContent(otherVersion, feedback);
    }
}

