/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.BaseCcComponentInfo;
import com.ibm.rational.wvcm.ct.BaseCcSubVobCompRootInfoMap;
import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CCaseObjInfo;
import com.ibm.rational.wvcm.ct.CTBaseCCView;
import com.ibm.rational.wvcm.ct.CTBranchBaseline;
import com.ibm.rational.wvcm.ct.CTInitArgUtils;
import com.ibm.rational.wvcm.ct.CTLocation;
import com.ibm.rational.wvcm.ct.CTProvider;
import com.ibm.rational.wvcm.ct.CTStream;
import com.ibm.rational.wvcm.ct.CTView;
import com.ibm.rational.wvcm.ct.Messages;
import com.ibm.rational.wvcm.ct.ObjSelUtils;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.impl.StreamImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.wvcm.Activity;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.WvcmException;
import org.eclipse.osgi.util.NLS;

public class CTBranch
extends CTStream {
    private CCaseLib cc = null;
    private CTBaseCCView.ConfigSpec configSpec = null;
    public static final String TOKEN_SEP = "_";
    private static final String BRANCH_PREFIX = "BR";
    private static final String LABEL_PREFIX = "BL";

    public CTBranch(Location location, CTProvider provider) {
        super(location, provider);
        this.cc = provider.getCCaseLib();
    }

    @Override
    public Class<?> get_proxyClass() {
        return StreamImpl.class;
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        Object propertyValue = null;
        if (propertyName.equals(CTProvider.FULLY_QUALIFIED_DISPLAY_NAME)) {
            propertyValue = this.getFQName(feedback);
        } else if (propertyName.getNamespace() != null) {
            String brtypeSelector = this.lookupBrtypeSelector();
            if (brtypeSelector != null) {
                propertyValue = this.cc.getAttr(CTBranch.getCustomAttName(propertyName), brtypeSelector, feedback);
            }
        } else {
            propertyValue = propertyName.equals((Object)Resource.DISPLAY_NAME) ? this.getDisplayName(false, feedback) : (propertyName.equals((Object)Resource.RESOURCE_IDENTIFIER) ? this.location().string() : (propertyName.equals((Object)Resource.PATHNAME_LOCATION) ? this.location() : (propertyName.equals((Object)Activity.LATEST_VERSION_LIST) ? this.doGetBaselines(feedback) : super.getThisProperty(propertyName, configuration, feedback))));
        }
        return propertyValue;
    }

    @Override
    protected String getSelectorToLock(SrvcFeedback feedback) throws WvcmException {
        return this.getBrtypeSelector();
    }

    @Override
    protected String getObjectSelectorHoldingAttr() throws WvcmException {
        return this.getBrtypeSelector();
    }

    private String getBrtypeSelector() throws WvcmException {
        String result = this.lookupBrtypeSelector();
        if (result == null) {
            throw new WvcmException(NLS.bind((String)Messages.CTBranch_ERROR_NO_BRTYPE, (Object)this.location().toString()), WvcmException.ReasonCode.FORBIDDEN);
        }
        return result;
    }

    @Override
    public void doUnbindAll(SrvcFeedback feedback) throws WvcmException {
        String brtype = this.getBrtypeSelector();
        this.cc.removeType(brtype, feedback);
        String lbtype = this.lookupLbtypeSelector();
        if (lbtype != null) {
            this.cc.removeType(lbtype, feedback);
        }
        this.flush(feedback);
    }

    @Override
    public <T extends SrvcResource> void doUpdate(List<T> sourceList, SrvcFeedback feedback) throws WvcmException {
        for (T source : sourceList) {
            if (source instanceof CTView) {
                String viewCS = ((CTView)((Object)source)).getConfigSpec(feedback);
                String[] branchCS = this.getConfigSpec(feedback);
                String[] tokens = viewCS.split("\n");
                if (tokens == null) {
                    throw new WvcmException(NLS.bind((String)Messages.CTBranch_INVALID_VIEW_CS_ERROR, (Object)viewCS), WvcmException.ReasonCode.FORBIDDEN);
                }
                int i = 0;
                while (i < tokens.length) {
                    String token = tokens[i];
                    if (branchCS.length <= i) {
                        throw new WvcmException(NLS.bind((String)Messages.CTBranch_BRANCH_CS_ERROR, (Object)token), WvcmException.ReasonCode.FORBIDDEN);
                    }
                    if (!token.equalsIgnoreCase(branchCS[i])) {
                        throw new WvcmException(NLS.bind((String)Messages.CTBranch_MISMATCH_CS_ERROR, (Object)token, (Object)branchCS[i]), WvcmException.ReasonCode.FORBIDDEN);
                    }
                    ++i;
                }
            }
            this.flush(feedback);
        }
    }

    private String getFQName(SrvcFeedback feedback) throws WvcmException {
        String brtype = "";
        String brtypeSel = this.lookupBrtypeSelector();
        if (brtypeSel == null) {
            brtypeSel = "";
        } else {
            brtype = ObjSelUtils.formatSelectorNoKind(brtypeSel);
        }
        String fqName = new String(String.valueOf(brtype) + CTProvider.BASECC_CHAR);
        String lbtype = this.lookupLbtypeSelector();
        if (lbtype != null) {
            lbtype = ObjSelUtils.formatSelectorNoKind(lbtype);
            fqName = String.valueOf(fqName) + lbtype;
        }
        return fqName;
    }

    public String getDisplayName(boolean fullName, SrvcFeedback feedback) throws WvcmException {
        String lbtype;
        String displayName = null;
        String brtype = fullName ? this.lookupBrtypeSelector() : this.lookupType(CTLocation.Kind.BRTYPE, feedback);
        String string = lbtype = fullName ? this.lookupLbtypeSelector() : this.lookupType(CTLocation.Kind.LBTYPE, feedback);
        if (brtype != null) {
            displayName = brtype;
            if (lbtype != null) {
                displayName = String.valueOf(displayName) + TOKEN_SEP + lbtype;
            }
        } else if (lbtype != null) {
            displayName = lbtype;
        } else {
            throw new WvcmException(NLS.bind((String)Messages.CTBranch_ERROR_NO_BRTYPE_OR_LBTYPE, (Object)this.location().toString()), WvcmException.ReasonCode.FORBIDDEN);
        }
        return displayName;
    }

    public String[] getConfigSpec(SrvcFeedback feedback) throws WvcmException {
        this.ensureConfigSpecInitialized(feedback);
        List<String> strings = this.configSpec.toStrings(null, feedback);
        return strings.toArray(new String[strings.size()]);
    }

    private void ensureConfigSpecInitialized(SrvcFeedback feedback) throws WvcmException {
        if (this.configSpec == null) {
            String brtype = this.lookupType(CTLocation.Kind.BRTYPE, feedback);
            String lbtype = this.lookupType(CTLocation.Kind.LBTYPE, feedback);
            String brtypeSelector = brtype == null ? null : this.lookupBrtypeSelector();
            String lbtypeSelector = lbtype == null ? null : this.lookupLbtypeSelector();
            this.configSpec = new CTBaseCCView.ConfigSpec(this.cc, brtype, lbtype, brtypeSelector, lbtypeSelector, feedback);
        }
    }

    public List<String> setBaselines(CTBaseCCView view, Map<String, CTBranchBaseline.BaselineInfo> updateBaselines, SrvcFeedback feedback) throws WvcmException {
        this.ensureConfigSpecInitialized(feedback);
        return this.configSpec.setBaselines(view, updateBaselines, feedback);
    }

    public static String getBranchPrefixForTests() {
        return BRANCH_PREFIX;
    }

    public static String getLabelPrefixForTests() {
        return LABEL_PREFIX;
    }

    public static CTBranch doCreateGeneratedResourceForTests(CTProvider provider, CTLocation location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        CCaseLib cc = provider.getCCaseLib();
        String compVobTag = CTInitArgUtils.getCompVobTag(provider.initArgs());
        String adminVobTag = cc.getAdminVobTagForTests(compVobTag, feedback);
        String branchType = cc.mkBrType(BRANCH_PREFIX, adminVobTag, feedback);
        String labelType = cc.mkLbType(LABEL_PREFIX, adminVobTag, feedback);
        CTLocation brtypeLocation = CTLocation.valueOf(CTLocation.Kind.BRTYPE, branchType);
        CTLocation lbtypeLocation = CTLocation.valueOf(CTLocation.Kind.LBTYPE, labelType);
        CTLocation branchLocation = CTLocation.createBranchLocation(brtypeLocation, lbtypeLocation);
        return new CTBranch((Location)branchLocation, provider);
    }

    private String lookupType(CTLocation.Kind kind, SrvcFeedback feedback) throws WvcmException {
        String type = null;
        CTLocation typeLocation = this.location().lookupContextLocation(kind);
        if (typeLocation != null) {
            type = this.cc.getDisplayName(typeLocation.getDisplayName(), feedback);
        }
        return type;
    }

    private String lookupTypeSelector(CTLocation.Kind kind) throws WvcmException {
        CTLocation typeLocation = this.location().lookupContextLocation(kind);
        String selector = typeLocation == null ? null : typeLocation.getDisplayName();
        return selector;
    }

    private String lookupBrtypeSelector() throws WvcmException {
        return this.lookupTypeSelector(CTLocation.Kind.BRTYPE);
    }

    private String lookupLbtypeSelector() throws WvcmException {
        return this.lookupTypeSelector(CTLocation.Kind.LBTYPE);
    }

    @Override
    public synchronized CCaseObjInfo getObjInfo(SrvcFeedback feedback) throws WvcmException {
        throw new IllegalArgumentException("getObjInfo() is not suported for CTBranch");
    }

    public List<SrvcResource> doFindAllBaseCcBaselines(String componentSelector, BaseCcComponentInfo info, SrvcFeedback feedback) throws WvcmException {
        CTLocation vobLocation = CTLocation.valueOf(CTLocation.Kind.VOBCOMPONENT, componentSelector);
        String backstopLbtypeSelector = this.lookupLbtypeSelector();
        if (backstopLbtypeSelector == null) {
            throw new WvcmException(NLS.bind((String)Messages.CTBranch_ERROR_NO_LBTYPE, (Object)this.location().toString()), WvcmException.ReasonCode.FORBIDDEN);
        }
        CTLocation lbtypeLocation = CTLocation.valueOf(CTLocation.Kind.LBTYPE, backstopLbtypeSelector);
        CTLocation blLocation = CTLocation.createBaseCCImporterBaselineLocation(lbtypeLocation, vobLocation);
        CTProvider p = this.provider();
        CTBranchBaseline backstopBaseline = (CTBranchBaseline)p.lookup((Location)blLocation, feedback);
        String vobtag = ObjSelUtils.isUniversalSelector(componentSelector) ? this.cc.computeVobTagFromVobFamilyUuid(ObjSelUtils.vobOidSubstring(componentSelector), feedback) : componentSelector;
        String viewTag = p.getTagForDefaultView();
        BaseCcSubVobCompRootInfoMap map = CTBranch.getSubVobPathMap(p, viewTag, vobtag, feedback);
        String baseCcSubVobCompName = map.lookupSubVobCompName(info);
        List<String> allbaseCcSubVobCompNames = map.getComponentNames();
        List<String> labelTypes = this.cc.getAllLabelTypes(vobtag, baseCcSubVobCompName, allbaseCcSubVobCompNames, feedback);
        ArrayList<SrvcResource> results = new ArrayList<SrvcResource>(labelTypes.size() + 1);
        results.add(backstopBaseline);
        for (String labelType : labelTypes) {
            if (labelType.equals(backstopLbtypeSelector)) continue;
            lbtypeLocation = CTLocation.valueOf(CTLocation.Kind.LBTYPE, labelType);
            blLocation = CTLocation.createBaseCCImporterBaselineLocation(lbtypeLocation, vobLocation);
            CTBranchBaseline result = (CTBranchBaseline)p.lookup((Location)blLocation, feedback);
            results.add(result);
        }
        return results;
    }
}

