/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CTControllableFolder;
import com.ibm.rational.wvcm.ct.CTLocation;
import com.ibm.rational.wvcm.ct.CTProvider;
import com.ibm.rational.wvcm.ct.Messages;
import com.ibm.rational.wvcm.interop.InteropUtilities;
import com.ibm.rational.wvcm.ri.impl.ControllableSymbolicLinkImpl;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.wvcm.ControllableSymbolicLink;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.SymbolicLinkVersion;
import javax.wvcm.WvcmException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class CTSymbolicLink
extends CTControllableFolder {
    private final CCaseLib cc;

    CTSymbolicLink(Location location, CTProvider provider) throws WvcmException {
        super(location, provider);
        this.cc = provider.getCCaseLib();
    }

    @Override
    public Class<?> get_proxyClass() {
        return ControllableSymbolicLinkImpl.class;
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)InteropUtilities.PN_SYMLINK_TARGET_IS_DIR)) {
            return this.getSymLinkTargetIsDirValue(feedback);
        }
        if (propertyName.equals((Object)ControllableSymbolicLink.LINK_TARGET)) {
            return this.getSymLinkTarget(feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    private Boolean getSymLinkTargetIsDirValue(SrvcFeedback feedback) throws WvcmException {
        String target = this.getSymLinkTarget(feedback);
        Path targetPath = new Path(target);
        if (!targetPath.isAbsolute()) {
            Path relativePath = targetPath;
            CTLocation parentLocation = this.location().parent();
            String workingDirectory = parentLocation.getDisplayName();
            targetPath = new Path(workingDirectory);
            targetPath = targetPath.append((IPath)relativePath);
        }
        File targetFile = new File(targetPath.toOSString());
        return targetFile.isDirectory();
    }

    private String getSymLinkTarget(SrvcFeedback feedback) throws WvcmException {
        String myPathname = this.getPathname(feedback);
        String target = this.cc.describeGetSLink(myPathname, feedback);
        return target;
    }

    public static CTSymbolicLink doCreateSymbolicLink(CTProvider provider, Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        CCaseLib cc = provider.getCCaseLib();
        CTControllableFolder parentFolder = new CTControllableFolder(location.parent(), provider);
        String myNewParentPathname = parentFolder.getPathname(feedback);
        String myNewPathname = String.valueOf(myNewParentPathname) + '/' + location.lastSegment();
        parentFolder.prepareToWrite(feedback);
        PropValue pval = updates.get(SymbolicLinkVersion.LINK_TARGET);
        String linkTarget = (String)pval.get_value();
        cc.symLink(linkTarget, myNewPathname, feedback);
        CTSymbolicLink result = (CTSymbolicLink)provider.lookup(location, feedback);
        updated.add(SymbolicLinkVersion.LINK_TARGET);
        return result;
    }

    @Override
    protected Map<String, SrvcResource> getChildMap(SrvcFeedback feedback) throws WvcmException {
        throw new WvcmException(NLS.bind((String)Messages.CTControllableResource_CHILD_MAP_NYI, (Object)this.location().string()), WvcmException.ReasonCode.PROPERTY_NOT_DEFINED_FOR_RESOURCE);
    }
}

