/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import com.ibm.team.repository.common.transport.TeamServiceCallContextImpl;
import com.ibm.team.repository.transport.client.InterruptableSocket2;
import com.ibm.team.repository.transport.client.LogUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import org.apache.http.HttpHost;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;

public class InterruptableSocketFactory2
extends PlainConnectionSocketFactory {
    private static final LogUtil _logger = new LogUtil(InterruptableSocketFactory2.class);

    public Socket createSocket(HttpContext context) {
        SocketChannel channel;
        _logger.debug("Entering createSocket", new Object[0]);
        try {
            channel = SocketChannel.open();
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Unexpected IOException thrown: %s", e.getMessage()));
        }
        Socket socket = channel.socket();
        _logger.debug("Created socket from channel", new Object[0]);
        return socket;
    }

    public Socket connectSocket(int connectTimeout, Socket sock, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        Socket newSock;
        _logger.debug("Entering connectSocket", new Object[0]);
        SocketChannel channel = sock.getChannel();
        if (channel == null) {
            throw new IllegalStateException("Unexpected unavailable socket channel");
        }
        channel.configureBlocking(true);
        Thread currentThread = Thread.currentThread();
        TeamServiceCallContextImpl.registerConnectingSocket((SocketChannel)channel, (Thread)currentThread);
        boolean connectionFailed = true;
        try {
            newSock = InterruptableSocket2.newInterruptableSocket(sock, channel, context);
            channel.connect(remoteAddress);
            _logger.debug("Created interruptable socket and connected", new Object[0]);
            connectionFailed = false;
        }
        finally {
            TeamServiceCallContextImpl.unregisterConnectingSocket((Thread)currentThread);
            if (connectionFailed) {
                _logger.debug("Failed connecting socket", new Object[0]);
                channel.close();
            }
        }
        return newSock;
    }
}

