/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.persistence;

import com.urbancode.persistence.IDGenerator;
import com.urbancode.persistence.IDGeneratorCryptoRandom;
import com.urbancode.persistence.IDGeneratorSeeded;
import com.urbancode.persistence.IDGeneratorSimpleRandom;
import java.util.UUID;

public class IDGeneratorSeededCrypto
extends IDGenerator
implements IDGeneratorSeeded {
    private final ThreadLocal<IDGenerator> state = new ThreadLocal<IDGenerator>(){

        @Override
        protected IDGenerator initialValue() {
            return new IDGeneratorSimpleRandom();
        }
    };

    public void setSeed(UUID seed) {
        long hi = seed.getMostSignificantBits();
        long lo = seed.getLeastSignificantBits();
        byte[] seedBytes = IDGeneratorSeededCrypto.toBytes(hi, lo);
        this.state.set(new IDGeneratorCryptoRandom(seedBytes));
    }

    public void reset() {
        this.state.remove();
    }

    public UUID newID() {
        return this.state.get().newID();
    }
}

