/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.urelease.plugin.rtc;

import com.urbancode.commons.xml.DocumentBuilderFactoryBuilder;
import com.urbancode.urelease.plugin.rtc.OslcOAuthDefaultClient;
import com.urbancode.urelease.plugin.rtc.models.OslcItem;
import com.urbancode.urelease.plugin.rtc.models.OslcProjectArea;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.oauth.OAuthException;
import org.apache.log4j.Logger;
import org.apache.wink.client.ClientResponse;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OslcXmlReader {
    private static final Logger log = Logger.getLogger(OslcXmlReader.class);
    public static final String QUERY_INTERFACE = "/oslc/queries";
    public static final String CATEGORY_INTERFACE = "/oslc/categories";
    public static final String PROJECTAREA_INTERFACE = "/oslc/projectareas";
    public static final String TIMELINE_INTERFACE = "/oslc/iterations";
    public static final String WORKITEM_TYPE_INTERFACE = "/oslc/types";
    public static final String WORKITEM_CATEGORY = "/oslc/categories";
    public static final String WORKITEM_ENUMERATION_INTERFACE = "/oslc/enumerations";
    public static final String WORKITEM_ENUMERATION_INTERFACE_SEVERITY_SUFFIX = "/severity";
    public static final String CM_QUERY = "rtc_cm:Query";
    public static final String CM_CATEGORY = "rtc_cm:Category";
    public static final String CM_PROJECTAREA = "rtc_cm:Project";
    public static final String CM_TIMELINE = "rtc_cm:Iteration";
    public static final String CM_STATUS = "rtc_cm:Status";
    public static final String CM_WORKITEM_TYPE = "rtc_cm:Type";
    public static final String CM_CHANGEREQUEST = "oslc_cm:ChangeRequest";
    public static final String CM_LITERAL = "rtc_cm:Literal";
    public static final String PARENT = "rtc_cm:com.ibm.team.workitem.linktype.parentworkitem.parent";
    public static final String SEVERITY = "oslc_cm:severity";
    public static final String RESOURCE = "rdf:resource";
    public static final String TITLE = "dc:title";
    public static final String DESCRIPTION = "dc:description";
    public static final String MODIFIED = "dc:modified";
    public static final String HIERARCHICALNAME = "rtc_cm:hierarchicalName";
    public static final String RESULT_COUNT = "oslc_cm:totalCount";
    public static final String CM_COLLECTION = "oslc_cm:Collection";
    public static final String CM_NEXT = "oslc_cm:next";
    public static final String CM_PAGE_SIZE = "oslc_cm.pageSize";
    public static final String CM_START_INDEX = "_startIndex";
    private static final String WORKFLOW_INTERFACE = "/service/com.ibm.team.workitem.service.process.internal.rest.IWorkItemConfigRestService/workflows?projectAreaItemId={projectAreaId}";
    private static final String STATUS_INTERFACE = "/oslc/workflows/{projectAreaId}/states/";
    private static final int MAX_COUNT = 100;
    private static final String PARENT_TYPE_PROPERTIES = "?oslc_cm.properties=rtc_cm:com.ibm.team.workitem.linktype.parentworkitem.parent,rtc_cm:Type";
    private static final String REQUIRED_PROPERTIES = "?oslc_cm.properties=dc:modified,rtc_cm:Type,rtc_cm:severity";
    private OslcOAuthDefaultClient client;
    private String webContextUrl;
    private OslcProjectArea projectArea;

    public OslcXmlReader(OslcOAuthDefaultClient client, String webContextUrl, OslcProjectArea projectArea) {
        this.client = client;
        this.webContextUrl = webContextUrl;
        this.projectArea = projectArea;
    }

    public List<OslcItem> getItemList(String query2, String type) throws Exception {
        return this.getItemList(query2, type, 0);
    }

    public List<OslcItem> getItemList(String query2, String type, int startIndex) throws Exception {
        String paginatedQuery = this.addPaginationParameters(query2, startIndex);
        log.debug("OSLC Query: " + paginatedQuery);
        ArrayList<OslcItem> items = new ArrayList<OslcItem>();
        Document doc = this.getDocument(paginatedQuery);
        if (doc != null) {
            NodeList typeList = doc.getElementsByTagName(type);
            for (int i = 0; i < typeList.getLength(); ++i) {
                Node node = typeList.item(i);
                Element element = (Element)node;
                NamedNodeMap catAttrMap = element.getAttributes();
                String id = null;
                String uri = null;
                String title = null;
                String description = null;
                String hierarchicalName = null;
                Node nodeURL = catAttrMap.getNamedItem(RESOURCE);
                uri = nodeURL.getNodeValue();
                id = uri.substring(uri.lastIndexOf("/") + 1, uri.length());
                title = this.getNodeValue(TITLE, element);
                description = this.getNodeValue(DESCRIPTION, element);
                hierarchicalName = this.getNodeValue(HIERARCHICALNAME, element);
                if (title == null) continue;
                OslcItem item = new OslcItem(id, uri, title, description, hierarchicalName);
                items.add(item);
            }
            log.debug(items.size() + " Items added");
            if (this.isNextPage(doc)) {
                log.debug("Next Page Available, Start=>" + startIndex);
                List<OslcItem> nextItems = this.getItemList(query2, type, startIndex += 100);
                if (!nextItems.isEmpty()) {
                    items.addAll(nextItems);
                }
            }
        }
        return items;
    }

    public List<String> getItemToUpdate(String query2, List<String> existingChangesUri, Date lastSynchronisation) throws Exception {
        ArrayList<String> itemsToUpdate = new ArrayList<String>();
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        Document doc = this.getDocument(query2 + REQUIRED_PROPERTIES, "application/xml");
        if (doc != null) {
            NodeList nodes = doc.getElementsByTagName(CM_CHANGEREQUEST);
            long lastChangedItemTime = 0L;
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                Element element = (Element)node;
                NamedNodeMap catAttrMap = element.getAttributes();
                Date lastUpdate = null;
                String uri = null;
                Node nodeURL = catAttrMap.getNamedItem(RESOURCE);
                uri = nodeURL.getNodeValue();
                String updated = this.getNodeValue(MODIFIED, element);
                lastUpdate = formater.parse(updated);
                if (lastUpdate.getTime() > lastChangedItemTime) {
                    lastChangedItemTime = lastUpdate.getTime();
                }
                if (lastSynchronisation != null) {
                    if (lastUpdate.getTime() < lastSynchronisation.getTime()) {
                        if (existingChangesUri.contains(uri)) continue;
                        itemsToUpdate.add(uri);
                        continue;
                    }
                    itemsToUpdate.add(uri);
                    continue;
                }
                itemsToUpdate.add(uri);
            }
        }
        return itemsToUpdate;
    }

    public List<String> getWorkflowsUrls(String query2) throws Exception {
        ArrayList<String> items = new ArrayList<String>();
        Document doc = this.getDocument(query2, "application/xml");
        if (doc != null) {
            NodeList nodes = doc.getElementsByTagName("workflowDefinitions");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                String url = null;
                url = this.getValue("id", element);
                if (url == null) continue;
                items.add(url);
            }
        }
        return items;
    }

    public String filterByProjectArea(String query2) {
        if (this.projectArea != null && this.projectArea.getId() != null) {
            query2 = query2 + "?oslc_cm.query=rtc_cm%3AprojectArea%3D%22" + this.projectArea.getId() + "%22";
        }
        return query2;
    }

    public String scopeToProjectArea(String query2) {
        if (this.projectArea != null && this.projectArea.getId() != null) {
            query2 = query2 + "/" + this.projectArea.getId();
        }
        return query2;
    }

    public String filterByProjectAreaAndTimeline(String query2) {
        if (this.projectArea != null && this.projectArea.getId() != null) {
            query2 = query2 + "?oslc_cm.query=rtc_cm:timeline/rtc_cm:projectArea=%22" + this.projectArea.getId() + "%22";
        }
        return query2;
    }

    public List<String> getAllStatuses() throws Exception {
        ArrayList<String> statuses = new ArrayList<String>();
        String service_url = this.webContextUrl + WORKFLOW_INTERFACE.replace("{projectAreaId}", this.projectArea.getId());
        for (String id : this.getWorkflowsUrls(service_url)) {
            String endPoint = STATUS_INTERFACE.replace("{projectAreaId}", this.projectArea.getId());
            List<OslcItem> workFlowStatuses = this.getStatuses(this.webContextUrl + endPoint + id);
            for (OslcItem item : workFlowStatuses) {
                if (statuses.contains(item.getTitle())) continue;
                statuses.add(item.getTitle());
            }
        }
        return statuses;
    }

    public List<OslcItem> getStatuses(String service_url) throws Exception {
        ArrayList<OslcItem> statuses = new ArrayList<OslcItem>();
        Document doc = this.getDocument(service_url);
        if (doc != null) {
            NodeList statusList = doc.getElementsByTagName(CM_STATUS);
            for (int i = 0; i < statusList.getLength(); ++i) {
                Node node = statusList.item(i);
                Element element = (Element)node;
                String title = null;
                title = this.getNodeValue(TITLE, element);
                if (title == null) continue;
                OslcItem status = new OslcItem(null, null, title, null, null);
                statuses.add(status);
            }
        }
        return statuses;
    }

    public OslcProjectArea getProjectAreaById(String projectId) throws Exception {
        OslcProjectArea project = null;
        String service_url = this.webContextUrl + PROJECTAREA_INTERFACE + "/" + projectId;
        Document doc = this.getDocument(service_url);
        if (doc != null) {
            NodeList projectList = doc.getElementsByTagName(CM_PROJECTAREA);
            for (int i = 0; i < projectList.getLength(); ++i) {
                Node node = projectList.item(i);
                Element element = (Element)node;
                String title = null;
                String description = null;
                title = this.getNodeValue(TITLE, element);
                description = this.getNodeValue(DESCRIPTION, element);
                if (title == null) continue;
                project = new OslcProjectArea(projectId, service_url, title, description);
            }
        }
        return project;
    }

    public String addPaginationParameters(String query2, int start) {
        query2 = query2.contains("?") ? query2 + "&oslc_cm.pageSize=100&_startIndex=" + start : query2 + "?oslc_cm.pageSize=100&_startIndex=" + start;
        return query2;
    }

    public boolean isNextPage(Document doc) {
        boolean next = false;
        if (doc != null) {
            NodeList typeList = doc.getElementsByTagName(CM_COLLECTION);
            for (int i = 0; i < typeList.getLength(); ++i) {
                Node node = typeList.item(i);
                Element element = (Element)node;
                NamedNodeMap catAttrMap = element.getAttributes();
                Node nodeURL = catAttrMap.getNamedItem(CM_NEXT);
                if (nodeURL == null) continue;
                next = true;
            }
        }
        return next;
    }

    public Document getDocument(String query2) throws Exception {
        Document doc = null;
        ClientResponse response = this.client.getResource(query2, "application/xml", "1.0");
        log.debug(query2 + " Status: " + response.getStatusCode());
        String xml = "";
        xml = OslcXmlReader.processRawResponse(response);
        ByteArrayInputStream byteArray = new ByteArrayInputStream(xml.toString().getBytes());
        DocumentBuilderFactory domFactory = DocumentBuilderFactoryBuilder.newBuilder().newDocumentBuilderFactory();
        domFactory.setNamespaceAware(true);
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        try {
            doc = builder.parse(byteArray);
        }
        catch (Exception ex) {
            throw new RuntimeException(xml, ex);
        }
        return doc;
    }

    public Document getDocument(String query2, String format) throws Exception {
        Document doc = null;
        ClientResponse response = this.client.getResource(query2, format, "1.0");
        log.debug(query2 + " format: " + format + " Status: " + response.getStatusCode());
        InputStreamReader reader = new InputStreamReader(response.getEntity(InputStream.class), "UTF-8");
        InputSource is = new InputSource(reader);
        is.setEncoding("UTF-8");
        DocumentBuilderFactory dbFactory = DocumentBuilderFactoryBuilder.newBuilder().newDocumentBuilderFactory();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        doc = dBuilder.parse(is);
        doc.getDocumentElement().normalize();
        return doc;
    }

    private static String processRawResponse(ClientResponse response) throws IOException {
        InputStream is = response.getEntity(InputStream.class);
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        String line = null;
        String xml = "";
        while ((line = in.readLine()) != null) {
            xml = xml + line;
        }
        response.consumeContent();
        return xml;
    }

    public int getResultCount(Document document) {
        int count = 0;
        NodeList nodeList = document.getChildNodes();
        Node firstNode = nodeList.item(0);
        Element countElement = (Element)firstNode;
        NamedNodeMap attributeMap = countElement.getAttributes();
        Node countNode = attributeMap.getNamedItem(RESULT_COUNT);
        count = Integer.valueOf(countNode.getNodeValue());
        return count;
    }

    private String getValue(String tag, Element element) {
        NodeList nodes = element.getElementsByTagName(tag).item(0).getChildNodes();
        Node node = nodes.item(0);
        return node.getNodeValue();
    }

    public String getNodeValue(String name, Element element) {
        String value = null;
        NodeList nodeList = element.getElementsByTagName(name);
        Element nodeElement = (Element)nodeList.item(0);
        if (nodeElement != null && nodeElement.getFirstChild() != null && nodeElement.getFirstChild().getNodeValue() != null) {
            value = nodeElement.getFirstChild().getNodeValue();
        }
        return value;
    }

    public JSONArray getWorkItemHierarchyJson(String query2) throws IOException, OAuthException, URISyntaxException, JSONException {
        ClientResponse response = this.client.getResource(query2 + PARENT_TYPE_PROPERTIES, "application/json", "1.0");
        String json = OslcXmlReader.processRawResponse(response);
        JSONArray results = null;
        try {
            JSONObject resultsObject = new JSONObject(json);
            results = resultsObject.has("oslc_cm:results") ? resultsObject.getJSONArray("oslc_cm:results") : resultsObject.getJSONArray(json);
        }
        catch (JSONException ex) {
            results = new JSONArray(json);
        }
        return results;
    }
}

