/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.wink.common.RestException;
import org.apache.wink.common.RuntimeContext;
import org.apache.wink.common.WinkApplication;
import org.apache.wink.common.internal.MultivaluedMapImpl;
import org.apache.wink.common.internal.application.ApplicationFileLoader;
import org.apache.wink.common.internal.application.ApplicationValidator;
import org.apache.wink.common.internal.contexts.ProvidersImpl;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.lifecycle.LifecycleManagersRegistry;
import org.apache.wink.common.internal.lifecycle.ScopeLifecycleManager;
import org.apache.wink.common.internal.model.AtomXhtml;
import org.apache.wink.common.internal.model.XmlWrapper;
import org.apache.wink.common.internal.registry.ProvidersRegistry;
import org.apache.wink.common.internal.registry.metadata.ProviderMetadataCollector;
import org.apache.wink.common.internal.runtime.AbstractRuntimeContext;
import org.apache.wink.common.internal.runtime.RuntimeContextTLS;
import org.apache.wink.common.internal.utils.UnmodifiableMultivaluedMap;
import org.apache.wink.common.model.atom.AtomContent;
import org.apache.wink.common.model.atom.AtomText;
import org.apache.wink.common.model.atom.AtomTextType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUtils {
    public static final MultivaluedMap<String, Object> EMPTY_OBJECT_MAP = new UnmodifiableMultivaluedMap<String, Object>(new MultivaluedMapImpl());
    public static final MultivaluedMap<String, String> EMPTY_STRING_MAP = new UnmodifiableMultivaluedMap<String, String>(new MultivaluedMapImpl());
    public static final Annotation[] EMPTY_ARRAY = new Annotation[0];
    private static final SAXParserFactory spf;
    private static final DatatypeFactory datatypeFactory;
    private static final Logger logger;

    public static boolean isTypeXml(String type) {
        int index = type.indexOf(59);
        if (index > -1) {
            type = type.substring(0, index).trim();
        }
        return (type = type.toLowerCase()).endsWith("/xml") || type.endsWith("+xml") || type.equals("xhtml") || type.equals("text/xml-external-parsed-entity") || type.equals("application/xml-external-parsed-entity") || type.equals("application/xml-dtd");
    }

    public static boolean isValueActuallyXml(Object source) {
        AtomText text;
        AtomContent content;
        String type;
        return source instanceof AtomContent ? ModelUtils.isTypeXml(type = (content = (AtomContent)source).getType()) : source instanceof AtomText && (type = (text = (AtomText)source).getType()) == AtomTextType.xhtml;
    }

    public static void saxParse(Reader reader, ContentHandler handler, String errorMessage) {
        try {
            XMLReader xmlReader = spf.newSAXParser().getXMLReader();
            xmlReader.setContentHandler(handler);
            if (handler instanceof LexicalHandler) {
                xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            }
            xmlReader.parse(new InputSource(reader));
        }
        catch (SAXException e) {
            logger.error(errorMessage);
            throw new WebApplicationException(e);
        }
        catch (ParserConfigurationException e) {
            logger.error(errorMessage);
            throw new WebApplicationException(e);
        }
        catch (IOException e) {
            logger.error(errorMessage);
            throw new WebApplicationException(e);
        }
    }

    public static Object unmarshal(Unmarshaller unmarshaller, Reader reader) throws IOException {
        Object result = null;
        try {
            result = unmarshaller.unmarshal(reader);
            if (result instanceof JAXBElement) {
                result = ((JAXBElement)result).getValue();
            }
        }
        catch (IllegalStateException e) {
            throw new WebApplicationException(e);
        }
        catch (JAXBException e) {
            throw new WebApplicationException(e);
        }
        return result;
    }

    public static void marshal(Marshaller marshaller, Object jaxbObject, OutputStream os) throws IOException {
        try {
            marshaller.marshal(jaxbObject, os);
        }
        catch (JAXBException e) {
            throw new WebApplicationException(e);
        }
    }

    public static XMLGregorianCalendar timeToXmlGregorianCalendar(long time) {
        if (time == -1L) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(time);
        XMLGregorianCalendar xmlGregCal = datatypeFactory.newXMLGregorianCalendar(calendar);
        return xmlGregCal;
    }

    public static long xmlGregorianCalendarToTime(XMLGregorianCalendar xmlGregCal) {
        if (xmlGregCal == null) {
            return -1L;
        }
        GregorianCalendar calendar = xmlGregCal.toGregorianCalendar();
        long time = calendar.getTimeInMillis();
        return time;
    }

    public static <T> T readValue(List<Object> list, Class<T> type, Providers providers, Type genericType, Annotation[] annotations, MultivaluedMap<String, String> httpHeaders, MediaType mediaType) throws IOException {
        if (list == null || list.isEmpty()) {
            return null;
        }
        Object value = list.get(0);
        if (value == null) {
            return null;
        }
        Class<?> cls = value.getClass();
        if (type.isAssignableFrom(cls)) {
            return (T)value;
        }
        if (value instanceof JAXBElement) {
            value = ((JAXBElement)value).getValue();
            return ModelUtils.readValue(Arrays.asList(value), type, providers, genericType, annotations, httpHeaders, mediaType);
        }
        if (cls == AtomXhtml.class) {
            return ModelUtils.readValue(((AtomXhtml)value).getAny(), type, providers, genericType, annotations, httpHeaders, mediaType);
        }
        if (cls == XmlWrapper.class) {
            value = ((XmlWrapper)value).getValue();
            return ModelUtils.readValue(Arrays.asList(value), type, providers, genericType, annotations, httpHeaders, mediaType);
        }
        if (value instanceof byte[]) {
            MessageBodyReader<T> reader;
            RuntimeContext tempRuntimeContext;
            if (providers == null) {
                RuntimeContext runtimeContext = RuntimeContextTLS.getRuntimeContext();
                if (runtimeContext != null) {
                    providers = runtimeContext.getProviders();
                }
                if (providers == null) {
                    LifecycleManagersRegistry ofFactoryRegistry = new LifecycleManagersRegistry();
                    ofFactoryRegistry.addFactoryFactory(new ScopeLifecycleManager());
                    ProvidersRegistry providersRegistry = new ProvidersRegistry(ofFactoryRegistry, new ApplicationValidator());
                    final Set<Class<?>> classes = new ApplicationFileLoader(true).getClasses();
                    ModelUtils.processApplication(providersRegistry, new WinkApplication(){

                        @Override
                        public Set<Class<?>> getClasses() {
                            return classes;
                        }

                        @Override
                        public double getPriority() {
                            return 0.1;
                        }
                    });
                    providers = new ProvidersImpl(providersRegistry, runtimeContext);
                }
            }
            if ((tempRuntimeContext = RuntimeContextTLS.getRuntimeContext()) == null) {
                final Providers p = providers;
                RuntimeContextTLS.setRuntimeContext(new AbstractRuntimeContext(){
                    {
                        this.setAttribute(Providers.class, p);
                    }

                    public OutputStream getOutputStream() throws IOException {
                        return null;
                    }

                    public InputStream getInputStream() throws IOException {
                        return null;
                    }
                });
            }
            if ((reader = providers.getMessageBodyReader(type, type, EMPTY_ARRAY, mediaType)) == null) {
                throw new WebApplicationException(Response.Status.UNSUPPORTED_MEDIA_TYPE);
            }
            T read = reader.readFrom(type, type, annotations, mediaType, httpHeaders, new ByteArrayInputStream((byte[])value));
            RuntimeContextTLS.setRuntimeContext(tempRuntimeContext);
            return read;
        }
        throw new ClassCastException(Messages.getMessage("cannotCastTo", value.getClass().getName(), type.getName()));
    }

    public static MediaType determineMediaType(String type) {
        MediaType mediaType = type == null || type.equals("text") || type.equals("html") ? MediaType.TEXT_PLAIN_TYPE : (type.equals("xhtml") ? MediaType.APPLICATION_XML_TYPE : MediaType.valueOf(type));
        return mediaType;
    }

    public static void fixAnyContent(List<Object> any, String type) {
        if (any == null || any.isEmpty()) {
            return;
        }
        Object value = any.get(0);
        if (type == null) {
            type = AtomTextType.text.name();
        }
        if (value instanceof XmlWrapper) {
            XmlWrapper xmlWrapper = (XmlWrapper)value;
            if (xmlWrapper.getType() == null) {
                xmlWrapper.setType(type);
            }
        } else if (value.getClass() != String.class || ModelUtils.isTypeXml(type)) {
            for (Object anyValue : any) {
                if (anyValue instanceof JAXBElement) {
                    value = anyValue;
                    break;
                }
                if (!(anyValue instanceof XmlWrapper)) continue;
                XmlWrapper xmlWrapper = (XmlWrapper)anyValue;
                if (xmlWrapper.getType() == null) {
                    xmlWrapper.setType(type);
                }
                any.clear();
                any.add(0, xmlWrapper);
                return;
            }
            any.set(0, new XmlWrapper(value, type));
        }
    }

    private static void processApplication(ProvidersRegistry providersRegistry, Application application) {
        Set<Class<?>> classes;
        if (application == null) {
            return;
        }
        Set<Object> singletons = application.getSingletons();
        if (singletons != null && singletons.size() > 0) {
            ModelUtils.processSingletons(providersRegistry, singletons);
        }
        if ((classes = application.getClasses()) != null && classes.size() > 0) {
            ModelUtils.processClasses(providersRegistry, classes);
        }
        if (application instanceof WinkApplication) {
            ModelUtils.processWinkApplication(providersRegistry, (WinkApplication)application);
        }
    }

    private static void processClasses(ProvidersRegistry providersRegistry, Set<Class<?>> classes) {
        for (Class<?> cls : classes) {
            if (ProviderMetadataCollector.isProvider(cls)) {
                providersRegistry.addProvider(cls);
                continue;
            }
            if (!logger.isWarnEnabled()) continue;
            logger.warn(Messages.getMessage("classNotAProvider", cls));
        }
    }

    private static void processSingletons(ProvidersRegistry providersRegistry, Set<Object> singletons) {
        for (Object obj : singletons) {
            Class<?> cls = obj.getClass();
            if (ProviderMetadataCollector.isProvider(cls)) {
                providersRegistry.addProvider(obj);
                continue;
            }
            if (!logger.isWarnEnabled()) continue;
            logger.warn(Messages.getMessage("classNotAProvider", obj.getClass()));
        }
    }

    private static void processWinkApplication(ProvidersRegistry providersRegistry, WinkApplication sApplication) {
        Set<Object> instances = sApplication.getInstances();
        double priority = sApplication.getPriority();
        if (instances == null) {
            return;
        }
        for (Object obj : instances) {
            Class<?> cls = obj.getClass();
            if (ProviderMetadataCollector.isProvider(cls)) {
                providersRegistry.addProvider(obj, priority);
                continue;
            }
            if (!logger.isWarnEnabled()) continue;
            logger.warn(Messages.getMessage("classNotAProvider", obj.getClass()));
        }
    }

    static {
        logger = LoggerFactory.getLogger(ModelUtils.class);
        try {
            spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            spf.setValidating(false);
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (Exception e) {
            throw new RestException(Messages.getMessage("errorSettingUpAtom", e));
        }
    }
}

