/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.buildablesubset.client;

import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.enterprise.buildablesubset.client.IBuildableSubsetClient;
import com.ibm.team.enterprise.buildablesubset.common.BuildSubsetRuleParserFactory;
import com.ibm.team.enterprise.buildablesubset.common.BuildableSubsetQuery;
import com.ibm.team.enterprise.buildablesubset.common.IBuildSubsetBinaryOperator;
import com.ibm.team.enterprise.buildablesubset.common.IBuildSubsetRule;
import com.ibm.team.enterprise.buildablesubset.common.IBuildableSubset;
import com.ibm.team.enterprise.buildablesubset.common.IBuildableSubsetHandle;
import com.ibm.team.enterprise.buildablesubset.common.IBuildableSubsetService;
import com.ibm.team.enterprise.buildablesubset.common.impl.BuildableSubsetHandle;
import com.ibm.team.enterprise.buildablesubset.common.util.BuildableSubsetParser;
import com.ibm.team.enterprise.buildablesubset.common.util.BuildableSubsetSerializer;
import com.ibm.team.enterprise.buildablesubset.common.util.BuildableSubsetUtil;
import com.ibm.team.enterprise.internal.buildablesubset.client.nls.Messages;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResultFeedParser;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.ProcessRunnable;
import com.ibm.team.process.internal.client.ProcessClientService;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class BuildableSubsetClient
extends EventSource
implements IBuildableSubsetClient {
    private IClientLibraryContext fContext;

    public BuildableSubsetClient(IClientLibraryContext context) {
        this.fContext = context;
    }

    protected IClientLibraryContext getContext() {
        return this.fContext;
    }

    protected ITeamRepository getRepository() {
        return this.fContext.teamRepository();
    }

    protected <T> T getService(Class<T> clazz) {
        return (T)this.getContext().getServiceInterface(clazz);
    }

    protected Object callCancelableService(IProgressMonitor progressMonitor, IClientLibraryContext.IServiceRunnable serviceRunnable) throws TeamRepositoryException {
        return this.getContext().callCancelableService(serviceRunnable, progressMonitor);
    }

    @Override
    public String createBuildableSubset(IBuildableSubset buildableSubset) throws TeamRepositoryException {
        return this.createBuildableSubsetInternal(buildableSubset, Messages.BuildableSubsetsClient_CREATE_SUBSET_OPERATION_NAME, null);
    }

    private String createBuildableSubsetInternal(final IBuildableSubset buildableSubset, final String operationId, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        return (String)this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                class CreateSubsetRunnable
                extends ProcessRunnable {
                    public String fCreateTimestamp;
                    private final /* synthetic */ IBuildableSubset val$buildableSubset;

                    CreateSubsetRunnable(IBuildableSubset iBuildableSubset) {
                        this.val$buildableSubset = iBuildableSubset;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        this.fCreateTimestamp = BuildableSubsetClient.this.getService(IBuildableSubsetService.class).createBuildableSubset(this.val$buildableSubset.getNewStorageRepresentation(BuildableSubsetClient.this.getRepository().getRepositoryURI()));
                        return null;
                    }
                }
                CreateSubsetRunnable runnable = new CreateSubsetRunnable(buildableSubset);
                IProcessClientService processService = (IProcessClientService)BuildableSubsetClient.this.getRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, operationId, monitor);
                return runnable.fCreateTimestamp;
            }
        });
    }

    private void checkOwnership(String buildableSubsetSlug) throws TeamRepositoryException {
        String ownerID;
        IBuildableSubset persistedSubset = this.getBuildableSubset(buildableSubsetSlug);
        if (persistedSubset != null && (ownerID = persistedSubset.getOwnerID()) != null) {
            IContributorHandle ownerHandle = (IContributorHandle)IContributor.ITEM_TYPE.createItemHandle(UUID.valueOf((String)ownerID), null);
            IContributor owner = (IContributor)this.getContext().teamRepository().itemManager().fetchCompleteItem((IItemHandle)ownerHandle, 0, null);
            String ownerId = owner.getUserId();
            String userId = this.getContext().teamRepository().getUserId();
            if (!userId.equals(ownerId) && !this.isUserJazzAdmin()) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.BuildableSubsetsClient_ONLY_OWNER_CAN_UPDATE_PERSONAL_SUBSETS, null));
            }
        }
    }

    private boolean isUserJazzAdmin() {
        try {
            ProcessClientService processClient = (ProcessClientService)this.getContext().teamRepository().getClientLibrary(IProcessItemService.class);
            return processClient.assertPermission("JazzAdmins", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void createOldBuildableSubset(final IBuildableSubset buildableSubset) throws TeamRepositoryException {
        this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                BuildableSubsetClient.this.getService(IBuildableSubsetService.class).createOldBuildableSubset(buildableSubset.getStorageRepresentation(BuildableSubsetClient.this.getRepository().getRepositoryURI()));
                return buildableSubset;
            }
        });
    }

    @Override
    public String deleteBuildableSubset(String buildableSubsetSlug) throws TeamRepositoryException {
        return this.internalDelete(buildableSubsetSlug, Messages.BuildableSubsetsClient_DELETE_SUBSET_OPERATION_NAME, null);
    }

    private String internalDelete(final String buildableSubsetSlug, final String operationId, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        return (String)this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                class DeleteSubsetRunnable
                extends ProcessRunnable {
                    public String fDeleteTimestamp;
                    private final /* synthetic */ String val$buildableSubsetSlug;

                    DeleteSubsetRunnable(String string) {
                        this.val$buildableSubsetSlug = string;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        BuildableSubsetClient.this.checkOwnership(this.val$buildableSubsetSlug);
                        this.fDeleteTimestamp = BuildableSubsetClient.this.getService(IBuildableSubsetService.class).deleteBuildableSubset(this.val$buildableSubsetSlug);
                        return null;
                    }
                }
                DeleteSubsetRunnable runnable = new DeleteSubsetRunnable(buildableSubsetSlug);
                IProcessClientService processService = (IProcessClientService)BuildableSubsetClient.this.getRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, operationId, monitor);
                return runnable.fDeleteTimestamp;
            }
        });
    }

    @Override
    public IBuildableSubset getBuildableSubset(final String buildableSubsetSlug) throws TeamRepositoryException {
        return (IBuildableSubset)this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                String buildableSubsetXML = BuildableSubsetClient.this.getService(IBuildableSubsetService.class).getBuildableSubset(buildableSubsetSlug);
                if (buildableSubsetXML != null && buildableSubsetXML.length() > 0) {
                    try {
                        BuildableSubsetParser parser = new BuildableSubsetParser();
                        return parser.parse(buildableSubsetXML);
                    }
                    catch (Exception e) {
                        throw new TeamRepositoryException("An error occurred parsing the buildable subset XML.", (Throwable)e);
                    }
                }
                return null;
            }
        });
    }

    @Override
    public IBuildableSubset getBuildableSubset2(final String buildableSubsetSlug, final boolean evaluateDynamicCriteria) throws TeamRepositoryException {
        return (IBuildableSubset)this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                String buildableSubsetXML = BuildableSubsetClient.this.getService(IBuildableSubsetService.class).getBuildableSubset2(buildableSubsetSlug, evaluateDynamicCriteria);
                if (buildableSubsetXML != null && buildableSubsetXML.length() > 0) {
                    try {
                        BuildableSubsetParser parser = new BuildableSubsetParser();
                        return parser.parse(buildableSubsetXML);
                    }
                    catch (Exception e) {
                        throw new TeamRepositoryException("An error occurred parsing the buildable subset XML.", (Throwable)e);
                    }
                }
                return null;
            }
        });
    }

    @Override
    public JSONObject getBuildableSubsetHandle(final String buildableSubsetSlug) throws TeamRepositoryException {
        return (JSONObject)this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                String jsonValue = BuildableSubsetClient.this.getService(IBuildableSubsetService.class).getBuildableSubsetHandle(buildableSubsetSlug);
                if (jsonValue == null || jsonValue.isEmpty()) {
                    throw new TeamRepositoryException(NLS.bind((String)Messages.BuildableSubsetsClient_SUBSET_DOES_NOT_EXIST, (Object)buildableSubsetSlug));
                }
                try {
                    return JSONObject.parse((Reader)new StringReader(jsonValue));
                }
                catch (Exception e) {
                    throw new TeamRepositoryException("An error occurred parsing the buildable subset XML.", (Throwable)e);
                }
            }
        });
    }

    @Override
    @Deprecated
    public void updateBuildableSubset(String buildableSubsetSlug, IBuildableSubset buildableSubset) throws TeamRepositoryException {
        this.updateBuildableSubsetInternal(buildableSubsetSlug, buildableSubset, Messages.BuildableSubsetsClient_SAVE_SUBSET_OPERATION_NAME, null);
    }

    private void updateBuildableSubsetInternal(final String buildableSubsetSlug, final IBuildableSubset buildableSubset, final String operationId, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                class UpdateSubsetRunnable
                extends ProcessRunnable {
                    private final /* synthetic */ String val$buildableSubsetSlug;
                    private final /* synthetic */ IBuildableSubset val$buildableSubset;

                    UpdateSubsetRunnable(String string, IBuildableSubset iBuildableSubset) {
                        this.val$buildableSubsetSlug = string;
                        this.val$buildableSubset = iBuildableSubset;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        BuildableSubsetClient.this.checkOwnership(this.val$buildableSubsetSlug);
                        BuildableSubsetClient.this.getService(IBuildableSubsetService.class).updateBuildableSubset(this.val$buildableSubsetSlug, this.val$buildableSubset.getNewStorageRepresentation(BuildableSubsetClient.this.getRepository().getRepositoryURI()));
                        return null;
                    }
                }
                UpdateSubsetRunnable runnable = new UpdateSubsetRunnable(buildableSubsetSlug, buildableSubset);
                IProcessClientService processService = (IProcessClientService)BuildableSubsetClient.this.getRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, operationId, monitor);
                return null;
            }
        });
    }

    @Override
    public String modifyBuildableSubset(String previousSubsetSlug, IBuildableSubset buildableSubset) throws TeamRepositoryException {
        return this.modifyBuildableSubsetInternal(previousSubsetSlug, buildableSubset, Messages.BuildableSubsetsClient_SAVE_SUBSET_OPERATION_NAME, null);
    }

    private String modifyBuildableSubsetInternal(final String previousSubsetSlug, final IBuildableSubset buildableSubset, final String operationId, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        return (String)this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                class UpdateSubsetRunnable
                extends ProcessRunnable {
                    public String fModifyTimestamp;
                    private final /* synthetic */ String val$previousSubsetSlug;
                    private final /* synthetic */ IBuildableSubset val$buildableSubset;

                    UpdateSubsetRunnable(String string, IBuildableSubset iBuildableSubset) {
                        this.val$previousSubsetSlug = string;
                        this.val$buildableSubset = iBuildableSubset;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        BuildableSubsetClient.this.checkOwnership(this.val$previousSubsetSlug);
                        this.fModifyTimestamp = BuildableSubsetClient.this.getService(IBuildableSubsetService.class).modifyBuildableSubset(this.val$previousSubsetSlug, this.val$buildableSubset.getNewStorageRepresentation(BuildableSubsetClient.this.getRepository().getRepositoryURI()));
                        return null;
                    }
                }
                UpdateSubsetRunnable runnable = new UpdateSubsetRunnable(previousSubsetSlug, buildableSubset);
                IProcessClientService processService = (IProcessClientService)BuildableSubsetClient.this.getRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, operationId, monitor);
                return runnable.fModifyTimestamp;
            }
        });
    }

    @Override
    public String runSelectQuery(String sparql) throws TeamRepositoryException {
        return this.runSelectQuery(sparql, null);
    }

    @Override
    public String runSelectQuery(final String sparql, final String ifModifiedSince) throws TeamRepositoryException {
        return (String)this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                String results = BuildableSubsetClient.this.getService(IBuildableSubsetService.class).runSelectQueryWithTimestamp(sparql, ifModifiedSince);
                return results;
            }
        });
    }

    @Override
    public IBuildableSubset processRules(final IBuildSubsetRule leftRule, final IBuildSubsetRule rightRule, final IBuildSubsetBinaryOperator operator, final IBuildDefinitionHandle buildDefinitionHandle) throws TeamRepositoryException {
        return (IBuildableSubset)this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

            public IBuildableSubset run(IProgressMonitor monitor) throws TeamRepositoryException {
                String leftRuleContent = BuildSubsetRuleParserFactory.getInstance().getParser(leftRule).toJSON(leftRule);
                String rightRuleContent = BuildSubsetRuleParserFactory.getInstance().getParser(rightRule).toJSON(rightRule);
                String subsetContent = BuildableSubsetClient.this.getService(IBuildableSubsetService.class).processRules2(leftRuleContent, rightRuleContent, operator.name(), buildDefinitionHandle);
                try {
                    return (IBuildableSubset)new BuildableSubsetParser().parse(subsetContent);
                }
                catch (Exception e) {
                    throw new TeamRepositoryException((Throwable)e);
                }
            }
        });
    }

    @Override
    public IBuildableSubset processRules(final IBuildSubsetRule leftRule, final IBuildSubsetRule rightRule, final IBuildSubsetBinaryOperator operator, final IWorkspaceHandle workspaceHandle) throws TeamRepositoryException {
        return (IBuildableSubset)this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

            public IBuildableSubset run(IProgressMonitor monitor) throws TeamRepositoryException {
                String leftRuleContent = BuildSubsetRuleParserFactory.getInstance().getParser(leftRule).toJSON(leftRule);
                String rightRuleContent = BuildSubsetRuleParserFactory.getInstance().getParser(rightRule).toJSON(rightRule);
                String subsetContent = BuildableSubsetClient.this.getService(IBuildableSubsetService.class).processRules(leftRuleContent, rightRuleContent, operator.name(), workspaceHandle);
                try {
                    return (IBuildableSubset)new BuildableSubsetParser().parse(subsetContent);
                }
                catch (Exception e) {
                    throw new TeamRepositoryException((Throwable)e);
                }
            }
        });
    }

    @Override
    public IBuildableSubset processRule(final IBuildSubsetRule rule, final IWorkspaceHandle workspaceHandle) throws TeamRepositoryException {
        return (IBuildableSubset)this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

            public IBuildableSubset run(IProgressMonitor monitor) throws TeamRepositoryException {
                String ruleContent = BuildSubsetRuleParserFactory.getInstance().getParser(rule).toJSON(rule);
                String subsetContent = BuildableSubsetClient.this.getService(IBuildableSubsetService.class).processRule(ruleContent, workspaceHandle);
                try {
                    return (IBuildableSubset)new BuildableSubsetParser().parse(subsetContent);
                }
                catch (Exception e) {
                    throw new TeamRepositoryException((Throwable)e);
                }
            }
        });
    }

    @Override
    public IBuildableSubset processRule(final IBuildSubsetRule rule, final IBuildDefinitionHandle buildDefinitionHandle) throws TeamRepositoryException {
        return (IBuildableSubset)this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

            public IBuildableSubset run(IProgressMonitor monitor) throws TeamRepositoryException {
                String ruleContent = BuildSubsetRuleParserFactory.getInstance().getParser(rule).toJSON(rule);
                String subsetContent = BuildableSubsetClient.this.getService(IBuildableSubsetService.class).processRule2(ruleContent, buildDefinitionHandle);
                try {
                    return (IBuildableSubset)new BuildableSubsetParser().parse(subsetContent);
                }
                catch (Exception e) {
                    throw new TeamRepositoryException((Throwable)e);
                }
            }
        });
    }

    @Override
    public IBuildableSubset processRule(final IBuildSubsetRule rule, final IBuildDefinitionHandle buildDefinitionHandle, final boolean includeImpacts) throws TeamRepositoryException {
        return (IBuildableSubset)this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

            public IBuildableSubset run(IProgressMonitor monitor) throws TeamRepositoryException {
                String ruleContent = BuildSubsetRuleParserFactory.getInstance().getParser(rule).toJSON(rule);
                String subsetContent = BuildableSubsetClient.this.getService(IBuildableSubsetService.class).processRule3(ruleContent, buildDefinitionHandle, includeImpacts);
                try {
                    return (IBuildableSubset)new BuildableSubsetParser().parse(subsetContent);
                }
                catch (Exception e) {
                    throw new TeamRepositoryException((Throwable)e);
                }
            }
        });
    }

    @Override
    public IBuildableSubset evaluateSubset(final IBuildableSubset buildableSubset) throws TeamRepositoryException {
        return (IBuildableSubset)this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

            public IBuildableSubset run(IProgressMonitor monitor) throws TeamRepositoryException {
                String subsetContent = BuildableSubsetSerializer.serializeSubset((IBuildableSubset)buildableSubset, (String)BuildableSubsetClient.this.getRepository().getRepositoryURI(), (boolean)false);
                subsetContent = BuildableSubsetClient.this.getService(IBuildableSubsetService.class).evaluateSubset(subsetContent);
                try {
                    return (IBuildableSubset)new BuildableSubsetParser().parse(subsetContent);
                }
                catch (Exception e) {
                    throw new TeamRepositoryException((Throwable)e);
                }
            }
        });
    }

    @Override
    public IBuildableSubset getBuildableSubset(final String buildableSubsetLabel, final String buildDefinitionUUID) throws TeamRepositoryException {
        return (IBuildableSubset)this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                String slug = BuildableSubsetUtil.getSlug((String)buildableSubsetLabel, (String)buildDefinitionUUID);
                String buildableSubsetXML = BuildableSubsetClient.this.getService(IBuildableSubsetService.class).getBuildableSubset(slug);
                if (buildableSubsetXML != null && buildableSubsetXML.length() > 0) {
                    try {
                        BuildableSubsetParser parser = new BuildableSubsetParser();
                        return parser.parse(buildableSubsetXML);
                    }
                    catch (Exception e) {
                        throw new TeamRepositoryException("An error occurred parsing the buildable subset XML.", (Throwable)e);
                    }
                }
                return null;
            }
        });
    }

    @Override
    public IBuildableSubset getOldBuildableSubset(final String buildableSubsetLabel, final String buildDefinitionUUID) throws TeamRepositoryException {
        return (IBuildableSubset)this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                String slug = BuildableSubsetUtil.getOldSlug((String)buildableSubsetLabel, (String)buildDefinitionUUID);
                String buildableSubsetXML = BuildableSubsetClient.this.getService(IBuildableSubsetService.class).getBuildableSubset(slug);
                if (buildableSubsetXML != null && buildableSubsetXML.length() > 0) {
                    try {
                        BuildableSubsetParser parser = new BuildableSubsetParser();
                        return parser.parse(buildableSubsetXML);
                    }
                    catch (Exception e) {
                        throw new TeamRepositoryException("An error occurred parsing the buildable subset XML.", (Throwable)e);
                    }
                }
                return null;
            }
        });
    }

    @Override
    @Deprecated
    public List<IBuildableSubsetHandle> getAllBuildableSubsets(IBuildDefinitionHandle buildDefinitionHandle) throws TeamRepositoryException {
        return this.getAllBuildableSubsets(buildDefinitionHandle, null, null);
    }

    @Override
    public List<IBuildableSubsetHandle> getAllBuildableSubsets(IBuildDefinitionHandle buildDefinitionHandle, String ownerId) throws TeamRepositoryException {
        return this.getAllBuildableSubsets(buildDefinitionHandle, ownerId, null);
    }

    @Override
    public List<IBuildableSubsetHandle> getAllBuildableSubsets(IBuildDefinitionHandle buildDefinitionHandle, String ownerId, String ifModifiedSince) throws TeamRepositoryException {
        String query = ownerId != null ? BuildableSubsetQuery.getBuildableSubsetHandlesQuery((String)buildDefinitionHandle.getItemId().getUuidValue(), (String)ownerId) : BuildableSubsetQuery.getBuildableSubsetHandlesQuery((String)buildDefinitionHandle.getItemId().getUuidValue());
        String results = this.getService(IBuildableSubsetService.class).runSelectQueryWithTimestamp(query, ifModifiedSince);
        ArrayList<IBuildableSubsetHandle> handles = new ArrayList<IBuildableSubsetHandle>();
        try {
            SelectResultFeedParser parser = new SelectResultFeedParser();
            List selectResults = parser.parse((InputStream)new ByteArrayInputStream(results.getBytes("UTF-8")));
            for (SelectResult selectResult : selectResults) {
                BuildableSubsetHandle handle = new BuildableSubsetHandle(selectResult);
                handle.setBuildDefinitionId(buildDefinitionHandle.getItemId());
                if (!handle.isValid()) continue;
                handles.add((IBuildableSubsetHandle)handle);
            }
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return handles;
    }

    @Override
    public List<IBuildableSubsetHandle> getMyBuildableSubsets(IBuildDefinitionHandle buildDefinitionHandle) throws TeamRepositoryException {
        return this.getMyBuildableSubsets(buildDefinitionHandle, null);
    }

    @Override
    public List<IBuildableSubsetHandle> getMyBuildableSubsets(IBuildDefinitionHandle buildDefinitionHandle, String ifModifiedSince) throws TeamRepositoryException {
        IContributor contributor = this.getContext().teamRepository().loggedInContributor();
        UUID owner = contributor.getItemId();
        String ownerUUID = owner.getUuidValue();
        String query = BuildableSubsetQuery.getMyBuildableSubsetHandlesQuery((String)buildDefinitionHandle.getItemId().getUuidValue(), (String)ownerUUID);
        String results = this.getService(IBuildableSubsetService.class).runSelectQueryWithTimestamp(query, ifModifiedSince);
        ArrayList<IBuildableSubsetHandle> handles = new ArrayList<IBuildableSubsetHandle>();
        try {
            SelectResultFeedParser parser = new SelectResultFeedParser();
            List selectResults = parser.parse((InputStream)new ByteArrayInputStream(results.getBytes("UTF-8")));
            for (SelectResult selectResult : selectResults) {
                BuildableSubsetHandle handle = new BuildableSubsetHandle(selectResult);
                handle.setBuildDefinitionId(buildDefinitionHandle.getItemId());
                handle.setOwnerId(owner);
                if (!handle.isValid()) continue;
                handles.add((IBuildableSubsetHandle)handle);
            }
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return handles;
    }

    @Override
    public List<IBuildableSubsetHandle> getMySharedBuildableSubsets(IBuildDefinitionHandle buildDefinitionHandle) throws TeamRepositoryException {
        return this.getMySharedBuildableSubsets(buildDefinitionHandle, null);
    }

    @Override
    public List<IBuildableSubsetHandle> getMySharedBuildableSubsets(IBuildDefinitionHandle buildDefinitionHandle, String ifModifiedSince) throws TeamRepositoryException {
        IContributor contributor = this.getContext().teamRepository().loggedInContributor();
        UUID owner = contributor.getItemId();
        String ownerUUID = owner.getUuidValue();
        String query = BuildableSubsetQuery.getMySharedBuildableSubsetHandlesQuery((String)buildDefinitionHandle.getItemId().getUuidValue(), (String)ownerUUID);
        String results = this.getService(IBuildableSubsetService.class).runSelectQueryWithTimestamp(query, ifModifiedSince);
        ArrayList<IBuildableSubsetHandle> handles = new ArrayList<IBuildableSubsetHandle>();
        try {
            SelectResultFeedParser parser = new SelectResultFeedParser();
            List selectResults = parser.parse((InputStream)new ByteArrayInputStream(results.getBytes("UTF-8")));
            for (SelectResult selectResult : selectResults) {
                BuildableSubsetHandle handle = new BuildableSubsetHandle(selectResult);
                handle.setBuildDefinitionId(buildDefinitionHandle.getItemId());
                handle.setOwnerId(owner);
                if (!handle.isValid()) continue;
                handles.add((IBuildableSubsetHandle)handle);
            }
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return handles;
    }

    @Override
    public boolean exists(final String buildableSubsetSlug) throws TeamRepositoryException {
        return (Boolean)this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return BuildableSubsetClient.this.getService(IBuildableSubsetService.class).exists(buildableSubsetSlug);
            }
        });
    }
}

