/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.validation;

import com.urbancode.air.plugin_command.schema_migration.SchemaDocValidator;
import com.urbancode.air.plugin_command.schema_migration.SchemaValidationException;
import com.urbancode.air.plugin_command.validation.PluginCommandPathValidator;
import com.urbancode.air.plugin_command.validation.PluginCommandValidator;
import com.urbancode.commons.xml.DOMUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipFile;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;

public class PluginZipValidator {
    private final SchemaDocValidator pluginXmlValidator;

    public PluginZipValidator() {
        this(new PluginCommandValidator());
    }

    public PluginZipValidator(SchemaDocValidator pluginXmlValidator) {
        this.pluginXmlValidator = pluginXmlValidator;
    }

    public Document validateAndTransform(ZipFile pluginZipFile) throws IOException, SchemaValidationException, XPathExpressionException, DOMException {
        Document pluginXmlDoc = null;
        InputStream pluginXmlInput = pluginZipFile.getInputStream(pluginZipFile.getEntry("plugin.xml"));
        try {
            pluginXmlDoc = this.pluginXmlValidator.validateAndTransform(pluginXmlInput);
            Document namespaceUnawareDoc = DOMUtils.loadDocument((String)DOMUtils.documentToString((Document)pluginXmlDoc));
            PluginCommandPathValidator commandPathValidator = new PluginCommandPathValidator(pluginZipFile);
            try {
                commandPathValidator.assertRelativeFilesExist(namespaceUnawareDoc, "//validation/@file", "validation");
                commandPathValidator.assertRelativeFilesExist(namespaceUnawareDoc, "//command/@file", "command");
                commandPathValidator.assertRelativeFilesExist(namespaceUnawareDoc, "//command/arg/@file", "argument");
                commandPathValidator.assertRelativePathFilesExist(namespaceUnawareDoc, "//command/arg/@path", "argument");
                commandPathValidator.assertRelativeFilesExist(namespaceUnawareDoc, "//env/@file", "environment");
                commandPathValidator.assertRelativePathFilesExist(namespaceUnawareDoc, "//env/@path", "environment");
            }
            catch (XPathExpressionException e) {
                throw new SchemaValidationException(e);
            }
        }
        catch (Exception e) {
            throw new SchemaValidationException(e);
        }
        finally {
            pluginZipFile.close();
        }
        return pluginXmlDoc;
    }
}

