/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.buildablesubset.common.impl;

import com.ibm.team.enterprise.buildablesubset.common.IBuildSubsetRule;
import com.ibm.team.enterprise.buildablesubset.common.IBuildSubsetRuleParser;
import com.ibm.team.enterprise.buildablesubset.common.IDefaultBuildSubsetRule;
import com.ibm.team.enterprise.buildablesubset.common.impl.DefaultBuildSubsetRule;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import java.io.Reader;
import java.io.StringReader;

public class DefaultBuildSubsetRuleParser
implements IBuildSubsetRuleParser {
    @Override
    public boolean canParseRule(IBuildSubsetRule rule) {
        return rule instanceof IDefaultBuildSubsetRule;
    }

    @Override
    public boolean canParseRule(String ruleContent) {
        try {
            JSONObject jsonObj = JSONObject.parse((Reader)new StringReader(ruleContent));
            String id = (String)jsonObj.get((Object)"id");
            if (id.equals(IDefaultBuildSubsetRule.ID)) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    @Override
    public IBuildSubsetRule parseRule(String content) throws TeamRepositoryException {
        try {
            String namePattern;
            String langdefValue;
            DefaultBuildSubsetRule rule = new DefaultBuildSubsetRule();
            JSONObject jsonObj = JSONObject.parse((Reader)new StringReader(content));
            String componentValue = (String)jsonObj.get((Object)"component");
            if (this.isValidUUID(componentValue)) {
                rule.setComponentHandle((IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)componentValue), null));
            }
            if (this.isValidUUID(langdefValue = (String)jsonObj.get((Object)"languageDefinition"))) {
                rule.setLanguageDefinitionId(UUID.valueOf((String)langdefValue));
            }
            if ((namePattern = (String)jsonObj.get((Object)"namePattern")) != null) {
                rule.setNamePattern(namePattern);
            }
            return rule;
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    @Override
    public String toJSON(IBuildSubsetRule rule) {
        JSONObject jsonObj = new JSONObject();
        if (rule instanceof IDefaultBuildSubsetRule) {
            IDefaultBuildSubsetRule defaultRule = (IDefaultBuildSubsetRule)rule;
            if (defaultRule.getComponentHandle() != null) {
                jsonObj.put((Object)"component", (Object)defaultRule.getComponentHandle().getItemId().getUuidValue());
            }
            if (defaultRule.getLanguageDefinitionId() != null) {
                jsonObj.put((Object)"languageDefinition", (Object)defaultRule.getLanguageDefinitionId().getUuidValue());
            }
            if (defaultRule.getNamePattern() != null) {
                jsonObj.put((Object)"namePattern", (Object)defaultRule.getNamePattern());
            }
            jsonObj.put((Object)"id", (Object)IDefaultBuildSubsetRule.ID);
        }
        return jsonObj.toString();
    }

    private boolean isValidUUID(String uuidValue) {
        if (uuidValue == null || uuidValue.equals("")) {
            return false;
        }
        try {
            UUID.valueOf((String)uuidValue);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

