/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.marshalling;

import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.common.serialize.IStackAdjuster;
import com.ibm.team.repository.common.serialize.IURISerializer;
import com.ibm.team.repository.common.serialize.SerializeException;
import com.ibm.team.repository.common.serialize.internal.JSONDeserializer;
import com.ibm.team.repository.common.transport.HttpUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class ExceptionHandlingJSONDeserializer
extends JSONDeserializer {
    public ExceptionHandlingJSONDeserializer(HttpUtil.MediaType type, IURISerializer uriSerializer) {
        super(type, uriSerializer);
    }

    protected IStatus deserializeStatusObject(JSONObject obj, ClassLoader loader, IStackAdjuster adj) throws SerializeException {
        int errCode = -1;
        int severity = -1;
        String message = null;
        String plugin = null;
        boolean isMulti = false;
        Throwable exception = null;
        Object o = obj.get((Object)"-code");
        if (o instanceof Number) {
            errCode = ((Number)o).intValue();
        }
        if ((o = obj.get((Object)"-message")) instanceof String) {
            message = (String)o;
        }
        if ((o = obj.get((Object)"-plugin")) instanceof String) {
            plugin = (String)o;
        }
        if ((o = obj.get((Object)"-severity")) instanceof Number) {
            severity = ((Number)o).intValue();
        }
        if ((o = obj.get((Object)"-isMultiStatus")) instanceof Boolean) {
            isMulti = (Boolean)o;
        }
        if ((o = obj.get((Object)"-exception")) instanceof JSONObject) {
            exception = this.deserializeErrorObj((JSONObject)o, loader, adj);
        }
        if (severity != 0 && severity != 1 && severity != 2 && severity != 4 && severity != 8) {
            return null;
        }
        if (isMulti) {
            MultiStatus multi = new MultiStatus(plugin, errCode, message, exception);
            Object kids = obj.get((Object)"-children");
            if (kids != null && kids instanceof JSONArray) {
                for (Object child : (JSONArray)kids) {
                    IStatus parsed;
                    if (!(child instanceof JSONObject) || (parsed = this.deserializeStatusObject((JSONObject)child, loader, adj)) == null) continue;
                    multi.add(parsed);
                }
            }
            return multi;
        }
        return new Status(severity, plugin, message, exception);
    }

    protected Throwable deserializeErrorObj(JSONObject jsonObject, ClassLoader loader, IStackAdjuster adj) throws SerializeException {
        Throwable withoutStatus = super.deserializeErrorObj(jsonObject, loader, adj);
        if (!(withoutStatus instanceof FileSystemStatusException)) {
            return withoutStatus;
        }
        FileSystemStatusException e = (FileSystemStatusException)withoutStatus;
        Object o = jsonObject.get((Object)"-errorStatusData");
        if (o == null) {
            return withoutStatus;
        }
        IStatus status = this.deserializeStatusObject((JSONObject)o, loader, adj);
        e.setStatus(status);
        return e;
    }
}

