/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.ri.impl.ConfigurationImpl;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoBaseline;
import com.ibm.team.connector.scm.client.JzRepoChangeSet;
import com.ibm.team.connector.scm.client.JzRepoComponent;
import com.ibm.team.connector.scm.client.JzRepoControllableFolder;
import com.ibm.team.connector.scm.client.JzRepoResource;
import com.ibm.team.connector.scm.client.JzRepoWorkspace;
import com.ibm.team.connector.scm.client.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wvcm.Configuration;
import javax.wvcm.ControllableResource;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.WvcmException;

public class JzRepoConfiguration
extends JzRepoResource {
    private static ChangesPerChangeSetCounter changeSetCounter = new ChangesPerChangeSetCounter();
    JzRepoWorkspace _myWsCache = null;
    JzRepoComponent _myCompCache = null;

    public JzRepoConfiguration(JzProvider provider, Location loc) {
        super(provider, loc);
    }

    @Override
    public Class<?> get_proxyClass() {
        return ConfigurationImpl.class;
    }

    public JzRepoWorkspace getMyWorkspace(SrvcFeedback feedback) throws WvcmException {
        if (this._myWsCache == null) {
            this._myWsCache = this.getWvcmWorkspace(feedback);
        }
        return this._myWsCache;
    }

    public JzRepoComponent getMyComponent(SrvcFeedback feedback) throws WvcmException {
        if (this._myCompCache == null) {
            this._myCompCache = this.getMyWorkspace(feedback.nest(30)).getJzRepoComponent(this.location().getComponentLocation(), feedback);
        }
        return this._myCompCache;
    }

    private static JzRepoComponent getJzRepoComponent(JzProvider provider, JzLocation myLoc, SrvcFeedback feedback) throws WvcmException {
        JzRepoWorkspace ws = (JzRepoWorkspace)provider.get((Location)myLoc.getWorkspaceLocation(), feedback.nest(50));
        JzRepoComponent c = ws.getJzRepoComponent(myLoc.getComponentLocation(), feedback);
        return c;
    }

    public static JzRepoConfiguration lookup(JzProvider provider, JzLocation myLoc, SrvcFeedback feedback) throws WvcmException {
        JzRepoConfiguration result = null;
        JzLocation.Kind myLocKind = myLoc.kind();
        if (JzLocation.Kind.WorkspaceConfiguration.equals((Object)myLocKind)) {
            JzRepoWorkspace ws = JzRepoWorkspace.lookup(provider, myLoc, feedback);
            if (ws != null) {
                result = new JzRepoConfiguration(provider, (Location)myLoc);
            }
            return result;
        }
        try {
            JzRepoComponent myComp = JzRepoConfiguration.getJzRepoComponent(provider, myLoc, feedback);
            if (myComp != null) {
                JzLocation configLoc = JzLocation.createConfigurationLoc(myLoc.getWorkspaceLocation(), myComp.location());
                result = new JzRepoConfiguration(provider, (Location)configLoc);
            }
        }
        catch (WvcmException e) {
            if (!WvcmException.ReasonCode.NOT_FOUND.equals((Object)e.getReasonCode())) {
                throw e;
            }
            provider.logIgnoredExceptionAsNotAlwaysVisible("JzRepoConfiguration.lookup", (Exception)((Object)e));
            result = null;
        }
        return result;
    }

    public void doCheckin(ControllableResource.CheckinFlag[] flags, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        String displayName;
        if (JzLocation.Kind.WorkspaceConfiguration.equals((Object)this.location().kind())) {
            JzRepoWorkspace ws = this.lookupWorkspaceConfigurationWorkspace(feedback);
            if (ws != null) {
                ws.doWorkspaceConfigurationCheckin(flags, updates, updated, feedback);
                return;
            }
            throw new IllegalArgumentException("Could not resolve location to a workspace: " + this.location().toString());
        }
        JzRepoComponent c = this.getMyComponent(feedback.nest(30));
        PropValue displayNamePVal = updates.get(Configuration.DISPLAY_NAME);
        String string = displayName = displayNamePVal != null ? (String)displayNamePVal.get_value() : null;
        if (displayName != null && updated != null) {
            updated.add(Configuration.DISPLAY_NAME);
        }
        boolean identOK = false;
        if (flags != null) {
            ControllableResource.CheckinFlag[] checkinFlagArray = flags;
            int n = flags.length;
            int n2 = 0;
            while (n2 < n) {
                ControllableResource.CheckinFlag flag = checkinFlagArray[n2];
                if (flag.equals(ControllableResource.CheckinFlag.CHECKIN_IDENTICAL)) {
                    identOK = true;
                }
                ++n2;
            }
        }
        c.createBaselineIfNeeded(this.getMyWorkspace(feedback.nest(60)), identOK, displayName, feedback);
    }

    public void doCheckout(ControllableResource.CheckoutFlag[] flags, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback sfb) throws WvcmException {
    }

    public void doCheckout(ControllableResource.CheckoutFlag[] flags, SrvcFeedback feedback) throws WvcmException {
    }

    @Override
    protected Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Configuration.CHECKED_IN)) {
            if (JzLocation.Kind.WorkspaceConfiguration.equals((Object)this.location().kind())) {
                JzRepoWorkspace ws = this.lookupWorkspaceConfigurationWorkspace(feedback);
                if (ws != null) {
                    return ws.lookupLatestSnapshot(feedback);
                }
                throw new IllegalArgumentException("Could not resolve location to a workspace: " + this.location().toString());
            }
            return this.getLatestBaseline(feedback);
        }
        if (propertyName.equals((Object)Configuration.VERSION_HISTORY)) {
            return this.getMyComponent(feedback);
        }
        if (propertyName.equals((Object)Configuration.ROOT_FOLDER)) {
            return this.getRootFolder(feedback);
        }
        if (propertyName.equals((Object)Configuration.WORKSPACE)) {
            return this.getMyWorkspace(feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    private JzRepoWorkspace lookupWorkspaceConfigurationWorkspace(SrvcFeedback feedback) throws WvcmException {
        JzLocation wsLoc = JzLocation.createWorkspaceLoc(this.location().getDisplayName());
        JzRepoWorkspace result = JzRepoWorkspace.lookup(this.provider(), wsLoc, feedback);
        return result;
    }

    public JzRepoResource getLatestBaseline(SrvcFeedback feedback) throws WvcmException {
        JzRepoWorkspace ws = this.getMyWorkspace(feedback.nest(10));
        JzRepoComponent c = this.getMyComponent(feedback.nest(30));
        this.logDebug("getting baseline in ws: " + ws.location().string());
        JzRepoBaseline latestBaseline = c.getLatestBaseline(ws.getConnection(feedback.nest(60)), feedback);
        return latestBaseline;
    }

    public SrvcResource getRootFolder(SrvcFeedback feedback) throws WvcmException {
        JzRepoComponent myComp = this.getMyComponent(feedback.nest(30));
        JzLocation parentLoc = this.getMyWorkspace(feedback.nest(60)).computeBcfLoc(myComp);
        JzRepoControllableFolder result = (JzRepoControllableFolder)JzRepoConfiguration.createFromVersionable(this.provider(), parentLoc, (IVersionableHandle)myComp.getRootFolderHandle(feedback));
        return result;
    }

    public void commit(IWorkspaceConnection.IConfigurationOp configOp, JzLocation location, SrvcFeedback feedback) throws WvcmException {
        if (configOp != null) {
            HashMap<JzLocation, IWorkspaceConnection.IConfigurationOp> op = new HashMap<JzLocation, IWorkspaceConnection.IConfigurationOp>();
            op.put(location, configOp);
            this.commit(op, false, feedback);
        }
    }

    IChangeSetHandle createChangeSet(SrvcFeedback feedback) throws WvcmException {
        IWorkspaceConnection wsConn = this.getWorkspaceConnection(feedback.nest(10));
        IComponentHandle componentItemHandle = this.getMyComponent(feedback.nest(30)).getComponentItemHandle(feedback.nest(50));
        return this.createChangeSet(wsConn, componentItemHandle, feedback);
    }

    private IChangeSetHandle createChangeSet(IWorkspaceConnection wsConn, IComponentHandle componentItemHandle, SrvcFeedback feedback) throws WvcmException {
        try {
            IChangeSetHandle result = wsConn.createChangeSet(componentItemHandle, JzProvider.getMonitor(feedback, 100));
            this.logCreation("ChangeSet", JzRepoChangeSet.create(this.provider(), result, feedback).location());
            return result;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException(e);
        }
    }

    public IChangeSetHandle getActiveChangeSetHandle(SrvcFeedback feedback) throws WvcmException {
        IWorkspaceConnection wsConn = this.getWorkspaceConnection(feedback.nest(30));
        IComponentHandle cH = this.getMyComponent(feedback.nest(60)).getComponentItemHandle(feedback.nest(80));
        List sets = wsConn.activeChangeSets(cH);
        int count = sets.size();
        IChangeSetHandle result = null;
        if (count > 1) {
            throw new IllegalStateException("got too many active change sets: " + Integer.toString(count));
        }
        if (count == 1) {
            this.logDebug("reusing active change set");
            result = (IChangeSetHandle)sets.get(0);
        } else {
            result = this.createChangeSet(wsConn, cH, feedback);
        }
        return result;
    }

    public void commit(Map<JzLocation, IWorkspaceConnection.IConfigurationOp> opDescs, boolean isAutoCommit, SrvcFeedback feedback) throws WvcmException {
        if (opDescs != null) {
            JzProvider provider = this.provider();
            IWorkspaceConnection wsConn = this.getWorkspaceConnection(feedback.nest(20));
            IChangeSetHandle activeCS = this.getActiveChangeSetHandle(feedback.nest(30));
            int size = opDescs.size();
            provider.logDiagInfo("committing %d operation(s) to the active change set", size);
            if (provider.isDebugLogEnabled()) {
                JzLocation[] locations = opDescs.keySet().toArray(new JzLocation[size]);
                this.logDebug("committing: " + this.join(JzProvider.COMMA_SPACE, locations));
            }
            try {
                long startTime = System.nanoTime();
                Collection<IWorkspaceConnection.IConfigurationOp> ops = opDescs.values();
                wsConn.commit(activeCS, ops, JzProvider.getMonitor(feedback, 90));
                int changeCount = changeSetCounter.countChanges(activeCS, ops.size());
                long duration = System.nanoTime() - startTime;
                long durationMilliseconds = duration / 1000000L;
                provider.logDiagInfo("duration of change set commit (milliseconds): %d", durationMilliseconds);
                if (changeCount > provider.maxChangesPerChangeSet()) {
                    JzRepoWorkspace myWs = this.getMyWorkspace(feedback);
                    this.closeChangeSet(myWs, activeCS, feedback);
                } else {
                    provider.logDiagInfo("leaving change set open", new Object[0]);
                }
            }
            catch (TeamRepositoryException e) {
                throw JzProvider.wrapException(e);
            }
        }
    }

    public void closeChangeSet(JzRepoWorkspace myWs, IChangeSetHandle changeSetHandle, SrvcFeedback feedback) throws WvcmException {
        myWs.closeChangeSets(feedback.nest(50), changeSetHandle);
        Integer changeCount = changeSetCounter.recordClosedChangeSet(changeSetHandle);
        if (changeCount == null) {
            feedback.notifyCompleted(Messages.JzRepoConfiguration_MSG_COMPLETED_CHANGE_SET);
        } else {
            feedback.notifyCompleted(NLS.bind((String)Messages.JzRepoConfiguration_MSG_CLOSED_CHANGE_SET_WITH_COUNT, (Object)changeCount, (Object[])new Object[0]));
        }
    }

    public String join(String separator, JzLocation ... values) {
        if (values.length == 0) {
            return JzProvider.EMPTY_STRING;
        }
        StringBuilder buf = new StringBuilder(values[0].string());
        int i = 1;
        while (i < values.length) {
            buf.append(separator);
            buf.append(values[i].string());
            ++i;
        }
        return buf.toString();
    }

    public void closeCurrentActivity(SrvcFeedback feedback) throws WvcmException {
        JzProvider provider = this.provider();
        provider.applyDeferredContentCommits(this, feedback.nest(10));
        JzRepoWorkspace ws = this.getMyWorkspace(feedback.nest(20));
        JzRepoComponent comp = this.getMyComponent(feedback.nest(40));
        ws.closeCurrentActivities(comp, feedback.nest(100));
    }

    public static class ChangesPerChangeSetCounter {
        private final Map<UUID, Integer> changeSetUuidsToCommitCount = new HashMap<UUID, Integer>(1);

        public int countChanges(IChangeSetHandle handle, int count) {
            UUID key = handle.getItemId();
            Integer oldValue = this.changeSetUuidsToCommitCount.get(key);
            int newValue = count + (oldValue == null ? 0 : oldValue);
            this.changeSetUuidsToCommitCount.put(key, newValue);
            return newValue;
        }

        public Integer recordClosedChangeSet(IChangeSetHandle handle) {
            UUID key = handle.getItemId();
            return this.changeSetUuidsToCommitCount.remove(key);
        }
    }
}

