/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.common.helper;

import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IConfigurationProperty;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.StringTokenizer;

public class BuildEngineHelper {
    public static final String BUILD_FORGE_ENGINE_TEMPLATE_ID = "com.ibm.rational.connector.buildforge.engine.template";
    public static final String BUILD_FORGE_LEGACY_ENGINE_ID = "RationalBuildForgeConnector";
    public static final String PROPERTY_BUILDFORGE_HOSTNAME = "com.ibm.rational.connector.buildforge.hostname";
    public static final String PROPERTY_BUILDFORGE_PORT = "com.ibm.rational.connector.buildforge.port";
    public static final String BUILD_AGENT_ENGINE_TEMPLATE_ID = "com.ibm.rational.buildforge.buildagent.engine";
    public static final String BUILD_AGENT_LEGACY_ENGINE_ID = "RationalBuildAgent";
    public static final String PROPERTY_BUILDAGENT_HOSTNAME = "com.ibm.rational.buildforge.buildagent.hostname";
    public static final String PROPERTY_BUILDAGENT_PORT = "com.ibm.rational.buildforge.buildagent.port";
    public static final String HUDSON_ENGINE_TEMPLATE_ID = "com.ibm.rational.connector.hudson.engine.template";
    public static final String BUILD_FORGE_ENGINE_ELEMENT_ID = "com.ibm.rational.connector.buildforge.engine";
    public static final String BUILD_AGENT_ENGINE_ELEMENT_ID = "com.ibm.rational.buildforge.buildagent";
    public static final String HUDSON_ENGINE_ELEMENT_ID = "com.ibm.rational.connector.hudson.engine";
    public static final String BUILD_FORGE_DEFINITION_TEMPLATE_ID = "com.ibm.rational.connector.buildforge.ui.buildDefinitionTemplate";
    public static final String BUILD_AGENT_DEFINITION_TEMPLATE_ID = "com.ibm.rational.buildforge.buildagent.ui.buildDefinitionTemplate";
    public static final String HUDSON_DEFINITION_TEMPLATE_ID = "com.ibm.rational.connector.hudson.ui.buildDefinitionTemplate";
    public static final String BUILD_FORGE_DEFINITION_ELEMENT_ID = "com.ibm.rational.connector.buildforge";
    public static final String BUILD_AGENT_DEFINITION_ELEMENT_ID = "com.ibm.rational.buildforge.buildagent";
    public static final String BUILD_AGENT_COMMAND_LINE_DEFINITION_ELEMENT_ID = "com.ibm.rational.buildforge.buildagent.cmdline";
    public static final String HUDSON_DEFINITION_ELEMENT_ID = "com.ibm.rational.connector.hudson";
    public static final String PROPERTY_BUILDFORGE_PASSWORD = "com.ibm.rational.connector.buildforge.password";
    public static final String PROPERTY_BUILDAGENT_PASSWORD = "com.ibm.rational.buildforge.buildagent.password";
    public static final String PROPERTY_HUDSON_URL = "com.ibm.rational.connector.hudson.url";
    public static final String PROPERTY_HUDSON_PASSWORD = "com.ibm.rational.connector.hudson.password";
    public static final String BUILD_FORGE_HIDDEN_PROPERTY_DUMMY_VALUE = "*****";
    private static final char DUMMY_CHAR = '\u1438';

    public static boolean isBuildForgeEngine(IBuildEngine engine) {
        return engine.getConfigurationElement(BUILD_FORGE_ENGINE_ELEMENT_ID) != null;
    }

    public static boolean isBuildAgentEngine(IBuildEngine engine) {
        return engine.getConfigurationElement("com.ibm.rational.buildforge.buildagent") != null;
    }

    public static boolean isHudsonEngine(IBuildEngine engine) {
        return engine.getConfigurationElement(HUDSON_ENGINE_ELEMENT_ID) != null;
    }

    public static boolean isBuildForgeDefinition(IBuildDefinition definition) {
        return definition.getConfigurationElement(BUILD_FORGE_DEFINITION_ELEMENT_ID) != null;
    }

    public static boolean isBuildAgentDefinition(IBuildDefinition definition) {
        return definition.getConfigurationElement("com.ibm.rational.buildforge.buildagent") != null;
    }

    public static boolean isHudsonDefinition(IBuildDefinition definition) {
        return definition.getConfigurationElement(HUDSON_DEFINITION_ELEMENT_ID) != null;
    }

    public static boolean isExternalEngineConfigurationElementId(String elementId) {
        return elementId.equals(BUILD_FORGE_ENGINE_ELEMENT_ID) || elementId.equals("com.ibm.rational.buildforge.buildagent") || elementId.equals(HUDSON_ENGINE_ELEMENT_ID);
    }

    public static void blankOutPassword(IBuildConfigurationElement element) {
        IConfigurationProperty passProp = element.getConfigurationProperty(PROPERTY_HUDSON_PASSWORD);
        if (passProp != null) {
            passProp.setValue("");
        } else {
            passProp = element.getConfigurationProperty(PROPERTY_BUILDFORGE_PASSWORD);
            if (passProp != null) {
                passProp.setValue("");
            } else {
                passProp = element.getConfigurationProperty(PROPERTY_BUILDAGENT_PASSWORD);
                if (passProp != null) {
                    passProp.setValue("");
                }
            }
        }
    }

    public static String getExternalURL(IBuildEngine engine) {
        String url;
        if (BuildEngineHelper.isBuildForgeEngine(engine)) {
            String host = engine.getConfigurationPropertyValue(BUILD_FORGE_ENGINE_ELEMENT_ID, PROPERTY_BUILDFORGE_HOSTNAME, null);
            int port = BuildEngineHelper.str2int(engine.getConfigurationPropertyValue(BUILD_FORGE_ENGINE_ELEMENT_ID, PROPERTY_BUILDFORGE_PORT, "-1"), -1);
            if (host != null && host.length() > 0) {
                try {
                    return new URI("buildforge", null, host, port, null, null, null).toString();
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
        } else if (BuildEngineHelper.isBuildAgentEngine(engine)) {
            String host = engine.getConfigurationPropertyValue("com.ibm.rational.buildforge.buildagent", PROPERTY_BUILDAGENT_HOSTNAME, null);
            int port = BuildEngineHelper.str2int(engine.getConfigurationPropertyValue("com.ibm.rational.buildforge.buildagent", PROPERTY_BUILDAGENT_PORT, "-1"), -1);
            if (host != null && host.length() > 0) {
                try {
                    return new URI("buildagent", null, host, port, null, null, null).toString();
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
        } else if (BuildEngineHelper.isHudsonEngine(engine) && (url = engine.getConfigurationPropertyValue(HUDSON_ENGINE_ELEMENT_ID, PROPERTY_HUDSON_URL, null)) != null && url.length() > 0) {
            return url;
        }
        return null;
    }

    private static int str2int(String str, int defaultVal) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultVal;
        }
    }

    public static void setExternalURL(IBuildEngine engine, String url) {
        if (BuildEngineHelper.isBuildForgeEngine(engine)) {
            try {
                URI uri = new URI(url);
                if ("buildforge".equals(uri.getScheme())) {
                    String host = uri.getHost();
                    int port = uri.getPort();
                    engine.setConfigurationProperty(BUILD_FORGE_ENGINE_ELEMENT_ID, PROPERTY_BUILDFORGE_HOSTNAME, host == null ? "" : host);
                    engine.setConfigurationProperty(BUILD_FORGE_ENGINE_ELEMENT_ID, PROPERTY_BUILDFORGE_PORT, port == -1 ? "" : Integer.toString(port));
                }
            }
            catch (URISyntaxException uRISyntaxException) {}
        } else if (BuildEngineHelper.isBuildAgentEngine(engine)) {
            try {
                URI uri = new URI(url);
                if ("buildagent".equals(uri.getScheme())) {
                    String host = uri.getHost();
                    int port = uri.getPort();
                    engine.setConfigurationProperty("com.ibm.rational.buildforge.buildagent", PROPERTY_BUILDAGENT_HOSTNAME, host == null ? "" : host);
                    engine.setConfigurationProperty("com.ibm.rational.buildforge.buildagent", PROPERTY_BUILDAGENT_PORT, port == -1 ? "" : Integer.toString(port));
                }
            }
            catch (URISyntaxException uRISyntaxException) {}
        } else if (BuildEngineHelper.isHudsonEngine(engine)) {
            engine.setConfigurationProperty(HUDSON_ENGINE_ELEMENT_ID, PROPERTY_HUDSON_URL, url);
        }
    }

    public static boolean isBuildForgeHiddenProperty(IBuildProperty buildProperty) {
        return BuildEngineHelper.hasBuildForgeToken(buildProperty, "HIDDEN");
    }

    public static boolean isBuildForgePulldownProperty(IBuildProperty buildProperty) {
        return BuildEngineHelper.hasBuildForgeToken(buildProperty, "PULLDOWN");
    }

    private static boolean hasBuildForgeToken(IBuildProperty buildProperty, String tokenToTest) {
        if (buildProperty.getDescription() != null && buildProperty.getDescription().contains(tokenToTest)) {
            StringTokenizer tokenizer = new StringTokenizer(buildProperty.getDescription(), ", ");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (!tokenToTest.equals(token)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getSecretKey(String propertyName) {
        return "property." + propertyName;
    }

    public static String getDummyPassword(String original) {
        if (original == null || original.length() == 0) {
            return original;
        }
        StringBuilder sb = new StringBuilder(original.length());
        int i = 0;
        while (i < original.length()) {
            sb.append('\u1438');
            ++i;
        }
        return sb.toString();
    }

    public static boolean isDummyPassword(String password) {
        if (password == null || password.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < password.length()) {
            if (password.charAt(i) != '\u1438') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String getCombinedKeyValues(IBuildEngine buildEngine, String configElementId, String ... keyPropertyNames) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = keyPropertyNames;
        int n = keyPropertyNames.length;
        int n2 = 0;
        while (n2 < n) {
            String keyPropertyName = stringArray[n2];
            if (sb.length() > 0) {
                sb.append(':');
            }
            String value = buildEngine.getConfigurationPropertyValue(configElementId, keyPropertyName, "");
            sb.append(value);
            ++n2;
        }
        return sb.toString();
    }
}

