/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.common.helper;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.l10n.Messages;
import com.ibm.team.repository.common.IType;
import com.ibm.team.repository.common.model.Helper;
import com.ibm.team.repository.common.validation.IItemValidator;
import com.ibm.team.repository.common.validation.IStringSizeConstraintErrorStatus;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public class ItemHelper {
    private static final int TRUNCATED_ATTRIBUTE_EXTENSION_LENGTH = Messages.getCommonString("ItemHelper.0").length() - "{0}".length();

    static {
        new ItemHelper();
    }

    private ItemHelper() {
    }

    public static String validateStringAttributeLength(String value, IType type, String propertyName) {
        if (value == null) {
            return value;
        }
        ValidationHelper.validateNotNull("type", type);
        ValidationHelper.validateNotEmpty("propertyName", propertyName);
        IStatus status = IItemValidator.INSTANCE.validateAttribute(type, propertyName, (Object)value);
        if (!status.isOK() && status instanceof IStringSizeConstraintErrorStatus) {
            int maxSize = (int)((IStringSizeConstraintErrorStatus)status).getMaxSize();
            maxSize = Math.max(maxSize - TRUNCATED_ATTRIBUTE_EXTENSION_LENGTH, 0);
            StringBuilder stringBuilder = new StringBuilder(maxSize);
            int byteCount = 0;
            int i = 0;
            while (i < value.length()) {
                char ch = value.charAt(i);
                int len = ItemHelper.getUtf8ByteLength(ch);
                if (byteCount + len > maxSize) break;
                stringBuilder.append(ch);
                byteCount += len;
                ++i;
            }
            String truncatedValue = stringBuilder.toString();
            value = NLS.bind((String)Messages.getCommonString("ItemHelper.0"), (Object)truncatedValue);
        }
        return value;
    }

    private static int getUtf8ByteLength(char ch) {
        if ((ch & 0xFF80) == 0) {
            return 1;
        }
        if ((ch & 0xF800) == 0) {
            return 2;
        }
        return 3;
    }

    public static boolean removeHelper(List helperList, Helper toRemove) {
        ValidationHelper.validateNotNull("helperList", helperList);
        ValidationHelper.validateNotNull("toRemove", toRemove);
        Iterator i = helperList.iterator();
        while (i.hasNext()) {
            Helper helper;
            Object o = i.next();
            if (!(o instanceof Helper) || (helper = (Helper)o).getInternalId() == null || !helper.getInternalId().equals((Object)toRemove.getInternalId())) continue;
            i.remove();
            return true;
        }
        return false;
    }
}

