/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.common.textdifferencer;

import com.ibm.team.foundation.common.textdifferencer.IDiffFormat;
import com.ibm.team.foundation.common.textdifferencer.RangeComparatorLCS;
import com.ibm.team.foundation.common.textdifferencer.RangeDifference;
import com.ibm.team.foundation.common.textdifferencer.TokenComparator;
import org.eclipse.core.runtime.IProgressMonitor;

public class TextDifferencer {
    public static String diff(String oldText, String newText, IProgressMonitor pm) {
        return TextDifferencer.diff(oldText, newText, new DefaultFormat(), pm);
    }

    public static String diff(String oldText, String newText, IDiffFormat format, IProgressMonitor pm) {
        StringBuilder result = new StringBuilder();
        TokenComparator l = new TokenComparator(oldText);
        TokenComparator r = new TokenComparator(newText);
        RangeDifference[] ranges = RangeComparatorLCS.findRanges(pm, l, r);
        int i = 0;
        while (i < ranges.length) {
            RangeDifference rangeDifference = ranges[i];
            switch (rangeDifference.kind()) {
                case 0: {
                    result.append(format.unchanged(l.getText(rangeDifference.leftStart(), rangeDifference.leftLength())));
                    break;
                }
                case 2: {
                    result.append(format.deleted(l.getText(rangeDifference.leftStart(), rangeDifference.leftLength())));
                    result.append(format.inserted(r.getText(rangeDifference.rightStart(), rangeDifference.rightLength())));
                }
            }
            ++i;
        }
        return result.toString();
    }

    public static class DefaultFormat
    implements IDiffFormat {
        @Override
        public String unchanged(String text) {
            return this.text(text, false);
        }

        @Override
        public String inserted(String text) {
            return "<ins>" + this.text(text, true) + "</ins>";
        }

        @Override
        public String deleted(String text) {
            return "<del>" + this.text(text, true) + "</del>";
        }

        protected String text(String text, boolean changed) {
            return text;
        }
    }
}

