/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.common.textdifferencer;

import com.ibm.team.foundation.common.textdifferencer.IRangeComparator;
import org.eclipse.core.runtime.Assert;

class TokenComparator
implements IRangeComparator {
    private String fText;
    private int fCount;
    private int[] fStarts;
    private int[] fLengths;

    public TokenComparator(String text) {
        Assert.isNotNull((Object)text);
        this.fText = text;
        int length = this.fText.length();
        this.fStarts = new int[length];
        this.fLengths = new int[length];
        this.fCount = 0;
        int lastCategory = 0;
        int i = 0;
        while (i < length) {
            char c = this.fText.charAt(i);
            int category = 63;
            if (Character.isWhitespace(c)) {
                category = 32;
            } else if (Character.isDigit(c)) {
                category = 48;
            } else if (Character.isLetter(c)) {
                category = 97;
            }
            if (category != lastCategory) {
                this.fStarts[this.fCount++] = i;
                lastCategory = category;
            }
            int n = this.fCount - 1;
            this.fLengths[n] = this.fLengths[n] + 1;
            ++i;
        }
    }

    @Override
    public int getRangeCount() {
        return this.fCount;
    }

    @Override
    public int getRangeStart(int index) {
        if (index < this.fCount) {
            return this.fStarts[index];
        }
        return this.fText.length();
    }

    @Override
    public int getRangeLength(int index) {
        if (index < this.fCount) {
            return this.fLengths[index];
        }
        return 0;
    }

    public String getText(int start, int length) {
        int count = this.getRangeCount();
        if (length > 0 && count > 0) {
            int startPos = this.getRangeStart(start);
            int endPos = length == 1 ? startPos + this.getRangeLength(start) : this.getRangeStart(start + length);
            return this.fText.substring(startPos, endPos);
        }
        return "";
    }

    @Override
    public boolean rangesEqual(int thisIndex, IRangeComparator other, int otherIndex) {
        if (other != null && this.getClass() == other.getClass()) {
            int otherLen;
            TokenComparator tc = (TokenComparator)other;
            int thisLen = this.getRangeLength(thisIndex);
            if (thisLen == (otherLen = tc.getRangeLength(otherIndex))) {
                return this.fText.regionMatches(false, this.getRangeStart(thisIndex), tc.fText, tc.getRangeStart(otherIndex), thisLen);
            }
        }
        return false;
    }
}

