/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.content.util.tar;

import com.ibm.team.repository.common.internal.content.util.CachedDiskBackedHashMap;
import com.ibm.team.repository.common.internal.content.util.tar.ITarFileEntriesMap;
import com.ibm.team.repository.common.internal.content.util.tar.TarEntry;
import com.ibm.team.repository.common.internal.content.util.tar.TarFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

public class TarFileEntriesMap
implements ITarFileEntriesMap {
    private Map<String, TarEntry> entries;

    public TarFileEntriesMap(long fileSize) {
        this.entries = new CachedDiskBackedHashMap<String, TarEntry>(Math.max(17L, fileSize / 2048L));
    }

    @Override
    public void loadMapInBackground(InputStream entriesInputStream, Object lock, CountDownLatch allDone, TarFile.EntryFilter filter, IOException[] exception) {
        LoadMap loader = new LoadMap(entriesInputStream, lock, allDone, filter, exception);
        Thread backgroundThread = new Thread((Runnable)loader, "TarFile.LoadMap");
        backgroundThread.start();
    }

    @Override
    public TarEntry get(String key) {
        return this.entries.get(key);
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    private class LoadMap
    extends ITarFileEntriesMap.AbstractLoadMap {
        public LoadMap(InputStream entriesInputStream, Object lock, CountDownLatch allDone, TarFile.EntryFilter filter, IOException[] exception) {
            this.entriesInputStream = entriesInputStream;
            this.lock = lock;
            this.allDone = allDone;
            this.exception = exception;
            this.filter = filter != null ? filter : new TarFile.EntryFilter(){

                @Override
                public boolean skipEntry(TarEntry entry) {
                    return false;
                }
            };
        }

        @Override
        protected void putEntry(String name, TarEntry en) {
            TarFileEntriesMap.this.entries.put(name, en);
        }
    }
}

