/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.util;

import com.ibm.team.repository.common.internal.util.StandaloneUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class StandaloneFileLocator {
    private static final Log logger = LogFactory.getLog(StandaloneFileLocator.class);
    private final Map<String, LinkedList<URL>> bundleNameToURLsMap = new HashMap<String, LinkedList<URL>>();
    public static final String PROP_NL = "osgi.nl";
    public static final String PROP_OS = "osgi.os";
    public static final String PROP_WS = "osgi.ws";
    public static final String PROP_ARCH = "osgi.arch";
    private static String[] NL_VARIANTS = StandaloneFileLocator.buildNLVariants(System.getProperty("osgi.nl"));
    private static String OS = System.getProperty("osgi.os");
    private static String WS = System.getProperty("osgi.ws");
    private static String ARCH = System.getProperty("osgi.arch");

    protected StandaloneFileLocator() {
        try {
            Enumeration<URL> manifestFiles = StandaloneFileLocator.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            int i = 0;
            while (manifestFiles.hasMoreElements()) {
                LinkedList<URL> urls;
                URL manifest = manifestFiles.nextElement();
                String manifestPath = manifest.getPath();
                String metaInfPath = StandaloneUtil.getParentPath(manifestPath);
                String bundlePath = StandaloneUtil.getParentPath(metaInfPath);
                URL url = new URL(manifest.getProtocol(), manifest.getHost(), manifest.getPort(), bundlePath);
                String bundleName = StandaloneUtil.getBundleNameForManifest(manifest);
                String fragmentHost = StandaloneUtil.getFragmentHostForManifest(manifest);
                if (fragmentHost != null) {
                    bundleName = fragmentHost;
                }
                if (bundleName == null) {
                    bundleName = Integer.toString(i);
                    ++i;
                }
                if ((urls = this.bundleNameToURLsMap.get(bundleName)) == null) {
                    urls = new LinkedList();
                    this.bundleNameToURLsMap.put(bundleName, urls);
                }
                if (fragmentHost == null) {
                    urls.addFirst(url);
                    continue;
                }
                urls.addLast(url);
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
    }

    public URL find(String bundle, IPath path, Map<String, String> override, List<URL> multiple) {
        if (bundle == null || path == null) {
            return null;
        }
        String first = path.segment(0);
        if (!first.startsWith("$")) {
            return this.find(bundle, path, multiple);
        }
        IPath rest = path.removeFirstSegments(1);
        if (first.equalsIgnoreCase("$nl$")) {
            return this.findNL(bundle, rest, override, multiple);
        }
        if (first.equalsIgnoreCase("$os$")) {
            return this.findOS(bundle, rest, override, multiple);
        }
        if (first.equalsIgnoreCase("$ws$")) {
            return this.findWS(bundle, rest, override, multiple);
        }
        if (first.equalsIgnoreCase("$files$")) {
            return null;
        }
        return null;
    }

    private URL findNL(String bundle, IPath path, Map<String, String> override, List<URL> multiple) {
        String[] nlVariants;
        String nl = null;
        if (override != null) {
            try {
                nl = override.get("$nl$");
            }
            catch (ClassCastException classCastException) {}
        }
        String[] stringArray = nlVariants = nl == null || nl.length() == 0 ? NL_VARIANTS : StandaloneFileLocator.buildNLVariants(nl);
        if (nlVariants == null) {
            return null;
        }
        URL result = null;
        int i = 0;
        while (i < nlVariants.length) {
            IPath filePath = new Path(nlVariants[i]).append(path);
            result = this.find(bundle, filePath, multiple);
            if (result != null && multiple == null) {
                return result;
            }
            ++i;
        }
        return this.find(bundle, path, multiple);
    }

    private URL findOS(String bundle, IPath path, Map<String, String> override, List<URL> multiple) {
        String os = null;
        if (override != null) {
            try {
                os = override.get("$os$");
            }
            catch (ClassCastException classCastException) {}
        }
        if (os == null) {
            os = OS;
        }
        if (os == null || os.length() == 0) {
            return null;
        }
        String arch = null;
        if (override != null) {
            try {
                arch = override.get("$arch$");
            }
            catch (ClassCastException classCastException) {}
        }
        if (arch == null) {
            arch = ARCH;
        }
        if (arch == null || arch.length() == 0) {
            return null;
        }
        URL result = null;
        IPath base = new Path("os").append(os).append(arch);
        while (base.segmentCount() != 1) {
            IPath filePath = base.append(path);
            result = this.find(bundle, filePath, multiple);
            if (result != null && multiple == null) {
                return result;
            }
            base = base.removeLastSegments(1);
        }
        return this.find(bundle, path, multiple);
    }

    private URL findWS(String bundle, IPath path, Map<String, String> override, List<URL> multiple) {
        String ws = null;
        if (override != null) {
            try {
                ws = override.get("$ws$");
            }
            catch (ClassCastException classCastException) {}
        }
        if (ws == null) {
            ws = WS;
        }
        if (ws == null || ws.length() == 0) {
            return null;
        }
        IPath filePath = new Path("ws").append(ws).append(path);
        URL result = this.find(bundle, filePath, multiple);
        if (result != null && multiple == null) {
            return result;
        }
        return this.find(bundle, path, multiple);
    }

    private URL find(String bundle, IPath path, List<URL> multiple) {
        List urls = this.bundleNameToURLsMap.get(bundle);
        if (urls == null || urls.isEmpty()) {
            return null;
        }
        URL first = null;
        for (URL url : urls) {
            URL found = this.find(url, path);
            if (found == null) continue;
            if (first == null) {
                first = found;
            }
            if (multiple == null) break;
            multiple.add(found);
        }
        return first;
    }

    private URL find(URL url, IPath path) {
        URL found = null;
        if (path.isEmpty() || path.isRoot()) {
            found = url;
        } else {
            try {
                found = new URL(url.getProtocol(), url.getHost(), url.getPort(), String.valueOf(url.getPath()) + path.toString());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        if (found != null) {
            try {
                found.openStream().close();
            }
            catch (IOException iOException) {
                found = null;
            }
        }
        return found;
    }

    private static String[] buildNLVariants(String nl) {
        if (nl == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        Path base = new Path("nl");
        Path path = new Path(nl.replace('_', '/'));
        while (path.segmentCount() > 0) {
            result.add(base.append((IPath)path).toString());
            if (path.segmentCount() > 1) {
                result.add(base.append(path.toString().replace('/', '_')).toString());
            }
            path = path.removeLastSegments(1);
        }
        return result.toArray(new String[result.size()]);
    }
}

