/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.expression.variables;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.query.ast.IUUID;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.QueryIterator;
import com.ibm.team.workitem.common.expression.variables.AbstractAttributeVariable;
import com.ibm.team.workitem.common.expression.variables.IEvaluationContext;
import com.ibm.team.workitem.common.expression.variables.Messages;
import com.ibm.team.workitem.common.internal.model.query.BaseCategoryQueryModel;
import com.ibm.team.workitem.common.internal.query.util.QueryUtils;
import com.ibm.team.workitem.common.internal.util.WorkItemQueries;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class MyCategoriesVariable
extends AbstractAttributeVariable<ICategoryHandle> {
    public static final String VARIABLE_ID = "my categories";
    private Collection<ICategoryHandle> fCategories;
    private boolean fIsCaching;

    public MyCategoriesVariable() {
        this(false);
    }

    public MyCategoriesVariable(boolean isCaching) {
        this.fIsCaching = isCaching;
    }

    @Override
    public Collection<ICategoryHandle> evaluate(IEvaluationContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fCategories == null || !this.fIsCaching) {
            IAuditableCommon auditableCommon = context.getAuditableCommon();
            IProjectAreaHandle projectArea = context.getProjectArea();
            QueryIterator<ITeamAreaHandle> teamAreasIterator = WorkItemQueries.teamAreasByContributorAndProjectArea(auditableCommon, auditableCommon.getUser(), projectArea);
            List<ITeamAreaHandle> teamAreas = teamAreasIterator.toList(monitor);
            BaseCategoryQueryModel.CategoryQueryModel model = BaseCategoryQueryModel.CategoryQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            IPredicate predicate = model.defaultTeamArea().contributors().itemId()._eq((IUUID)query.newUUIDArg());
            for (ITeamAreaHandle teamArea : teamAreas) {
                predicate = predicate._or(model.teamAreas().itemId()._eq(teamArea.getItemId()));
            }
            query.filter(predicate);
            query.distinct();
            QueryIterator iterator = auditableCommon.getItemQueryIterator(query, new Object[]{auditableCommon.getUser().getItemId()}, QueryUtils.getContextIds(projectArea), null);
            List categories = iterator.toList(monitor);
            if (categories.isEmpty()) {
                IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
                IAttribute categoryAttribute = workItemCommon.findAttribute(projectArea, IWorkItem.CATEGORY_PROPERTY, monitor);
                this.fCategories = Collections.singleton((ICategoryHandle)categoryAttribute.getNullValue(auditableCommon, monitor));
            } else {
                this.fCategories = categories;
            }
        }
        return this.fCategories;
    }

    @Override
    public String getDisplayName() {
        return Messages.getString("MyCategoriesVariable.MY_CATEGORIES");
    }

    @Override
    public String getId() {
        return VARIABLE_ID;
    }

    public boolean equals(Object obj) {
        return obj instanceof MyCategoriesVariable;
    }

    public int hashCode() {
        return VARIABLE_ID.hashCode();
    }
}

