/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.oslc.mappings;

import com.ibm.team.calm.foundation.common.CustomNamespaceContext;
import com.ibm.team.calm.foundation.common.Property;
import com.ibm.team.calm.foundation.common.oslc.Version;
import com.ibm.team.workitem.common.internal.oslc.mappings.AbstractVersionedDescriptor;
import com.ibm.team.workitem.common.internal.oslc.mappings.IAttributeDescriptor;
import com.ibm.team.workitem.common.internal.oslc.mappings.IAttributeTypeDescriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;

public class AttributeTypeDescriptor
extends AbstractVersionedDescriptor
implements IAttributeTypeDescriptor {
    private final Map<String, IAttributeDescriptor> fAttributeDescriptorsInternal = new LinkedHashMap<String, IAttributeDescriptor>();
    private final Map<Version, CustomNamespaceContext> fNsContexts = new HashMap<Version, CustomNamespaceContext>();
    private final String fTypeId;
    private final String fItemTypeId;
    private boolean fIsLiteralType;

    public AttributeTypeDescriptor(String typeId, String itemTypeId) {
        this.fItemTypeId = itemTypeId;
        Assert.isNotNull((Object)typeId);
        this.fTypeId = typeId;
    }

    @Override
    public String getAttributeTypeIdentifier() {
        return this.fTypeId;
    }

    @Override
    public String getItemTypeId() {
        return this.fItemTypeId;
    }

    void addAttributeDescriptor(IAttributeDescriptor descriptor) {
        this.fAttributeDescriptorsInternal.put(descriptor.getInternalIdentifier(), descriptor);
    }

    @Override
    public IAttributeDescriptor getAttributeDescriptor(String internalIdentifier) {
        return this.fAttributeDescriptorsInternal.get(internalIdentifier);
    }

    @Override
    public IAttributeDescriptor getAttributeDescriptor(Version version, String nsUri, String elementName) {
        Assert.isNotNull((Object)version);
        Assert.isNotNull((Object)elementName);
        if (nsUri == null) {
            return null;
        }
        for (IAttributeDescriptor descriptor : this.fAttributeDescriptorsInternal.values()) {
            Property property = descriptor.getProperty(version);
            if (property == null || !nsUri.equals(property.getNamespaceURI()) || !elementName.equals(property.getName())) continue;
            return descriptor;
        }
        return null;
    }

    @Override
    public Collection<IAttributeDescriptor> getAttributeDescriptors() {
        return this.fAttributeDescriptorsInternal.values();
    }

    @Override
    public CustomNamespaceContext getNamespaceContext(Version version) {
        return this.fNsContexts.get(version);
    }

    public void setNamespaceContext(Version version, CustomNamespaceContext nsContext) {
        this.fNsContexts.put(version, nsContext);
    }

    public void setLiteralType(boolean isLiteralType) {
        this.fIsLiteralType = isLiteralType;
    }

    @Override
    public boolean isLiteralType() {
        return this.fIsLiteralType;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("attribute type id: ").append(this.fTypeId).append('\n');
        buf.append("public id: ").append(this.getPublicIdentifier()).append('\n');
        buf.append("public ns: ").append(this.getNamespace()).append('\n');
        for (IAttributeDescriptor desc : this.fAttributeDescriptorsInternal.values()) {
            buf.append("   ").append(desc.toString()).append('\n');
        }
        return buf.toString();
    }
}

