/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.query;

import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IString;
import com.ibm.team.repository.common.query.ast.IStringField;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.variables.IEvaluationContext;
import com.ibm.team.workitem.common.internal.expression.ITransformationContext;
import com.ibm.team.workitem.common.internal.util.SeparatedStringList;
import com.ibm.team.workitem.common.model.AttributeOperation;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;

public class StringContainsOperation
extends AttributeOperation {
    private final boolean fInvert;

    public StringContainsOperation(String identifier, String displayName, boolean invert) {
        super(identifier, displayName);
        this.fInvert = invert;
    }

    @Override
    public boolean evaluate(Object left, Object right, IEvaluationContext context, IProgressMonitor monitor) {
        boolean result = this.internalEvaluate(left, right);
        return this.fInvert ? !result : result;
    }

    private boolean internalEvaluate(Object left, Object right) {
        if (left instanceof String) {
            left = Collections.singleton(left);
        }
        if (left instanceof Collection) {
            for (Object element : (Collection)left) {
                if (!(element instanceof String) || !(right instanceof String)) continue;
                String content = ((String)element).toLowerCase();
                String[] terms = ((String)right).split("\\s");
                boolean contained = terms.length > 0;
                int i = 0;
                while (i < terms.length) {
                    String term = terms[i].toLowerCase();
                    if (term.endsWith("*")) {
                        term = term.substring(0, term.length() - 1);
                    }
                    contained &= content.indexOf(term) != -1;
                    ++i;
                }
                if (!contained) continue;
                return true;
            }
        } else if (left instanceof Integer && left.toString().startsWith(right.toString())) {
            return true;
        }
        return false;
    }

    @Override
    public IPredicate getPredicate(ITransformationContext context, IProgressMonitor monitor) {
        IPredicate predicate = null;
        IQueryableAttribute attribute = context.getAttribute();
        if (attribute.isStateExtension()) {
            predicate = context.createIgnoreCaseLikePredicate('\\');
        } else {
            IStringField field = (IStringField)context.getField();
            predicate = field._ignoreCaseLike((IString)context.getQuery().newStringArg(), '\\');
        }
        String value = context.getValue().toString();
        if ("tags".equals(attribute.getAttributeType())) {
            value = SeparatedStringList.escape(value);
        }
        context.addLikeParameter("%%%s%%", value);
        if (this.fInvert) {
            predicate = this.invertNullAware(context, predicate);
            predicate = context.adaptLikePredicateForInversion(predicate);
        }
        return predicate;
    }

    @Override
    public boolean isNegation() {
        return this.fInvert;
    }
}

