/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IDataQuery;
import com.ibm.team.repository.common.query.IDataQueryPage;
import com.ibm.team.repository.common.query.IDataRow;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.QueryIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class DataRowQueryIterator
extends QueryIterator<IDataRow> {
    private static final int PAGE_SIZE = Integer.MAX_VALUE;
    private final IAuditableCommon fAuditableCommon;
    private final IDataQuery fQuery;
    private final Object[] fParameters;
    private final UUID[] fContextIds;
    private final QueryIterator.ReadMode fReadMode;
    private IDataQueryPage fPage;
    private Iterator<IDataRow> fIterator;

    public DataRowQueryIterator(IAuditableCommon auditableCommon, IDataQuery query, Object[] parameters, UUID[] contextIds, QueryIterator.ReadMode mode) {
        this.fAuditableCommon = auditableCommon;
        this.fQuery = query;
        this.fParameters = parameters != null ? parameters : IQueryService.EMPTY_PARAMETERS;
        this.fReadMode = mode != null ? mode : QueryIterator.ReadMode.COMMITTED;
        this.fContextIds = contextIds;
    }

    @Override
    public boolean hasNext(IProgressMonitor monitor) throws TeamRepositoryException {
        this.update(monitor);
        return this.fIterator.hasNext();
    }

    @Override
    public IDataRow next(IProgressMonitor monitor) throws TeamRepositoryException {
        this.update(monitor);
        return this.fIterator.next();
    }

    public int getResultSize(IProgressMonitor monitor) throws TeamRepositoryException {
        this.update(monitor);
        return this.fPage.getResultSize();
    }

    private void update(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fPage == null) {
            this.fPage = this.fReadMode == QueryIterator.ReadMode.COMMITTED ? this.fAuditableCommon.queryDataInContext(this.fQuery, this.fParameters, Integer.MAX_VALUE, this.fContextIds, monitor) : this.fAuditableCommon.uncommittedQueryData(this.fQuery, this.fParameters, Integer.MAX_VALUE, monitor);
            this.fIterator = this.toList(this.fPage).iterator();
        }
        while (!this.fIterator.hasNext() && this.fPage.hasNext()) {
            this.fPage = (IDataQueryPage)this.fAuditableCommon.fetchPage(this.fPage.getToken(), this.fPage.getNextStartPosition(), Integer.MAX_VALUE, monitor);
            this.fIterator = this.toList(this.fPage).iterator();
        }
    }

    private List<IDataRow> toList(IDataQueryPage page) {
        ArrayList<IDataRow> list = new ArrayList<IDataRow>();
        int i = 0;
        while (i < page.getSize()) {
            list.add(page.getRow(i));
            ++i;
        }
        return list;
    }
}

